/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.Objects;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Strings;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.CreateTrainedModelAssignmentAction;
import org.elasticsearch.xpack.core.ml.action.UpdateTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.inference.assignment.TrainedModelAssignment;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.ml.inference.assignment.TrainedModelAssignmentClusterService;
import org.elasticsearch.xpack.ml.notifications.InferenceAuditor;

public class TransportUpdateTrainedModelDeploymentAction
extends TransportMasterNodeAction<UpdateTrainedModelDeploymentAction.Request, CreateTrainedModelAssignmentAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportUpdateTrainedModelDeploymentAction.class);
    private final TrainedModelAssignmentClusterService trainedModelAssignmentClusterService;
    private final InferenceAuditor auditor;
    private final ProjectResolver projectResolver;

    @Inject
    public TransportUpdateTrainedModelDeploymentAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, TrainedModelAssignmentClusterService trainedModelAssignmentClusterService, InferenceAuditor auditor, ProjectResolver projectResolver) {
        super("cluster:admin/xpack/ml/trained_models/deployment/update", transportService, clusterService, threadPool, actionFilters, UpdateTrainedModelDeploymentAction.Request::new, CreateTrainedModelAssignmentAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.trainedModelAssignmentClusterService = Objects.requireNonNull(trainedModelAssignmentClusterService);
        this.auditor = Objects.requireNonNull(auditor);
        this.projectResolver = Objects.requireNonNull(projectResolver);
    }

    protected void masterOperation(Task task, UpdateTrainedModelDeploymentAction.Request request, ClusterState state, ActionListener<CreateTrainedModelAssignmentAction.Response> listener) throws Exception {
        logger.debug(() -> Strings.format((String)"[%s] received request to update number of allocations to [%s]", (Object[])new Object[]{request.getDeploymentId(), request.getNumberOfAllocations()}));
        this.trainedModelAssignmentClusterService.updateDeployment(request.getDeploymentId(), request.getNumberOfAllocations(), request.getAdaptiveAllocationsSettings(), request.isInternal(), (ActionListener<TrainedModelAssignment>)ActionListener.wrap(updatedAssignment -> {
            this.auditor.info(request.getDeploymentId(), Messages.getMessage((String)"Updated number_of_allocations to [{0}]", (Object[])new Object[]{request.getNumberOfAllocations()}));
            listener.onResponse((Object)new CreateTrainedModelAssignmentAction.Response(updatedAssignment));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    protected ClusterBlockException checkBlock(UpdateTrainedModelDeploymentAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(this.projectResolver.getProjectId(), ClusterBlockLevel.METADATA_WRITE);
    }
}

