/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.application.rules.AppliedQueryRules;
import org.elasticsearch.xpack.application.rules.QueryRuleCriteria;
import org.elasticsearch.xpack.application.rules.QueryRuleCriteriaType;
import org.elasticsearch.xpack.searchbusinessrules.SpecifiedDocument;

public class QueryRule
implements Writeable,
ToXContentObject {
    public static final int MAX_NUM_DOCS_IN_RULE = 100;
    public static final ParseField IDS_FIELD = new ParseField("ids", new String[0]);
    public static final ParseField DOCS_FIELD = new ParseField("docs", new String[0]);
    public static final ParseField INDEX_FIELD = new ParseField("_index", new String[0]);
    private final String id;
    private final QueryRuleType type;
    private final List<QueryRuleCriteria> criteria;
    private final Map<String, Object> actions;
    private final Integer priority;
    public static final int MIN_PRIORITY = 0;
    public static final int MAX_PRIORITY = 1000000;
    public static final NodeFeature NUMERIC_VALIDATION = new NodeFeature("query_rules.numeric_validation", true);
    private static final ConstructingObjectParser<QueryRule, String> PARSER = new ConstructingObjectParser("query_rule", false, (params, resourceName) -> {
        String id = (String)params[0];
        QueryRuleType type = QueryRuleType.queryRuleType((String)params[1]);
        List criteria = (List)params[2];
        Map actions = (Map)params[3];
        Integer priority = (Integer)params[4];
        return new QueryRule(id, type, criteria, actions, priority);
    });
    public static final ParseField ID_FIELD = new ParseField("rule_id", new String[0]);
    public static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    public static final ParseField CRITERIA_FIELD = new ParseField("criteria", new String[0]);
    public static final ParseField ACTIONS_FIELD = new ParseField("actions", new String[0]);
    public static final ParseField PRIORITY_FIELD = new ParseField("priority", new String[0]);

    public QueryRule(@Nullable String id, QueryRuleType type, List<QueryRuleCriteria> criteria, Map<String, Object> actions, @Nullable Integer priority) {
        this.id = id;
        Objects.requireNonNull(type, "Query rule type cannot be null");
        this.type = type;
        Objects.requireNonNull(criteria, "Query rule criteria cannot be null");
        if (criteria.isEmpty()) {
            throw new IllegalArgumentException("Query rule criteria cannot be empty");
        }
        this.criteria = criteria;
        Objects.requireNonNull(actions, "Query rule actions cannot be null");
        if (actions.isEmpty()) {
            throw new IllegalArgumentException("Query rule actions cannot be empty");
        }
        this.actions = actions;
        this.priority = priority;
        this.validate();
    }

    public QueryRule(String id, QueryRule other) {
        this(id, other.type, other.criteria, other.actions, other.priority);
    }

    public QueryRule(StreamInput in) throws IOException {
        this.id = in.readString();
        this.type = QueryRuleType.queryRuleType(in.readString());
        this.criteria = in.readCollectionAsList(QueryRuleCriteria::new);
        this.actions = in.readGenericMap();
        this.priority = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_15_0) ? in.readOptionalVInt() : null;
        this.validate();
    }

    private void validate() {
        if (this.priority != null && (this.priority < 0 || this.priority > 1000000)) {
            throw new IllegalArgumentException("Priority was " + this.priority + ", must be between 0 and 1000000");
        }
        if (Set.of(QueryRuleType.PINNED, QueryRuleType.EXCLUDE).contains((Object)this.type)) {
            boolean ruleContainsDocs;
            boolean ruleContainsIds = this.actions.containsKey(IDS_FIELD.getPreferredName());
            if (ruleContainsIds ^ (ruleContainsDocs = this.actions.containsKey(DOCS_FIELD.getPreferredName()))) {
                this.validateIdOrDocAction(this.actions.get(IDS_FIELD.getPreferredName()));
                this.validateIdOrDocAction(this.actions.get(DOCS_FIELD.getPreferredName()));
            } else {
                throw new ElasticsearchParseException(this.type.toString() + " query rule actions must contain only one of either ids or docs", new Object[0]);
            }
        }
        this.criteria.forEach(criterion -> {
            List<Object> values = criterion.criteriaValues();
            if (values != null) {
                values.forEach(criterion.criteriaType()::validateInput);
            }
        });
    }

    private void validateIdOrDocAction(Object action) {
        if (action != null) {
            if (!(action instanceof List)) {
                throw new ElasticsearchParseException(String.valueOf((Object)this.type) + " query rule actions must be a list", new Object[0]);
            }
            if (((List)action).isEmpty()) {
                throw new ElasticsearchParseException(String.valueOf((Object)this.type) + " query rule actions cannot be empty", new Object[0]);
            }
            if (((List)action).size() > 100) {
                throw new ElasticsearchParseException(String.valueOf((Object)this.type) + " documents cannot exceed 100", new Object[0]);
            }
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeString(this.type.toString());
        out.writeCollection(this.criteria);
        out.writeGenericMap(this.actions);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_15_0)) {
            out.writeOptionalVInt(this.priority);
        }
    }

    public static QueryRule fromXContentBytes(BytesReference source, XContentType xContentType) {
        QueryRule queryRule;
        block8: {
            XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)source, (XContentType)xContentType);
            try {
                queryRule = QueryRule.fromXContent(parser);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse: " + source.utf8ToString(), (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return queryRule;
    }

    public static QueryRule fromXContent(XContentParser parser) {
        return (QueryRule)PARSER.apply(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ID_FIELD.getPreferredName(), this.id);
        builder.field(TYPE_FIELD.getPreferredName(), (Enum)this.type);
        builder.xContentList(CRITERIA_FIELD.getPreferredName(), this.criteria);
        builder.field(ACTIONS_FIELD.getPreferredName());
        builder.map(this.actions);
        if (this.priority != null) {
            builder.field(PRIORITY_FIELD.getPreferredName(), this.priority);
        }
        builder.endObject();
        return builder;
    }

    public String id() {
        return this.id;
    }

    public QueryRuleType type() {
        return this.type;
    }

    public List<QueryRuleCriteria> criteria() {
        return this.criteria;
    }

    public Map<String, Object> actions() {
        return this.actions;
    }

    public Integer priority() {
        return this.priority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryRule queryRule = (QueryRule)o;
        return Objects.equals(this.id, queryRule.id) && this.type == queryRule.type && Objects.equals(this.criteria, queryRule.criteria) && Objects.equals(this.actions, queryRule.actions) && Objects.equals(this.priority, queryRule.priority);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.criteria, this.actions, this.priority});
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public AppliedQueryRules applyRule(AppliedQueryRules appliedRules, Map<String, Object> matchCriteria) {
        List<SpecifiedDocument> pinnedDocs = appliedRules.pinnedDocs();
        List<SpecifiedDocument> excludedDocs = appliedRules.excludedDocs();
        List<SpecifiedDocument> matchingDocs = this.identifyMatchingDocs(matchCriteria);
        switch (this.type.ordinal()) {
            case 1: {
                pinnedDocs.addAll(matchingDocs);
                break;
            }
            case 0: {
                excludedDocs.addAll(matchingDocs);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported query rule type: " + String.valueOf((Object)this.type));
            }
        }
        return new AppliedQueryRules(pinnedDocs, excludedDocs);
    }

    public boolean isRuleMatch(Map<String, Object> matchCriteria) {
        Boolean isRuleMatch = null;
        for (QueryRuleCriteria criterion : this.criteria) {
            for (String match : matchCriteria.keySet()) {
                Object matchValue = matchCriteria.get(match);
                QueryRuleCriteriaType criteriaType = criterion.criteriaType();
                String criteriaMetadata = criterion.criteriaMetadata();
                if (criteriaType != QueryRuleCriteriaType.ALWAYS && (criteriaMetadata == null || !criteriaMetadata.equals(match))) continue;
                boolean singleCriterionMatches = criterion.isMatch(matchValue, criteriaType, false);
                isRuleMatch = isRuleMatch == null ? singleCriterionMatches : isRuleMatch != false && singleCriterionMatches;
            }
        }
        return isRuleMatch != null && isRuleMatch != false;
    }

    private List<SpecifiedDocument> identifyMatchingDocs(Map<String, Object> matchCriteria) {
        ArrayList<SpecifiedDocument> matchingDocs = new ArrayList<SpecifiedDocument>();
        if (this.isRuleMatch(matchCriteria)) {
            if (this.actions.containsKey(IDS_FIELD.getPreferredName())) {
                matchingDocs.addAll(((List)this.actions.get(IDS_FIELD.getPreferredName())).stream().map(id -> new SpecifiedDocument(null, id)).toList());
            } else if (this.actions.containsKey(DOCS_FIELD.getPreferredName())) {
                List docsToPin = (List)this.actions.get(DOCS_FIELD.getPreferredName());
                List<SpecifiedDocument> specifiedDocuments = docsToPin.stream().map(map -> new SpecifiedDocument((String)map.get(INDEX_FIELD.getPreferredName()), (String)map.get(SpecifiedDocument.ID_FIELD.getPreferredName()))).toList();
                matchingDocs.addAll(specifiedDocuments);
            }
        }
        return matchingDocs;
    }

    static {
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), ID_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), TYPE_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> QueryRuleCriteria.fromXContent(p), CRITERIA_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), ACTIONS_FIELD);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), PRIORITY_FIELD);
    }

    public static enum QueryRuleType {
        EXCLUDE,
        PINNED;


        public static QueryRuleType queryRuleType(String type) {
            for (QueryRuleType queryRuleType : QueryRuleType.values()) {
                if (!queryRuleType.name().equalsIgnoreCase(type)) continue;
                return queryRuleType;
            }
            throw new IllegalArgumentException("Unknown QueryRuleType: " + type);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

