/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.UnaryExec;

public abstract class RegexExtractExec
extends UnaryExec
implements EstimatesRowSize {
    protected final Expression inputExpression;
    protected final List<Attribute> extractedFields;

    protected RegexExtractExec(Source source, PhysicalPlan child, Expression inputExpression, List<Attribute> extractedFields) {
        super(source, child);
        this.inputExpression = inputExpression;
        this.extractedFields = extractedFields;
    }

    @Override
    public List<Attribute> output() {
        return NamedExpressions.mergeOutputAttributes(this.extractedFields, this.child().output());
    }

    @Override
    protected AttributeSet computeReferences() {
        return this.inputExpression.references();
    }

    public Expression inputExpression() {
        return this.inputExpression;
    }

    public List<Attribute> extractedFields() {
        return this.extractedFields;
    }

    @Override
    public PhysicalPlan estimateRowSize(EstimatesRowSize.State state) {
        state.add(false, this.extractedFields);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RegexExtractExec that = (RegexExtractExec)o;
        return Objects.equals(this.inputExpression, that.inputExpression) && Objects.equals(this.extractedFields, that.extractedFields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.inputExpression, this.extractedFields);
    }
}

