/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.logical;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.predicate.logical.Not;

public final class NotEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(NotEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator v;
    private final DriverContext driverContext;
    private Warnings warnings;

    public NotEvaluator(Source source, EvalOperator.ExpressionEvaluator v, DriverContext driverContext) {
        this.source = source;
        this.v = v;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BooleanBlock vBlock = (BooleanBlock)this.v.eval(page);){
            BooleanVector vVector = vBlock.asVector();
            if (vVector == null) {
                BooleanBlock booleanBlock = this.eval(page.getPositionCount(), vBlock);
                return booleanBlock;
            }
            BooleanBlock booleanBlock = this.eval(page.getPositionCount(), vVector).asBlock();
            return booleanBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.v.baseRamBytesUsed();
    }

    public BooleanBlock eval(int positionCount, BooleanBlock vBlock) {
        try (BooleanBlock.Builder result = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (vBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (vBlock.getValueCount(p) != 1) {
                    if (vBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                result.appendBoolean(Not.process(vBlock.getBoolean(vBlock.getFirstValueIndex(p))));
            }
            BooleanBlock booleanBlock = result.build();
            return booleanBlock;
        }
    }

    public BooleanVector eval(int positionCount, BooleanVector vVector) {
        try (BooleanVector.FixedBuilder result = this.driverContext.blockFactory().newBooleanVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                result.appendBoolean(p, Not.process(vVector.getBoolean(p)));
            }
            BooleanVector booleanVector = result.build();
            return booleanVector;
        }
    }

    public String toString() {
        return "NotEvaluator[v=" + String.valueOf(this.v) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.v);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory v;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory v) {
            this.source = source;
            this.v = v;
        }

        public NotEvaluator get(DriverContext context) {
            return new NotEvaluator(this.source, this.v.get(context), context);
        }

        public String toString() {
            return "NotEvaluator[v=" + String.valueOf(this.v) + "]";
        }
    }
}

