/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.action;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.esql.action.EsqlCapabilities;
import org.elasticsearch.xpack.esql.action.EsqlQueryAction;
import org.elasticsearch.xpack.esql.action.EsqlQueryRequest;
import org.elasticsearch.xpack.esql.action.EsqlResponseListener;
import org.elasticsearch.xpack.esql.action.RequestXContent;

@ServerlessScope(value=Scope.PUBLIC)
public class RestEsqlQueryAction
extends BaseRestHandler {
    private static final Logger LOGGER = LogManager.getLogger(RestEsqlQueryAction.class);

    public String getName() {
        return "esql_query";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_query"));
    }

    public Set<String> supportedCapabilities() {
        return EsqlCapabilities.CAPABILITIES;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        try (XContentParser parser = request.contentOrSourceParamParser();){
            BaseRestHandler.RestChannelConsumer restChannelConsumer = RestEsqlQueryAction.restChannelConsumer(RequestXContent.parseSync(parser), request, client);
            return restChannelConsumer;
        }
    }

    protected static BaseRestHandler.RestChannelConsumer restChannelConsumer(EsqlQueryRequest esqlRequest, RestRequest request, NodeClient client) {
        Boolean partialResults = request.paramAsBoolean("allow_partial_results", null);
        if (partialResults != null) {
            esqlRequest.allowPartialResults(partialResults);
        }
        LOGGER.debug("Beginning execution of ESQL query.\nQuery string: [{}]", new Object[]{esqlRequest.query()});
        return channel -> {
            RestCancellableNodeClient cancellableClient = new RestCancellableNodeClient(client, request.getHttpChannel());
            cancellableClient.execute((ActionType)EsqlQueryAction.INSTANCE, (ActionRequest)esqlRequest, new EsqlResponseListener((RestChannel)channel, request, esqlRequest).wrapWithLogging());
        };
    }

    protected Set<String> responseParams() {
        return Set.of("delimiter", "drop_null_columns");
    }
}

