/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.util.ArrayUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.transport.RemoteClusterPortSettings;
import org.elasticsearch.xpack.core.security.action.apikey.ApiKey;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.CrossClusterAccessSubjectInfo;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.store.RoleReference;
import org.elasticsearch.xpack.core.security.authz.store.RoleReferenceIntersection;
import org.elasticsearch.xpack.core.security.user.AnonymousUser;
import org.elasticsearch.xpack.core.security.user.InternalUser;
import org.elasticsearch.xpack.core.security.user.User;

public class Subject {
    private final TransportVersion version;
    private final User user;
    private final Authentication.RealmRef realm;
    private final Type type;
    private final Map<String, Object> metadata;
    static final BytesArray FLEET_SERVER_ROLE_DESCRIPTOR_BYTES_V_7_14 = new BytesArray("{\"elastic/fleet-server\":{\"cluster\":[\"monitor\",\"manage_own_api_key\"],\"indices\":[{\"names\":[\"logs-*\",\"metrics-*\",\"traces-*\",\"synthetics-*\",\".logs-endpoint.diagnostic.collection-*\"],\"privileges\":[\"write\",\"create_index\",\"auto_configure\"],\"allow_restricted_indices\":false},{\"names\":[\".fleet-*\"],\"privileges\":[\"read\",\"write\",\"monitor\",\"create_index\",\"auto_configure\"],\"allow_restricted_indices\":false}],\"applications\":[],\"run_as\":[],\"metadata\":{},\"transient_metadata\":{\"enabled\":true}}}");

    public Subject(User user, Authentication.RealmRef realm) {
        this(user, realm, TransportVersion.current(), Map.of());
    }

    public Subject(User user, Authentication.RealmRef realm, TransportVersion version, Map<String, Object> metadata) {
        this.version = version;
        this.user = user;
        this.realm = realm;
        if (realm == null) {
            this.type = Type.USER;
        } else if ("_es_api_key".equals(realm.getType())) {
            assert ("_es_api_key".equals(realm.getName())) : "api key realm name mismatch";
            this.type = Type.API_KEY;
        } else if ("_cloud_api_key".equals(realm.getType())) {
            assert ("_cloud_api_key".equals(realm.getName())) : "cloud api key realm name mismatch";
            this.type = Type.CLOUD_API_KEY;
        } else if ("_service_account".equals(realm.getType())) {
            assert ("_service_account".equals(realm.getName())) : "service account realm name mismatch";
            this.type = Type.SERVICE_ACCOUNT;
        } else if ("_es_cross_cluster_access".equals(realm.getType())) {
            assert ("_es_cross_cluster_access".equals(realm.getName())) : "cross cluster access realm name mismatch";
            this.type = Type.CROSS_CLUSTER_ACCESS;
        } else {
            this.type = Type.USER;
        }
        this.metadata = metadata;
    }

    public User getUser() {
        return this.user;
    }

    public Authentication.RealmRef getRealm() {
        return this.realm;
    }

    public Type getType() {
        return this.type;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public TransportVersion getTransportVersion() {
        return this.version;
    }

    public RoleReferenceIntersection getRoleReferenceIntersection(@Nullable AnonymousUser anonymousUser) {
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 2 -> this.buildRoleReferencesForUser(anonymousUser);
            case 1 -> this.buildRoleReferencesForApiKey();
            case 3 -> new RoleReferenceIntersection(new RoleReference.ServiceAccountRoleReference(this.user.principal()));
            case 4 -> this.buildRoleReferencesForCrossClusterAccess();
        };
    }

    public boolean canAccessResourcesOf(Subject resourceCreatorSubject) {
        if (this.eitherIsAnApiKey(resourceCreatorSubject)) {
            if (this.bothAreApiKeys(resourceCreatorSubject)) {
                return this.isTheSameApiKey(resourceCreatorSubject);
            }
            return false;
        }
        if (this.eitherIsCrossClusterAccess(resourceCreatorSubject)) {
            if (this.bothAreCrossClusterAccess(resourceCreatorSubject)) {
                if (!this.isTheSameApiKey(resourceCreatorSubject)) {
                    return false;
                }
                return ((Authentication)this.getMetadata().get("_security_cross_cluster_access_authentication")).canAccessResourcesOf((Authentication)resourceCreatorSubject.getMetadata().get("_security_cross_cluster_access_authentication"));
            }
            return false;
        }
        if (this.eitherIsACloudApiKey(resourceCreatorSubject)) {
            if (this.bothAreCloudApiKeys(resourceCreatorSubject)) {
                return this.getUser().principal().equals(resourceCreatorSubject.getUser().principal());
            }
            return false;
        }
        if (!this.getUser().principal().equals(resourceCreatorSubject.getUser().principal())) {
            return false;
        }
        Authentication.RealmRef myAuthRealm = this.getRealm();
        Authentication.RealmRef creatorAuthRealm = resourceCreatorSubject.getRealm();
        if (null == myAuthRealm.getDomain()) {
            return Authentication.equivalentRealms(myAuthRealm.getName(), myAuthRealm.getType(), creatorAuthRealm.getName(), creatorAuthRealm.getType());
        }
        for (RealmConfig.RealmIdentifier domainRealm : myAuthRealm.getDomain().realms()) {
            if (!Authentication.equivalentRealms(domainRealm.getName(), domainRealm.getType(), creatorAuthRealm.getName(), creatorAuthRealm.getType())) continue;
            return true;
        }
        return false;
    }

    private boolean isTheSameApiKey(Subject resourceCreatorSubject) {
        boolean sameKeyId = this.getMetadata().get("_security_api_key_id").equals(resourceCreatorSubject.getMetadata().get("_security_api_key_id"));
        assert (!sameKeyId || this.getUser().principal().equals(resourceCreatorSubject.getUser().principal())) : "The same API key ID cannot be attributed to two different usernames";
        return sameKeyId;
    }

    private boolean eitherIsAnApiKey(Subject resourceCreatorSubject) {
        return Type.API_KEY.equals((Object)this.getType()) || Type.API_KEY.equals((Object)resourceCreatorSubject.getType());
    }

    private boolean bothAreApiKeys(Subject resourceCreatorSubject) {
        return Type.API_KEY.equals((Object)this.getType()) && Type.API_KEY.equals((Object)resourceCreatorSubject.getType());
    }

    private boolean eitherIsCrossClusterAccess(Subject resourceCreatorSubject) {
        return Type.CROSS_CLUSTER_ACCESS.equals((Object)this.getType()) || Type.CROSS_CLUSTER_ACCESS.equals((Object)resourceCreatorSubject.getType());
    }

    private boolean bothAreCrossClusterAccess(Subject resourceCreatorSubject) {
        return Type.CROSS_CLUSTER_ACCESS.equals((Object)this.getType()) && Type.CROSS_CLUSTER_ACCESS.equals((Object)resourceCreatorSubject.getType());
    }

    private boolean eitherIsACloudApiKey(Subject resourceCreatorSubject) {
        return Type.CLOUD_API_KEY.equals((Object)this.getType()) || Type.CLOUD_API_KEY.equals((Object)resourceCreatorSubject.getType());
    }

    private boolean bothAreCloudApiKeys(Subject resourceCreatorSubject) {
        return Type.CLOUD_API_KEY.equals((Object)this.getType()) && Type.CLOUD_API_KEY.equals((Object)resourceCreatorSubject.getType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subject subject = (Subject)o;
        return this.version.equals((Object)subject.version) && this.user.equals(subject.user) && Objects.equals(this.realm, subject.realm) && this.type == subject.type && this.metadata.equals(subject.metadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version, this.user, this.realm, this.type, this.metadata});
    }

    public String toString() {
        return "Subject{version=" + String.valueOf(this.version) + ", user=" + String.valueOf(this.user) + ", realm=" + String.valueOf(this.realm) + ", type=" + String.valueOf((Object)this.type) + ", metadata=" + String.valueOf(this.metadata) + "}";
    }

    private RoleReferenceIntersection buildRoleReferencesForUser(AnonymousUser anonymousUser) {
        String[] allRoleNames;
        if (this.user.equals(anonymousUser)) {
            return new RoleReferenceIntersection(new RoleReference.NamedRoleReference(this.user.roles()));
        }
        if (anonymousUser == null || !anonymousUser.enabled()) {
            allRoleNames = this.user.roles();
        } else {
            if (anonymousUser.roles().length == 0) {
                throw new IllegalStateException("anonymous is only enabled when the anonymous user has roles");
            }
            allRoleNames = (String[])ArrayUtils.concat((Object[])this.user.roles(), (Object[])anonymousUser.roles());
        }
        return new RoleReferenceIntersection(new RoleReference.NamedRoleReference(allRoleNames));
    }

    private RoleReferenceIntersection buildRoleReferencesForApiKey() {
        if (this.version.before((VersionId)Authentication.VERSION_API_KEY_ROLES_AS_BYTES)) {
            return this.buildRolesReferenceForApiKeyBwc();
        }
        String apiKeyId = (String)this.metadata.get("_security_api_key_id");
        assert (ApiKey.Type.REST == this.getApiKeyType()) : "only a REST API key should have its role built here";
        BytesReference roleDescriptorsBytes = (BytesReference)this.metadata.get("_security_api_key_role_descriptors");
        BytesReference limitedByRoleDescriptorsBytes = this.getLimitedByRoleDescriptorsBytes();
        if (roleDescriptorsBytes == null && limitedByRoleDescriptorsBytes == null) {
            throw new ElasticsearchSecurityException("no role descriptors found for API key", new Object[0]);
        }
        RoleReference.ApiKeyRoleReference limitedByRoleReference = new RoleReference.ApiKeyRoleReference(apiKeyId, limitedByRoleDescriptorsBytes, RoleReference.ApiKeyRoleType.LIMITED_BY);
        if (Subject.isEmptyRoleDescriptorsBytes(roleDescriptorsBytes)) {
            return new RoleReferenceIntersection(limitedByRoleReference);
        }
        return new RoleReferenceIntersection(new RoleReference.ApiKeyRoleReference(apiKeyId, roleDescriptorsBytes, RoleReference.ApiKeyRoleType.ASSIGNED), limitedByRoleReference);
    }

    RoleReference.CrossClusterApiKeyRoleReference buildRoleReferenceForCrossClusterApiKey() {
        assert (this.version.onOrAfter((VersionId)RemoteClusterPortSettings.TRANSPORT_VERSION_ADVANCED_REMOTE_CLUSTER_SECURITY));
        String apiKeyId = (String)this.metadata.get("_security_api_key_id");
        assert (ApiKey.Type.CROSS_CLUSTER == this.getApiKeyType()) : "cross cluster access must use cross-cluster API keys";
        BytesReference roleDescriptorsBytes = (BytesReference)this.metadata.get("_security_api_key_role_descriptors");
        if (roleDescriptorsBytes == null) {
            throw new ElasticsearchSecurityException("no role descriptors found for API key", new Object[0]);
        }
        BytesReference limitedByRoleDescriptorsBytes = (BytesReference)this.metadata.get("_security_api_key_limited_by_role_descriptors");
        assert (Subject.isEmptyRoleDescriptorsBytes(limitedByRoleDescriptorsBytes)) : "cross cluster API keys must have empty limited-by role descriptors";
        return new RoleReference.CrossClusterApiKeyRoleReference(apiKeyId, roleDescriptorsBytes);
    }

    private RoleReferenceIntersection buildRoleReferencesForCrossClusterAccess() {
        assert (ApiKey.Type.CROSS_CLUSTER == this.getApiKeyType()) : "cross cluster access must use cross-cluster API keys";
        ArrayList<RoleReference> roleReferences = new ArrayList<RoleReference>(4);
        List crossClusterAccessRoleDescriptorsBytes = (List)this.metadata.get("_security_cross_cluster_access_role_descriptors");
        Authentication innerAuthentication = (Authentication)this.metadata.get("_security_cross_cluster_access_authentication");
        User innerUser = innerAuthentication.getEffectiveSubject().getUser();
        if (innerUser instanceof InternalUser) {
            InternalUser internalUser = (InternalUser)innerUser;
            assert (crossClusterAccessRoleDescriptorsBytes.isEmpty()) : "role descriptors bytes list for internal cross cluster access user must be empty";
            RoleDescriptor internalRoleDescriptor = internalUser.getRemoteAccessRoleDescriptor().orElseThrow(() -> new ElasticsearchSecurityException("The internal user [" + String.valueOf(internalUser) + "] is not permitted to perform cross cluster actions", new Object[0]));
            roleReferences.add(new RoleReference.FixedRoleReference(internalRoleDescriptor, "cross_cluster_access_internal"));
        } else if (crossClusterAccessRoleDescriptorsBytes.isEmpty()) {
            roleReferences.add(new RoleReference.CrossClusterAccessRoleReference(innerUser.principal(), CrossClusterAccessSubjectInfo.RoleDescriptorsBytes.EMPTY));
        } else {
            assert (crossClusterAccessRoleDescriptorsBytes.size() <= 2) : "not expected to have list of cross cluster access role descriptors bytes which have more than 2 elements";
            for (CrossClusterAccessSubjectInfo.RoleDescriptorsBytes roleDescriptorsBytes : crossClusterAccessRoleDescriptorsBytes) {
                roleReferences.add(new RoleReference.CrossClusterAccessRoleReference(innerUser.principal(), roleDescriptorsBytes));
            }
        }
        roleReferences.add(this.buildRoleReferenceForCrossClusterApiKey());
        return new RoleReferenceIntersection(List.copyOf(roleReferences));
    }

    private static boolean isEmptyRoleDescriptorsBytes(BytesReference roleDescriptorsBytes) {
        return roleDescriptorsBytes == null || roleDescriptorsBytes.length() == 2 && "{}".equals(roleDescriptorsBytes.utf8ToString());
    }

    private RoleReferenceIntersection buildRolesReferenceForApiKeyBwc() {
        String apiKeyId = (String)this.metadata.get("_security_api_key_id");
        Map<String, Object> roleDescriptorsMap = this.getRoleDescriptorMap("_security_api_key_role_descriptors");
        Map<String, Object> limitedByRoleDescriptorsMap = this.getRoleDescriptorMap("_security_api_key_limited_by_role_descriptors");
        if (roleDescriptorsMap == null && limitedByRoleDescriptorsMap == null) {
            throw new ElasticsearchSecurityException("no role descriptors found for API key", new Object[0]);
        }
        RoleReference.BwcApiKeyRoleReference limitedByRoleReference = new RoleReference.BwcApiKeyRoleReference(apiKeyId, limitedByRoleDescriptorsMap, RoleReference.ApiKeyRoleType.LIMITED_BY);
        if (roleDescriptorsMap == null || roleDescriptorsMap.isEmpty()) {
            return new RoleReferenceIntersection(limitedByRoleReference);
        }
        return new RoleReferenceIntersection(new RoleReference.BwcApiKeyRoleReference(apiKeyId, roleDescriptorsMap, RoleReference.ApiKeyRoleType.ASSIGNED), limitedByRoleReference);
    }

    private Map<String, Object> getRoleDescriptorMap(String key) {
        return (Map)this.metadata.get(key);
    }

    private BytesReference getLimitedByRoleDescriptorsBytes() {
        assert (ApiKey.Type.REST == this.getApiKeyType()) : "bug fixing for fleet-server limited-by role descriptors applies only to REST API keys";
        BytesReference bytesReference = (BytesReference)this.metadata.get("_security_api_key_limited_by_role_descriptors");
        if (bytesReference.length() == 2 && "{}".equals(bytesReference.utf8ToString()) && "_service_account".equals(this.metadata.get("_security_api_key_creator_realm_name")) && "elastic/fleet-server".equals(this.user.principal())) {
            return FLEET_SERVER_ROLE_DESCRIPTOR_BYTES_V_7_14;
        }
        return bytesReference;
    }

    private ApiKey.Type getApiKeyType() {
        String typeString = (String)this.metadata.get("_security_api_key_type");
        assert (typeString != null || this.version.before((VersionId)RemoteClusterPortSettings.TRANSPORT_VERSION_ADVANCED_REMOTE_CLUSTER_SECURITY)) : "API key type must be non-null except for versions older than " + String.valueOf(RemoteClusterPortSettings.TRANSPORT_VERSION_ADVANCED_REMOTE_CLUSTER_SECURITY);
        return typeString == null ? ApiKey.Type.REST : ApiKey.Type.parse(typeString);
    }

    public static enum Type {
        USER,
        API_KEY,
        CLOUD_API_KEY,
        SERVICE_ACCOUNT,
        CROSS_CLUSTER_ACCESS;

    }
}

