/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.apikey;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.action.admin.cluster.node.info.ComponentVersionNumber;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.AbstractObjectParser;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.security.action.apikey.CrossClusterApiKeyRoleDescriptorBuilder;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptorsIntersection;

public final class ApiKey
implements ToXContentObject {
    public static final Version CURRENT_API_KEY_VERSION = new Version(8150099);
    private final String name;
    private final String id;
    private final Type type;
    private final Instant creation;
    private final Instant expiration;
    private final boolean invalidated;
    private final Instant invalidation;
    private final String username;
    private final String realm;
    @Nullable
    private final String realmType;
    private final Map<String, Object> metadata;
    @Nullable
    private final List<RoleDescriptor> roleDescriptors;
    @Nullable
    private final RoleDescriptorsIntersection limitedBy;
    private static final RoleDescriptor.Parser ROLE_DESCRIPTOR_PARSER = RoleDescriptor.parserBuilder().allowRestriction(true).build();
    static final ConstructingObjectParser<ApiKey, Void> PARSER = new ConstructingObjectParser("api_key", true, ApiKey::new);

    public ApiKey(String name, String id, Type type, Instant creation, Instant expiration, boolean invalidated, @Nullable Instant invalidation, String username, String realm, @Nullable String realmType, @Nullable Map<String, Object> metadata, @Nullable List<RoleDescriptor> roleDescriptors, @Nullable List<RoleDescriptor> limitedByRoleDescriptors) {
        this(name, id, type, creation, expiration, invalidated, invalidation, username, realm, realmType, metadata, roleDescriptors, limitedByRoleDescriptors == null ? null : new RoleDescriptorsIntersection(List.of(Set.copyOf(limitedByRoleDescriptors))));
    }

    private ApiKey(String name, String id, Type type, Instant creation, Instant expiration, boolean invalidated, Instant invalidation, String username, String realm, @Nullable String realmType, @Nullable Map<String, Object> metadata, @Nullable List<RoleDescriptor> roleDescriptors, @Nullable RoleDescriptorsIntersection limitedBy) {
        this.name = name;
        this.id = id;
        this.type = type;
        this.creation = Instant.ofEpochMilli(creation.toEpochMilli());
        this.expiration = expiration != null ? Instant.ofEpochMilli(expiration.toEpochMilli()) : null;
        this.invalidated = invalidated;
        this.invalidation = invalidation != null ? Instant.ofEpochMilli(invalidation.toEpochMilli()) : null;
        this.username = username;
        this.realm = realm;
        this.realmType = realmType;
        this.metadata = metadata == null ? Map.of() : metadata;
        List<RoleDescriptor> list = this.roleDescriptors = roleDescriptors != null ? List.copyOf(roleDescriptors) : null;
        assert (limitedBy == null || limitedBy.roleDescriptorsList().size() == 1) : "can only have one set of limited-by role descriptors";
        this.limitedBy = limitedBy;
    }

    ApiKey(Object[] parsed) {
        this((String)parsed[0], (String)parsed[1], (Type)((Object)parsed[2]), Instant.ofEpochMilli((Long)parsed[3]), parsed[4] == null ? null : Instant.ofEpochMilli((Long)parsed[4]), (boolean)((Boolean)parsed[5]), parsed[6] == null ? null : Instant.ofEpochMilli((Long)parsed[6]), (String)parsed[7], (String)parsed[8], (String)parsed[9], (Map<String, Object>)(parsed[10] == null ? null : (Map)parsed[10]), (List<RoleDescriptor>)((List)parsed[11]), (RoleDescriptorsIntersection)parsed[12]);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public Instant getCreation() {
        return this.creation;
    }

    public Instant getExpiration() {
        return this.expiration;
    }

    public boolean isInvalidated() {
        return this.invalidated;
    }

    public Instant getInvalidation() {
        return this.invalidation;
    }

    public String getUsername() {
        return this.username;
    }

    public String getRealm() {
        return this.realm;
    }

    @Nullable
    public String getRealmType() {
        return this.realmType;
    }

    @Nullable
    public RealmConfig.RealmIdentifier getRealmIdentifier() {
        if (this.realm != null && this.realmType != null) {
            return new RealmConfig.RealmIdentifier(this.realmType, this.realm);
        }
        return null;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public List<RoleDescriptor> getRoleDescriptors() {
        return this.roleDescriptors;
    }

    public RoleDescriptorsIntersection getLimitedBy() {
        return this.limitedBy;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder, params);
        return builder.endObject();
    }

    public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("id", this.id).field("name", this.name);
        builder.field("type", this.type.value());
        builder.field("creation", this.creation.toEpochMilli());
        if (this.expiration != null) {
            builder.field("expiration", this.expiration.toEpochMilli());
        }
        builder.field("invalidated", this.invalidated);
        if (this.invalidation != null) {
            builder.field("invalidation", this.invalidation.toEpochMilli());
        }
        builder.field("username", this.username).field("realm", this.realm);
        if (this.realmType != null) {
            builder.field("realm_type", this.realmType);
        }
        builder.field("metadata", this.metadata == null ? Map.of() : this.metadata);
        if (this.roleDescriptors != null) {
            builder.startObject("role_descriptors");
            for (RoleDescriptor roleDescriptor : this.roleDescriptors) {
                builder.field(roleDescriptor.getName(), (ToXContent)roleDescriptor);
            }
            builder.endObject();
            if (this.type == Type.CROSS_CLUSTER) {
                assert (this.roleDescriptors.size() == 1);
                this.buildXContentForCrossClusterApiKeyAccess(builder, this.roleDescriptors.iterator().next());
            }
        }
        if (this.limitedBy != null) {
            assert (this.type != Type.CROSS_CLUSTER);
            builder.field("limited_by", (ToXContent)this.limitedBy);
        }
        return builder;
    }

    private void buildXContentForCrossClusterApiKeyAccess(XContentBuilder builder, RoleDescriptor roleDescriptor) throws IOException {
        if (Assertions.ENABLED) {
            CrossClusterApiKeyRoleDescriptorBuilder.validate(roleDescriptor);
        }
        ArrayList<RoleDescriptor.IndicesPrivileges> search = new ArrayList<RoleDescriptor.IndicesPrivileges>();
        ArrayList<RoleDescriptor.IndicesPrivileges> replication = new ArrayList<RoleDescriptor.IndicesPrivileges>();
        for (RoleDescriptor.IndicesPrivileges indicesPrivileges : roleDescriptor.getIndicesPrivileges()) {
            if (Arrays.equals(CrossClusterApiKeyRoleDescriptorBuilder.CCS_INDICES_PRIVILEGE_NAMES, indicesPrivileges.getPrivileges())) {
                search.add(indicesPrivileges);
                continue;
            }
            assert (Arrays.equals(CrossClusterApiKeyRoleDescriptorBuilder.CCR_INDICES_PRIVILEGE_NAMES, indicesPrivileges.getPrivileges()));
            replication.add(indicesPrivileges);
        }
        builder.startObject("access");
        ToXContent.MapParams params = new ToXContent.MapParams(Map.of("_with_privileges", "false"));
        if (!search.isEmpty()) {
            builder.startArray("search");
            for (RoleDescriptor.IndicesPrivileges indicesPrivileges : search) {
                indicesPrivileges.toXContent(builder, (ToXContent.Params)params);
            }
            builder.endArray();
        }
        if (!replication.isEmpty()) {
            builder.startArray("replication");
            for (RoleDescriptor.IndicesPrivileges indicesPrivileges : replication) {
                indicesPrivileges.toXContent(builder, (ToXContent.Params)params);
            }
            builder.endArray();
        }
        builder.endObject();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.id, this.type, this.creation, this.expiration, this.invalidated, this.invalidation, this.username, this.realm, this.realmType, this.metadata, this.roleDescriptors, this.limitedBy});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApiKey other = (ApiKey)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.id, other.id) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.creation, other.creation) && Objects.equals(this.expiration, other.expiration) && Objects.equals(this.invalidated, other.invalidated) && Objects.equals(this.invalidation, other.invalidation) && Objects.equals(this.username, other.username) && Objects.equals(this.realm, other.realm) && Objects.equals(this.realmType, other.realmType) && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.roleDescriptors, other.roleDescriptors) && Objects.equals(this.limitedBy, other.limitedBy);
    }

    public String toString() {
        return "ApiKey [name=" + this.name + ", id=" + this.id + ", type=" + this.type.value() + ", creation=" + String.valueOf(this.creation) + ", expiration=" + String.valueOf(this.expiration) + ", invalidated=" + this.invalidated + ", invalidation=" + String.valueOf(this.invalidation) + ", username=" + this.username + ", realm=" + this.realm + ", realm_type=" + this.realmType + ", metadata=" + String.valueOf(this.metadata) + ", role_descriptors=" + String.valueOf(this.roleDescriptors) + ", limited_by=" + String.valueOf(this.limitedBy) + "]";
    }

    public static ApiKey fromXContent(XContentParser parser) throws IOException {
        return (ApiKey)PARSER.parse(parser, null);
    }

    static int initializeParser(AbstractObjectParser<?, Void> parser) {
        parser.declareString(ConstructingObjectParser.constructorArg(), new ParseField("name", new String[0]));
        parser.declareString(ConstructingObjectParser.constructorArg(), new ParseField("id", new String[0]));
        parser.declareField(ConstructingObjectParser.constructorArg(), Type::fromXContent, new ParseField("type", new String[0]), ObjectParser.ValueType.STRING);
        parser.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("creation", new String[0]));
        parser.declareLong(ConstructingObjectParser.optionalConstructorArg(), new ParseField("expiration", new String[0]));
        parser.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField("invalidated", new String[0]));
        parser.declareLong(ConstructingObjectParser.optionalConstructorArg(), new ParseField("invalidation", new String[0]));
        parser.declareString(ConstructingObjectParser.constructorArg(), new ParseField("username", new String[0]));
        parser.declareString(ConstructingObjectParser.constructorArg(), new ParseField("realm", new String[0]));
        parser.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), new ParseField("realm_type", new String[0]));
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), new ParseField("metadata", new String[0]));
        parser.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> {
            p.nextToken();
            return ROLE_DESCRIPTOR_PARSER.parse(n, p);
        }, new ParseField("role_descriptors", new String[0]));
        parser.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> RoleDescriptorsIntersection.fromXContent(p), new ParseField("limited_by", new String[0]), ObjectParser.ValueType.OBJECT_ARRAY);
        return 13;
    }

    static {
        ApiKey.initializeParser(PARSER);
    }

    public static enum Type {
        REST,
        CROSS_CLUSTER;


        public static Type parse(String value) {
            return switch (value.toLowerCase(Locale.ROOT)) {
                case "rest" -> REST;
                case "cross_cluster" -> CROSS_CLUSTER;
                default -> throw new IllegalArgumentException("invalid API key type [" + value + "] expected one of [" + Stream.of(Type.values()).map(Type::value).collect(Collectors.joining(",")) + "]");
            };
        }

        public static Type fromXContent(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.currentToken();
            if (token == null) {
                token = parser.nextToken();
            }
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_STRING, (XContentParser.Token)token, (XContentParser)parser);
            return Type.parse(parser.text());
        }

        public String value() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public record Version(int version) implements VersionId<Version>
    {
        public int id() {
            return this.version;
        }
    }

    public static class VersionComponent
    implements ComponentVersionNumber {
        public String componentId() {
            return "api_key_version";
        }

        public VersionId<?> versionNumber() {
            return CURRENT_API_KEY_VERSION;
        }
    }
}

