/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.type;

import java.io.IOException;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.function.Function;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.ql.type.Converter;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypeConverter;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.literal.interval.Intervals;
import org.elasticsearch.xpack.sql.type.SqlDataTypes;
import org.elasticsearch.xpack.sql.util.DateUtils;

public final class SqlDataTypeConverter {
    private SqlDataTypeConverter() {
    }

    public static DataType commonType(DataType left, DataType right) {
        DataType common = DataTypeConverter.commonType((DataType)left, (DataType)right);
        if (common != null) {
            return common;
        }
        if (left == SqlDataTypes.DATE) {
            if (SqlDataTypes.isYearMonthInterval(right)) {
                return left;
            }
            return DataTypes.DATETIME;
        }
        if (right == SqlDataTypes.DATE) {
            if (SqlDataTypes.isYearMonthInterval(left)) {
                return right;
            }
            return DataTypes.DATETIME;
        }
        if (left == SqlDataTypes.TIME && SqlDataTypes.isInterval(right)) {
            return left;
        }
        if (right == SqlDataTypes.TIME && SqlDataTypes.isInterval(left)) {
            return right;
        }
        if (DataTypes.isDateTime((DataType)left)) {
            if (right == SqlDataTypes.DATE || right == SqlDataTypes.TIME) {
                return DataTypes.DATETIME;
            }
            if (SqlDataTypes.isInterval(right)) {
                return DataTypes.DATETIME;
            }
        }
        if (DataTypes.isDateTime((DataType)right)) {
            if (left == SqlDataTypes.DATE || left == SqlDataTypes.TIME) {
                return DataTypes.DATETIME;
            }
            if (SqlDataTypes.isInterval(left)) {
                return DataTypes.DATETIME;
            }
        }
        if (SqlDataTypes.isInterval(left) && right.isInteger()) {
            return left;
        }
        if (SqlDataTypes.isInterval(right) && left.isInteger()) {
            return right;
        }
        if (SqlDataTypes.isInterval(left) && SqlDataTypes.isInterval(right)) {
            return Intervals.compatibleInterval(left, right);
        }
        return null;
    }

    public static boolean canConvert(DataType from, DataType to) {
        if (from == to || from == DataTypes.NULL) {
            return true;
        }
        return DataTypes.isPrimitive((DataType)from) && DataTypes.isPrimitive((DataType)to) && SqlDataTypeConverter.converterFor(from, to) != null;
    }

    public static Converter converterFor(DataType from, DataType to) {
        if (from == to) {
            return DataTypeConverter.DefaultConverter.IDENTITY;
        }
        if (to == DataTypes.NULL || from == DataTypes.NULL) {
            return DataTypeConverter.DefaultConverter.TO_NULL;
        }
        if (to == SqlDataTypes.DATE) {
            return SqlDataTypeConverter.conversionToDate(from);
        }
        if (to == SqlDataTypes.TIME) {
            return SqlDataTypeConverter.conversionToTime(from);
        }
        if (from == SqlDataTypes.DATE || from == SqlDataTypes.TIME) {
            if (to == DataTypes.KEYWORD || to == DataTypes.TEXT) {
                return SqlDataTypeConverter.conversionToString(from);
            }
            if (to == DataTypes.UNSIGNED_LONG) {
                return SqlDataTypeConverter.conversionToUnsignedLong(from);
            }
            if (to == DataTypes.LONG) {
                return SqlDataTypeConverter.conversionToLong(from);
            }
            if (to == DataTypes.INTEGER) {
                return SqlDataTypeConverter.conversionToInt(from);
            }
            if (to == DataTypes.SHORT) {
                return SqlDataTypeConverter.conversionToShort(from);
            }
            if (to == DataTypes.BYTE) {
                return SqlDataTypeConverter.conversionToByte(from);
            }
            if (to == DataTypes.FLOAT) {
                return SqlDataTypeConverter.conversionToFloat(from);
            }
            if (to == DataTypes.DOUBLE) {
                return SqlDataTypeConverter.conversionToDouble(from);
            }
            if (to == DataTypes.DATETIME) {
                return SqlDataTypeConverter.conversionToDateTime(from);
            }
            if (to == DataTypes.BOOLEAN) {
                return SqlDataTypeConverter.conversionToBoolean(from);
            }
        }
        return DataTypeConverter.converterFor((DataType)from, (DataType)to);
    }

    private static Converter conversionToString(DataType from) {
        if (from == SqlDataTypes.DATE) {
            return SqlConverter.DATE_TO_STRING;
        }
        if (from == SqlDataTypes.TIME) {
            return SqlConverter.TIME_TO_STRING;
        }
        return null;
    }

    private static Converter conversionToUnsignedLong(DataType from) {
        if (from == SqlDataTypes.DATE) {
            return SqlConverter.DATE_TO_UNSIGNED_LONG;
        }
        if (from == SqlDataTypes.TIME) {
            return SqlConverter.TIME_TO_UNSIGNED_LONG;
        }
        return null;
    }

    private static Converter conversionToLong(DataType from) {
        if (from == SqlDataTypes.DATE) {
            return SqlConverter.DATE_TO_LONG;
        }
        if (from == SqlDataTypes.TIME) {
            return SqlConverter.TIME_TO_LONG;
        }
        return null;
    }

    private static Converter conversionToInt(DataType from) {
        if (from == SqlDataTypes.DATE) {
            return SqlConverter.DATE_TO_INT;
        }
        if (from == SqlDataTypes.TIME) {
            return SqlConverter.TIME_TO_INT;
        }
        return null;
    }

    private static Converter conversionToShort(DataType from) {
        if (from == SqlDataTypes.DATE) {
            return SqlConverter.DATE_TO_SHORT;
        }
        if (from == SqlDataTypes.TIME) {
            return SqlConverter.TIME_TO_SHORT;
        }
        return null;
    }

    private static Converter conversionToByte(DataType from) {
        if (from == SqlDataTypes.DATE) {
            return SqlConverter.DATE_TO_BYTE;
        }
        if (from == SqlDataTypes.TIME) {
            return SqlConverter.TIME_TO_BYTE;
        }
        return null;
    }

    private static Converter conversionToFloat(DataType from) {
        if (from == SqlDataTypes.DATE) {
            return SqlConverter.DATE_TO_FLOAT;
        }
        if (from == SqlDataTypes.TIME) {
            return SqlConverter.TIME_TO_FLOAT;
        }
        return null;
    }

    private static Converter conversionToDouble(DataType from) {
        if (from == SqlDataTypes.DATE) {
            return SqlConverter.DATE_TO_DOUBLE;
        }
        if (from == SqlDataTypes.TIME) {
            return SqlConverter.TIME_TO_DOUBLE;
        }
        return null;
    }

    private static Converter conversionToDateTime(DataType from) {
        if (from == SqlDataTypes.DATE) {
            return SqlConverter.DATE_TO_DATETIME;
        }
        return DataTypeConverter.converterFor((DataType)from, (DataType)DataTypes.DATETIME);
    }

    private static Converter conversionToBoolean(DataType from) {
        if (from == SqlDataTypes.DATE) {
            return SqlConverter.DATE_TO_BOOLEAN;
        }
        if (from == SqlDataTypes.TIME) {
            return SqlConverter.TIME_TO_BOOLEAN;
        }
        return null;
    }

    private static Converter conversionToDate(DataType from) {
        if (from.isRational()) {
            return SqlConverter.RATIONAL_TO_DATE;
        }
        if (from.isInteger()) {
            return SqlConverter.INTEGER_TO_DATE;
        }
        if (from == DataTypes.BOOLEAN) {
            return SqlConverter.BOOL_TO_DATE;
        }
        if (DataTypes.isString((DataType)from)) {
            return SqlConverter.STRING_TO_DATE;
        }
        if (DataTypes.isDateTime((DataType)from)) {
            return SqlConverter.DATETIME_TO_DATE;
        }
        return null;
    }

    private static Converter conversionToTime(DataType from) {
        if (from.isRational()) {
            return SqlConverter.RATIONAL_TO_TIME;
        }
        if (from.isInteger()) {
            return SqlConverter.INTEGER_TO_TIME;
        }
        if (from == DataTypes.BOOLEAN) {
            return SqlConverter.BOOL_TO_TIME;
        }
        if (DataTypes.isString((DataType)from)) {
            return SqlConverter.STRING_TO_TIME;
        }
        if (from == SqlDataTypes.DATE) {
            return SqlConverter.DATE_TO_TIME;
        }
        if (DataTypes.isDateTime((DataType)from)) {
            return SqlConverter.DATETIME_TO_TIME;
        }
        return null;
    }

    public static Object convert(Object value, DataType dataType) {
        DataType detectedType = SqlDataTypes.fromJava(value);
        if (detectedType == null) {
            throw new SqlIllegalArgumentException("cannot detect datatype for [{}]", value);
        }
        if (detectedType == dataType || value == null) {
            return value;
        }
        Converter converter = SqlDataTypeConverter.converterFor(detectedType, dataType);
        if (converter == null) {
            throw new SqlIllegalArgumentException("cannot convert from [{}] to [{}]", value, dataType.typeName());
        }
        return converter.convert(value);
    }

    public static enum SqlConverter implements Converter
    {
        DATE_TO_STRING(o -> DateUtils.toDateString((ZonedDateTime)o)),
        TIME_TO_STRING(o -> DateUtils.toTimeString((OffsetTime)o)),
        DATE_TO_UNSIGNED_LONG(SqlConverter.delegate((Converter)DataTypeConverter.DefaultConverter.DATETIME_TO_UNSIGNED_LONG)),
        TIME_TO_UNSIGNED_LONG(SqlConverter.fromTime(DataTypeConverter::safeToUnsignedLong)),
        DATE_TO_LONG(SqlConverter.delegate((Converter)DataTypeConverter.DefaultConverter.DATETIME_TO_LONG)),
        TIME_TO_LONG(SqlConverter.fromTime(value -> value)),
        DATE_TO_INT(SqlConverter.delegate((Converter)DataTypeConverter.DefaultConverter.DATETIME_TO_INT)),
        TIME_TO_INT(SqlConverter.fromTime(DataTypeConverter::safeToInt)),
        DATE_TO_SHORT(SqlConverter.delegate((Converter)DataTypeConverter.DefaultConverter.DATETIME_TO_SHORT)),
        TIME_TO_SHORT(SqlConverter.fromTime(DataTypeConverter::safeToShort)),
        DATE_TO_BYTE(SqlConverter.delegate((Converter)DataTypeConverter.DefaultConverter.DATETIME_TO_BYTE)),
        TIME_TO_BYTE(SqlConverter.fromTime(DataTypeConverter::safeToByte)),
        DATE_TO_FLOAT(SqlConverter.delegate((Converter)DataTypeConverter.DefaultConverter.DATETIME_TO_FLOAT)),
        TIME_TO_FLOAT(SqlConverter.fromTime(value -> Float.valueOf(value.longValue()))),
        DATE_TO_DOUBLE(SqlConverter.delegate((Converter)DataTypeConverter.DefaultConverter.DATETIME_TO_DOUBLE)),
        TIME_TO_DOUBLE(SqlConverter.fromTime(Double::valueOf)),
        RATIONAL_TO_DATE(SqlConverter.toDate((Converter)DataTypeConverter.DefaultConverter.RATIONAL_TO_LONG)),
        INTEGER_TO_DATE(SqlConverter.toDate((Converter)DataTypeConverter.DefaultConverter.INTEGER_TO_LONG)),
        BOOL_TO_DATE(SqlConverter.toDate((Converter)DataTypeConverter.DefaultConverter.BOOL_TO_INT)),
        STRING_TO_DATE(DataTypeConverter.DefaultConverter.fromString(DateUtils::asDateOnly, (String)"date")),
        DATETIME_TO_DATE(SqlConverter.fromDatetimeToDate()),
        RATIONAL_TO_TIME(SqlConverter.toTime((Converter)DataTypeConverter.DefaultConverter.RATIONAL_TO_LONG)),
        INTEGER_TO_TIME(SqlConverter.toTime((Converter)DataTypeConverter.DefaultConverter.INTEGER_TO_LONG)),
        BOOL_TO_TIME(SqlConverter.toTime((Converter)DataTypeConverter.DefaultConverter.BOOL_TO_INT)),
        STRING_TO_TIME(DataTypeConverter.DefaultConverter.fromString(DateUtils::asTimeOnly, (String)"time")),
        DATE_TO_TIME(SqlConverter.fromDatetimeToTime()),
        DATETIME_TO_TIME(SqlConverter.fromDatetimeToTime()),
        DATE_TO_DATETIME(value -> value),
        DATE_TO_BOOLEAN(SqlConverter.delegate((Converter)DataTypeConverter.DefaultConverter.DATETIME_TO_BOOLEAN)),
        TIME_TO_BOOLEAN(SqlConverter.fromTime(value -> value != 0L));

        public static final String NAME = "dtc-sql";
        private final Function<Object, Object> converter;

        private SqlConverter(Function<Object, Object> converter) {
            this.converter = converter;
        }

        private static Function<Object, Object> fromTime(Function<Long, Object> converter) {
            return l -> converter.apply(((OffsetTime)l).atDate(DateUtils.EPOCH).toInstant().toEpochMilli());
        }

        private static Function<Object, Object> toDate(Converter conversion) {
            return l -> DateUtils.asDateOnly(((Number)conversion.convert(l)).longValue());
        }

        private static Function<Object, Object> toTime(Converter conversion) {
            return l -> DateUtils.asTimeOnly(((Number)conversion.convert(l)).longValue());
        }

        private static Function<Object, Object> fromDatetimeToDate() {
            return l -> DateUtils.asDateOnly((ZonedDateTime)l);
        }

        private static Function<Object, Object> fromDatetimeToTime() {
            return l -> ((ZonedDateTime)l).toOffsetDateTime().toOffsetTime();
        }

        private static Function<Object, Object> delegate(Converter converter) {
            return arg_0 -> ((Converter)converter).convert(arg_0);
        }

        public Object convert(Object l) {
            if (l == null) {
                return null;
            }
            return this.converter.apply(l);
        }

        public String getWriteableName() {
            return NAME;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum((Enum)this);
        }

        public static Converter read(StreamInput in) throws IOException {
            return (Converter)in.readEnum(SqlConverter.class);
        }
    }
}

