/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.logical.command;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.function.FunctionRegistry;
import org.elasticsearch.xpack.ql.expression.predicate.regex.LikePattern;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.EsField;
import org.elasticsearch.xpack.ql.type.KeywordEsField;
import org.elasticsearch.xpack.sql.expression.function.SqlFunctionTypeRegistry;
import org.elasticsearch.xpack.sql.plan.logical.command.Command;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.SqlSession;

public class ShowFunctions
extends Command {
    private final LikePattern pattern;

    public ShowFunctions(Source source, LikePattern pattern) {
        super(source);
        this.pattern = pattern;
    }

    protected NodeInfo<ShowFunctions> info() {
        return NodeInfo.create((Node)this, ShowFunctions::new, (Object)this.pattern);
    }

    public LikePattern pattern() {
        return this.pattern;
    }

    @Override
    public List<Attribute> output() {
        return Arrays.asList(new FieldAttribute(this.source(), "name", (EsField)new KeywordEsField("name")), new FieldAttribute(this.source(), "type", (EsField)new KeywordEsField("type")));
    }

    @Override
    public void execute(SqlSession session, ActionListener<Cursor.Page> listener) {
        FunctionRegistry registry = session.functionRegistry();
        Collection functions = registry.listFunctions(this.pattern != null ? this.pattern.asJavaRegex() : null);
        listener.onResponse((Object)this.of(session, functions.stream().map(f -> Arrays.asList(f.name(), SqlFunctionTypeRegistry.INSTANCE.type(f.clazz()))).collect(Collectors.toList())));
    }

    public int hashCode() {
        return Objects.hash(this.pattern);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShowFunctions other = (ShowFunctions)obj;
        return Objects.equals(this.pattern, other.pattern);
    }
}

