/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.literal.interval;

import java.io.IOException;
import java.time.temporal.TemporalAmount;
import java.util.Objects;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.ql.expression.function.scalar.IntervalScripting;
import org.elasticsearch.xpack.ql.expression.gen.processor.ConstantNamedWriteable;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.util.DateUtils;

public abstract class Interval<I extends TemporalAmount>
implements ConstantNamedWriteable,
ToXContentObject,
IntervalScripting {
    private final I interval;
    private final DataType intervalType;

    public Interval(I interval, DataType intervalType) {
        this.interval = interval;
        this.intervalType = intervalType;
    }

    public I interval() {
        return this.interval;
    }

    public DataType dataType() {
        return this.intervalType;
    }

    public abstract Interval<I> add(Interval<I> var1);

    public abstract Interval<I> sub(Interval<I> var1);

    public abstract Interval<I> mul(long var1);

    public int hashCode() {
        return Objects.hash(this.interval, this.intervalType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Interval other = (Interval)obj;
        return Objects.equals(other.interval, this.interval) && Objects.equals(other.intervalType, this.intervalType);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.interval);
    }

    public String toString() {
        return DateUtils.toString(this.interval);
    }

    public String value() {
        return this.interval().toString();
    }

    public String typeName() {
        return this.dataType().toString();
    }
}

