/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.RefCountingListener;
import org.elasticsearch.action.support.ThreadedActionListener;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.Template;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.core.transform.action.GetTransformAction;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.deprecation.ClusterDeprecationChecker;
import org.elasticsearch.xpack.deprecation.DataStreamDeprecationChecker;
import org.elasticsearch.xpack.deprecation.DeprecationChecker;
import org.elasticsearch.xpack.deprecation.DeprecationInfoAction;
import org.elasticsearch.xpack.deprecation.IlmPolicyDeprecationChecker;
import org.elasticsearch.xpack.deprecation.IndexDeprecationChecker;
import org.elasticsearch.xpack.deprecation.MlDeprecationChecker;
import org.elasticsearch.xpack.deprecation.NodeDeprecationChecker;
import org.elasticsearch.xpack.deprecation.ResourceDeprecationChecker;
import org.elasticsearch.xpack.deprecation.TemplateDeprecationChecker;

public class TransportDeprecationInfoAction
extends TransportMasterNodeReadAction<DeprecationInfoAction.Request, DeprecationInfoAction.Response> {
    public static final Setting<List<String>> SKIP_DEPRECATIONS_SETTING = Setting.stringListSetting((String)"deprecation.skip_deprecated_settings", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private static final List<DeprecationChecker> PLUGIN_CHECKERS = List.of(new MlDeprecationChecker());
    private final NodeClient client;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final Settings settings;
    private final NamedXContentRegistry xContentRegistry;
    private volatile List<String> skipTheseDeprecations;
    private final NodeDeprecationChecker nodeDeprecationChecker;
    private final ClusterDeprecationChecker clusterDeprecationChecker;
    private final List<ResourceDeprecationChecker> resourceDeprecationCheckers;

    @Inject
    public TransportDeprecationInfoAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NodeClient client, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/xpack/deprecation/info", transportService, clusterService, threadPool, actionFilters, DeprecationInfoAction.Request::new, DeprecationInfoAction.Response::new, (Executor)threadPool.executor("generic"));
        this.client = client;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.skipTheseDeprecations = (List)SKIP_DEPRECATIONS_SETTING.get(settings);
        this.nodeDeprecationChecker = new NodeDeprecationChecker(threadPool);
        this.clusterDeprecationChecker = new ClusterDeprecationChecker(xContentRegistry);
        this.resourceDeprecationCheckers = List.of(new IndexDeprecationChecker(indexNameExpressionResolver), new DataStreamDeprecationChecker(indexNameExpressionResolver), new TemplateDeprecationChecker(), new IlmPolicyDeprecationChecker());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SKIP_DEPRECATIONS_SETTING, this::setSkipDeprecations);
    }

    private <T> void setSkipDeprecations(List<String> skipDeprecations) {
        this.skipTheseDeprecations = Collections.unmodifiableList(skipDeprecations);
    }

    protected ClusterBlockException checkBlock(DeprecationInfoAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    protected final void masterOperation(Task task, DeprecationInfoAction.Request request, ClusterState state, ActionListener<DeprecationInfoAction.Response> listener) {
        PrecomputedData precomputedData = new PrecomputedData();
        try (RefCountingListener refs = new RefCountingListener(this.checkAndCreateResponse(state, request, precomputedData, listener));){
            this.nodeDeprecationChecker.check((Client)this.client, (ActionListener<List<DeprecationIssue>>)refs.acquire(precomputedData::setOnceNodeSettingsIssues));
            this.transformConfigs((ActionListener<List<TransformConfig>>)refs.acquire(precomputedData::setOnceTransformConfigs));
            DeprecationChecker.Components components = new DeprecationChecker.Components(this.xContentRegistry, this.settings, new OriginSettingClient((Client)this.client, "deprecation"));
            TransportDeprecationInfoAction.pluginSettingIssues(PLUGIN_CHECKERS, components, (ActionListener<Map<String, List<DeprecationIssue>>>)refs.acquire(precomputedData::setOncePluginIssues));
        }
    }

    public ActionListener<Void> checkAndCreateResponse(ClusterState state, DeprecationInfoAction.Request request, PrecomputedData precomputedData, ActionListener<DeprecationInfoAction.Response> responseListener) {
        return this.executeInGenericThreadpool(ActionListener.running(() -> responseListener.onResponse((Object)TransportDeprecationInfoAction.checkAndCreateResponse(state, this.indexNameExpressionResolver, request, this.skipTheseDeprecations, this.clusterDeprecationChecker, this.resourceDeprecationCheckers, precomputedData))));
    }

    static DeprecationInfoAction.Response checkAndCreateResponse(ClusterState state, IndexNameExpressionResolver indexNameExpressionResolver, DeprecationInfoAction.Request request, List<String> skipTheseDeprecatedSettings, ClusterDeprecationChecker clusterDeprecationChecker, List<ResourceDeprecationChecker> resourceDeprecationCheckers, PrecomputedData precomputedData) {
        assert (Transports.assertNotTransportThread((String)"walking mappings in indexSettingsChecks is expensive"));
        String[] concreteIndexNames = indexNameExpressionResolver.concreteIndexNames(state, (IndicesRequest)request);
        ClusterState stateWithSkippedSettingsRemoved = TransportDeprecationInfoAction.removeSkippedSettings(state, concreteIndexNames, skipTheseDeprecatedSettings);
        List<DeprecationIssue> clusterSettingsIssues = clusterDeprecationChecker.check(stateWithSkippedSettingsRemoved, precomputedData.transformConfigs());
        HashMap<String, Map<String, List<DeprecationIssue>>> resourceDeprecationIssues = new HashMap<String, Map<String, List<DeprecationIssue>>>();
        for (ResourceDeprecationChecker resourceDeprecationChecker : resourceDeprecationCheckers) {
            Map<String, List<DeprecationIssue>> issues = resourceDeprecationChecker.check(stateWithSkippedSettingsRemoved, request, precomputedData);
            if (issues.isEmpty()) continue;
            resourceDeprecationIssues.put(resourceDeprecationChecker.getName(), issues);
        }
        return new DeprecationInfoAction.Response(clusterSettingsIssues, precomputedData.nodeSettingsIssues(), resourceDeprecationIssues, precomputedData.pluginIssues());
    }

    private static ClusterState removeSkippedSettings(ClusterState state, String[] indexNames, List<String> skipTheseDeprecatedSettings) {
        if (skipTheseDeprecatedSettings == null || skipTheseDeprecatedSettings.isEmpty()) {
            return state;
        }
        ClusterState.Builder clusterStateBuilder = new ClusterState.Builder(state);
        Metadata.Builder metadataBuilder = Metadata.builder((Metadata)state.metadata());
        metadataBuilder.transientSettings(metadataBuilder.transientSettings().filter(setting -> !Regex.simpleMatch((List)skipTheseDeprecatedSettings, (String)setting)));
        metadataBuilder.persistentSettings(metadataBuilder.persistentSettings().filter(setting -> !Regex.simpleMatch((List)skipTheseDeprecatedSettings, (String)setting)));
        HashMap<String, IndexMetadata> indicesBuilder = new HashMap<String, IndexMetadata>(state.getMetadata().getProject().indices());
        for (String indexName : indexNames) {
            IndexMetadata indexMetadata = state.getMetadata().getProject().index(indexName);
            IndexMetadata.Builder filteredIndexMetadataBuilder = new IndexMetadata.Builder(indexMetadata);
            Settings filteredSettings = indexMetadata.getSettings().filter(setting -> !Regex.simpleMatch((List)skipTheseDeprecatedSettings, (String)setting));
            filteredIndexMetadataBuilder.settings(filteredSettings);
            indicesBuilder.put(indexName, filteredIndexMetadataBuilder.build());
        }
        metadataBuilder.componentTemplates(state.metadata().getProject().componentTemplates().entrySet().stream().map(entry -> {
            String templateName = (String)entry.getKey();
            ComponentTemplate componentTemplate = (ComponentTemplate)entry.getValue();
            Template template = componentTemplate.template();
            if (template.settings() == null || template.settings().isEmpty()) {
                return Tuple.tuple((Object)templateName, (Object)componentTemplate);
            }
            return Tuple.tuple((Object)templateName, (Object)new ComponentTemplate(Template.builder((Template)template).settings(template.settings().filter(setting -> !Regex.simpleMatch((List)skipTheseDeprecatedSettings, (String)setting))).build(), componentTemplate.version(), componentTemplate.metadata(), componentTemplate.deprecated()));
        }).collect(Collectors.toMap(Tuple::v1, Tuple::v2)));
        metadataBuilder.indexTemplates(state.metadata().getProject().templatesV2().entrySet().stream().map(entry -> {
            String templateName = (String)entry.getKey();
            ComposableIndexTemplate indexTemplate = (ComposableIndexTemplate)entry.getValue();
            Template template = indexTemplate.template();
            if (template == null || template.settings() == null || template.settings().isEmpty()) {
                return Tuple.tuple((Object)templateName, (Object)indexTemplate);
            }
            return Tuple.tuple((Object)templateName, (Object)indexTemplate.toBuilder().template(Template.builder((Template)indexTemplate.template()).settings(indexTemplate.template().settings().filter(setting -> !Regex.simpleMatch((List)skipTheseDeprecatedSettings, (String)setting)))).build());
        }).collect(Collectors.toMap(Tuple::v1, Tuple::v2)));
        metadataBuilder.indices(indicesBuilder);
        clusterStateBuilder.metadata(metadataBuilder);
        return clusterStateBuilder.build();
    }

    static void pluginSettingIssues(List<DeprecationChecker> checkers, DeprecationChecker.Components components, ActionListener<Map<String, List<DeprecationIssue>>> listener) {
        List<DeprecationChecker> enabledCheckers = checkers.stream().filter(c -> c.enabled(components.settings())).toList();
        if (enabledCheckers.isEmpty()) {
            listener.onResponse(Collections.emptyMap());
            return;
        }
        GroupedActionListener groupedActionListener = new GroupedActionListener(enabledCheckers.size(), listener.delegateFailureAndWrap((l, checkResults) -> l.onResponse(checkResults.stream().collect(Collectors.toMap(DeprecationChecker.CheckResult::getCheckerName, DeprecationChecker.CheckResult::getIssues)))));
        for (DeprecationChecker checker : checkers) {
            checker.check(components, (ActionListener<DeprecationChecker.CheckResult>)groupedActionListener);
        }
    }

    private void transformConfigs(ActionListener<List<TransformConfig>> transformConfigsListener) {
        this.transformConfigs(new PageParams(0, 100), (ActionListener<Stream<TransformConfig>>)transformConfigsListener.map(Stream::toList));
    }

    private void transformConfigs(PageParams currentPage, ActionListener<Stream<TransformConfig>> currentPageListener) {
        GetTransformAction.Request request = new GetTransformAction.Request("_all");
        request.setPageParams(currentPage);
        request.setAllowNoResources(true);
        this.client.execute((ActionType)GetTransformAction.INSTANCE, (ActionRequest)request, this.executeInGenericThreadpool(currentPageListener.delegateFailureAndWrap((delegate, getTransformConfigResponse) -> {
            Stream currentPageOfConfigs = getTransformConfigResponse.getTransformConfigurations().stream();
            int currentPageSize = currentPage.getFrom() + currentPage.getSize();
            long totalTransformConfigCount = getTransformConfigResponse.getTransformConfigurationCount();
            if (totalTransformConfigCount >= (long)currentPageSize) {
                PageParams nextPage = new PageParams(currentPageSize, 100);
                this.transformConfigs(nextPage, (ActionListener<Stream<TransformConfig>>)delegate.map(nextPageOfConfigs -> Stream.concat(currentPageOfConfigs, nextPageOfConfigs)));
            } else {
                delegate.onResponse(currentPageOfConfigs);
            }
        })));
    }

    private <T> ActionListener<T> executeInGenericThreadpool(ActionListener<T> listener) {
        return new ThreadedActionListener((Executor)this.threadPool.generic(), listener);
    }

    public static class PrecomputedData {
        private final SetOnce<List<DeprecationIssue>> nodeSettingsIssues = new SetOnce();
        private final SetOnce<Map<String, List<DeprecationIssue>>> pluginIssues = new SetOnce();
        private final SetOnce<List<TransformConfig>> transformConfigs = new SetOnce();

        public void setOnceNodeSettingsIssues(List<DeprecationIssue> nodeSettingsIssues) {
            this.nodeSettingsIssues.set(nodeSettingsIssues);
        }

        public void setOncePluginIssues(Map<String, List<DeprecationIssue>> pluginIssues) {
            this.pluginIssues.set(pluginIssues);
        }

        public void setOnceTransformConfigs(List<TransformConfig> transformConfigs) {
            this.transformConfigs.set(transformConfigs);
        }

        public List<DeprecationIssue> nodeSettingsIssues() {
            return (List)this.nodeSettingsIssues.get();
        }

        public Map<String, List<DeprecationIssue>> pluginIssues() {
            return (Map)this.pluginIssues.get();
        }

        public List<TransformConfig> transformConfigs() {
            return (List)this.transformConfigs.get();
        }
    }
}

