/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.topn;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.topn.SortableTopNEncoder;
import org.elasticsearch.compute.operator.topn.TopNEncoder;

class VersionTopNEncoder
extends SortableTopNEncoder {
    VersionTopNEncoder() {
    }

    @Override
    public int encodeBytesRef(BytesRef value, BreakingBytesRefBuilder bytesRefBuilder) {
        for (int i = value.offset; i < value.length; ++i) {
            if (value.bytes[i] != 0) continue;
            throw new IllegalArgumentException("Can't sort versions containing nul");
        }
        bytesRefBuilder.append(value);
        bytesRefBuilder.append((byte)0);
        return value.length + 1;
    }

    @Override
    public BytesRef decodeBytesRef(BytesRef bytes, BytesRef scratch) {
        int i = bytes.offset;
        while (bytes.bytes[i] != 0) {
            ++i;
        }
        scratch.bytes = bytes.bytes;
        scratch.offset = bytes.offset;
        scratch.length = i - bytes.offset;
        bytes.offset += scratch.length + 1;
        bytes.length -= scratch.length + 1;
        return scratch;
    }

    public String toString() {
        return "VersionTopNEncoder";
    }

    @Override
    public TopNEncoder toSortable() {
        return this;
    }

    @Override
    public TopNEncoder toUnsortable() {
        return this;
    }
}

