/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.topn;

import org.elasticsearch.compute.data.DocVector;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.topn.TopNEncoder;
import org.elasticsearch.compute.operator.topn.ValueExtractor;
import org.elasticsearch.core.RefCounted;

class ValueExtractorForDoc
implements ValueExtractor {
    private final DocVector vector;

    @Override
    public RefCounted getRefCountedForShard(int position) {
        return this.vector().shardRefCounted().get(this.vector().shards().getInt(position));
    }

    ValueExtractorForDoc(TopNEncoder encoder, DocVector vector) {
        assert (encoder == TopNEncoder.DEFAULT_UNSORTABLE);
        this.vector = vector;
    }

    DocVector vector() {
        return this.vector;
    }

    @Override
    public void writeValue(BreakingBytesRefBuilder values, int position) {
        TopNEncoder.DEFAULT_UNSORTABLE.encodeInt(this.vector.shards().getInt(position), values);
        TopNEncoder.DEFAULT_UNSORTABLE.encodeInt(this.vector.segments().getInt(position), values);
        TopNEncoder.DEFAULT_UNSORTABLE.encodeInt(this.vector.docs().getInt(position), values);
    }

    public String toString() {
        return "ValueExtractorForDoc";
    }
}

