/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.util.Arrays;
import org.elasticsearch.compute.data.AbstractVectorBuilder;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanVector;

final class BooleanVectorBuilder
extends AbstractVectorBuilder
implements BooleanVector.Builder {
    private boolean[] values;

    BooleanVectorBuilder(int estimatedSize, BlockFactory blockFactory) {
        super(blockFactory);
        int initialSize = Math.max(estimatedSize, 2);
        this.adjustBreaker(initialSize);
        this.values = new boolean[Math.max(estimatedSize, 2)];
    }

    @Override
    public BooleanVectorBuilder appendBoolean(boolean value) {
        this.ensureCapacity();
        this.values[this.valueCount] = value;
        ++this.valueCount;
        return this;
    }

    @Override
    protected int elementSize() {
        return 1;
    }

    @Override
    protected int valuesLength() {
        return this.values.length;
    }

    @Override
    protected void growValuesArray(int newSize) {
        this.values = Arrays.copyOf(this.values, newSize);
    }

    @Override
    public BooleanVector build() {
        BooleanVector vector;
        this.finish();
        if (this.valueCount == 1) {
            vector = this.blockFactory.newConstantBooleanBlockWith(this.values[0], 1, this.estimatedBytes).asVector();
        } else {
            if (this.values.length - this.valueCount > 1024 || this.valueCount < this.values.length / 2) {
                this.values = Arrays.copyOf(this.values, this.valueCount);
            }
            vector = this.blockFactory.newBooleanArrayVector(this.values, this.valueCount, this.estimatedBytes);
        }
        this.built();
        return vector;
    }
}

