/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.compute.aggregation.AggregatorState;
import org.elasticsearch.compute.aggregation.GroupingAggregatorState;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

class ValuesIntAggregator {
    ValuesIntAggregator() {
    }

    public static SingleState initSingle(BigArrays bigArrays) {
        return new SingleState(bigArrays);
    }

    public static void combine(SingleState state, int v) {
        state.values.add((long)v);
    }

    public static void combineIntermediate(SingleState state, IntBlock values) {
        int start = values.getFirstValueIndex(0);
        int end = start + values.getValueCount(0);
        for (int i = start; i < end; ++i) {
            ValuesIntAggregator.combine(state, values.getInt(i));
        }
    }

    public static Block evaluateFinal(SingleState state, DriverContext driverContext) {
        return state.toBlock(driverContext.blockFactory());
    }

    public static GroupingState initGrouping(DriverContext driverContext) {
        return new GroupingState(driverContext);
    }

    public static void combine(GroupingState state, int groupId, int v) {
        state.addValue(groupId, v);
    }

    public static void combineIntermediate(GroupingState state, int groupId, IntBlock values, int valuesPosition) {
        int start = values.getFirstValueIndex(valuesPosition);
        int end = start + values.getValueCount(valuesPosition);
        for (int i = start; i < end; ++i) {
            state.addValue(groupId, values.getInt(i));
        }
    }

    public static void combineStates(GroupingState current, int currentGroupId, GroupingState state, int statePosition) {
        if (statePosition > state.maxGroupId) {
            return;
        }
        Sorted sorted = state.sortedForOrdinalMerging(current);
        int start = statePosition > 0 ? sorted.counts[statePosition - 1] : 0;
        int end = sorted.counts[statePosition];
        for (int i = start; i < end; ++i) {
            int id = sorted.ids[i];
            current.addValue(currentGroupId, state.getValue(id));
        }
    }

    public static Block evaluateFinal(GroupingState state, IntVector selected, DriverContext driverContext) {
        return state.toBlock(driverContext.blockFactory(), selected);
    }

    public static class SingleState
    implements AggregatorState {
        private final LongHash values;

        private SingleState(BigArrays bigArrays) {
            this.values = new LongHash(1L, bigArrays);
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
            blocks[offset] = this.toBlock(driverContext.blockFactory());
        }

        Block toBlock(BlockFactory blockFactory) {
            if (this.values.size() == 0L) {
                return blockFactory.newConstantNullBlock(1);
            }
            if (this.values.size() == 1L) {
                return blockFactory.newConstantIntBlockWith((int)this.values.get(0L), 1);
            }
            try (IntBlock.Builder builder = blockFactory.newIntBlockBuilder((int)this.values.size());){
                builder.beginPositionEntry();
                int id = 0;
                while ((long)id < this.values.size()) {
                    builder.appendInt((int)this.values.get((long)id));
                    ++id;
                }
                builder.endPositionEntry();
                IntBlock intBlock = builder.build();
                return intBlock;
            }
        }

        public void close() {
            this.values.close();
        }
    }

    public static class GroupingState
    implements GroupingAggregatorState {
        private int maxGroupId = -1;
        private final BlockFactory blockFactory;
        private final LongHash values;
        private Sorted sortedForOrdinalMerging = null;

        private GroupingState(DriverContext driverContext) {
            this.blockFactory = driverContext.blockFactory();
            this.values = new LongHash(1L, driverContext.bigArrays());
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
            blocks[offset] = this.toBlock(driverContext.blockFactory(), selected);
        }

        void addValue(int groupId, int v) {
            this.values.add((long)groupId << 32 | (long)v & 0xFFFFFFFFL);
            this.maxGroupId = Math.max(this.maxGroupId, groupId);
        }

        Block toBlock(BlockFactory blockFactory, IntVector selected) {
            if (this.values.size() == 0L) {
                return blockFactory.newConstantNullBlock(selected.getPositionCount());
            }
            try (Sorted sorted = this.buildSorted(selected);){
                Block block = this.buildOutputBlock(blockFactory, selected, sorted.counts, sorted.ids);
                return block;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Sorted buildSorted(IntVector selected) {
            long selectedCountsSize = 0L;
            long idsSize = 0L;
            Sorted sorted = null;
            try {
                int selectedCountsLen = selected.max() + 1;
                long adjust = RamUsageEstimator.alignObjectSize((long)(RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + selectedCountsLen * 4));
                this.blockFactory.adjustBreaker(adjust);
                selectedCountsSize = adjust;
                int[] selectedCounts = new int[selectedCountsLen];
                int id = 0;
                while ((long)id < this.values.size()) {
                    long both = this.values.get((long)id);
                    int group = (int)(both >>> 32);
                    if (group < selectedCounts.length) {
                        int n = group;
                        selectedCounts[n] = selectedCounts[n] - 1;
                    }
                    ++id;
                }
                int total = 0;
                for (int s = 0; s < selected.getPositionCount(); ++s) {
                    int group = selected.getInt(s);
                    int count = -selectedCounts[group];
                    selectedCounts[group] = total;
                    total += count;
                }
                adjust = RamUsageEstimator.alignObjectSize((long)(RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + total * 4));
                this.blockFactory.adjustBreaker(adjust);
                idsSize = adjust;
                int[] ids = new int[total];
                int id2 = 0;
                while ((long)id2 < this.values.size()) {
                    long both = this.values.get((long)id2);
                    int group = (int)(both >>> 32);
                    if (group < selectedCounts.length && selectedCounts[group] >= 0) {
                        int n = group;
                        int n2 = selectedCounts[n];
                        selectedCounts[n] = n2 + 1;
                        ids[n2] = id2;
                    }
                    ++id2;
                }
                long totalMemoryUsed = selectedCountsSize + idsSize;
                Sorted sorted2 = sorted = new Sorted(() -> this.blockFactory.adjustBreaker(-totalMemoryUsed), selectedCounts, ids);
                return sorted2;
            }
            finally {
                if (sorted == null) {
                    this.blockFactory.adjustBreaker(-selectedCountsSize - idsSize);
                }
            }
        }

        private Sorted sortedForOrdinalMerging(GroupingState other) {
            if (this.sortedForOrdinalMerging == null) {
                try (IntVector selected = IntVector.range(0, this.maxGroupId + 1, this.blockFactory);){
                    this.sortedForOrdinalMerging = this.buildSorted(selected);
                }
            }
            return this.sortedForOrdinalMerging;
        }

        Block buildOutputBlock(BlockFactory blockFactory, IntVector selected, int[] selectedCounts, int[] ids) {
            try (IntBlock.Builder builder = blockFactory.newIntBlockBuilder(selected.getPositionCount());){
                int start = 0;
                for (int s = 0; s < selected.getPositionCount(); ++s) {
                    int group = selected.getInt(s);
                    int end = selectedCounts[group];
                    int count = end - start;
                    switch (count) {
                        case 0: {
                            builder.appendNull();
                            break;
                        }
                        case 1: {
                            builder.appendInt(this.getValue(ids[start]));
                            break;
                        }
                        default: {
                            builder.beginPositionEntry();
                            for (int i = start; i < end; ++i) {
                                builder.appendInt(this.getValue(ids[i]));
                            }
                            builder.endPositionEntry();
                        }
                    }
                    start = end;
                }
                IntBlock intBlock = builder.build();
                return intBlock;
            }
        }

        int getValue(int valueId) {
            long both = this.values.get((long)valueId);
            return (int)both;
        }

        @Override
        public void enableGroupIdTracking(SeenGroupIds seen) {
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.values, this.sortedForOrdinalMerging});
        }
    }

    private record Sorted(Releasable releasable, int[] counts, int[] ids) implements Releasable
    {
        public void close() {
            this.releasable.close();
        }
    }
}

