const ipc = require('./ipc.js');

/**
 * Sends metrics to the Electron main process where they can be aggregated in a single process
 */
class ElectronRendererMetricsAggregator {
    constructor() {
        this._ipc = ipc.getIPC();
    }
    /** @inheritdoc */
    add(metricType, name, value, unit, tags, timestamp) {
        this._ipc.sendAddMetric({ metricType, name, value, unit, tags, timestamp });
    }
    /** @inheritdoc */
    flush() {
        // do nothing
    }
    /** @inheritdoc */
    close() {
        // do nothing
    }
    /** @inheritdoc */
    toString() {
        return '';
    }
}

exports.ElectronRendererMetricsAggregator = ElectronRendererMetricsAggregator;
//# sourceMappingURL=metrics.js.map
