import { defineIntegration, getCurrentScope, convertIntegrationFnToClass } from '@sentry/core';
import { normalize } from '@sentry/utils';
import { getIPC } from '../ipc.js';

const INTEGRATION_NAME = 'ScopeToMain';
/**
 * Passes scope changes to the main process.
 */
const scopeToMainIntegration = defineIntegration(() => {
    return {
        name: INTEGRATION_NAME,
        setupOnce() {
            // noop
        },
        setup() {
            const scope = getCurrentScope();
            if (scope) {
                const ipc = getIPC();
                scope.addScopeListener((updatedScope) => {
                    ipc.sendScope(JSON.stringify(normalize(updatedScope.getScopeData(), 20, 2000)));
                    scope.clearBreadcrumbs();
                    scope.clearAttachments();
                });
            }
        },
    };
});
/**
 * Passes scope changes to the main process.
 *
 * @deprecated Use `scopeToMainIntegration()` instead
 */
// eslint-disable-next-line deprecation/deprecation
const ScopeToMain = convertIntegrationFnToClass(INTEGRATION_NAME, scopeToMainIntegration);

export { ScopeToMain, scopeToMainIntegration };
//# sourceMappingURL=scope-to-main.js.map
