/* libdino.vapi generated by valac 0.56.18-dirty, do not modify. */

namespace Dino {
	namespace Entities {
		[CCode (cheader_filename = "libdino.h")]
		public class Account : GLib.Object {
			public Account (Xmpp.Jid bare_jid, string password);
			public bool equals (Dino.Entities.Account acc);
			public static bool equals_func (Dino.Entities.Account acc1, Dino.Entities.Account acc2);
			public Account.from_row (Dino.Database db, Qlite.Row row) throws Xmpp.InvalidJidError;
			public static uint hash_func (Dino.Entities.Account acc);
			public void persist (Dino.Database db);
			public void remove ();
			public void set_random_resource ();
			public string? alias { get; set; }
			public Xmpp.Jid bare_jid { owned get; }
			public string display_name { owned get; }
			public string domainpart { get; }
			public bool enabled { get; set; }
			public Xmpp.Jid full_jid { get; private set; }
			public int id { get; set; }
			public string localpart { get; }
			public string? password { get; set; }
			public string resourcepart { get; private set; }
			public string? roster_version { get; set; }
		}
		[CCode (cheader_filename = "libdino.h")]
		public class Call : GLib.Object {
			public enum State {
				RINGING,
				ESTABLISHING,
				IN_PROGRESS,
				OTHER_DEVICE,
				ENDED,
				DECLINED,
				MISSED,
				FAILED
			}
			public Gee.List<Xmpp.Jid> counterparts;
			public const bool DIRECTION_INCOMING;
			public const bool DIRECTION_OUTGOING;
			public Call ();
			public void add_peer (Xmpp.Jid peer);
			public bool equals (Dino.Entities.Call c);
			public static bool equals_func (Dino.Entities.Call c1, Dino.Entities.Call c2);
			public Call.from_row (Dino.Database db, Qlite.Row row) throws Xmpp.InvalidJidError;
			public static uint hash_func (Dino.Entities.Call call);
			public void persist (Dino.Database db);
			public Dino.Entities.Account account { get; set; }
			public Xmpp.Jid counterpart { get; set; }
			public bool direction { get; set; }
			public Dino.Entities.Encryption encryption { get; set; }
			public GLib.DateTime end_time { get; set; }
			public int id { get; set; }
			public GLib.DateTime local_time { get; set; }
			public Xmpp.Jid ourpart { get; set; }
			public Xmpp.Jid proposer { get; }
			public Dino.Entities.Call.State state { get; set; }
			public GLib.DateTime time { get; set; }
		}
		[CCode (cheader_filename = "libdino.h")]
		public class Conversation : GLib.Object {
			public enum NotifySetting {
				DEFAULT,
				ON,
				OFF,
				HIGHLIGHT
			}
			public enum Setting {
				DEFAULT,
				ON,
				OFF
			}
			public enum Type {
				CHAT,
				GROUPCHAT,
				GROUPCHAT_PM;
				public bool is_muc_semantic ();
			}
			public Conversation (Xmpp.Jid jid, Dino.Entities.Account account, Dino.Entities.Conversation.Type type);
			public bool equals (Dino.Entities.Conversation? conversation);
			public static bool equals_func (Dino.Entities.Conversation conversation1, Dino.Entities.Conversation conversation2);
			public Conversation.from_row (Dino.Database db, Qlite.Row row) throws Xmpp.InvalidJidError;
			public Dino.Entities.Conversation.NotifySetting get_notification_default_setting (Dino.StreamInteractor stream_interactor);
			public Dino.Entities.Conversation.NotifySetting get_notification_setting (Dino.StreamInteractor stream_interactor);
			public Dino.Entities.Conversation.Setting get_send_marker_setting (Dino.StreamInteractor stream_interactor);
			public Dino.Entities.Conversation.Setting get_send_typing_setting (Dino.StreamInteractor stream_interactor);
			public static uint hash_func (Dino.Entities.Conversation conversation);
			public void persist (Dino.Database db);
			public Dino.Entities.Account account { get; private set; }
			public bool active { get; set; }
			public GLib.DateTime active_last_changed { get; private set; }
			public Xmpp.Jid counterpart { get; private set; }
			public Dino.Entities.Encryption encryption { get; set; }
			public int id { get; set; }
			public GLib.DateTime? last_active { get; set; }
			public string? nickname { get; set; }
			public Dino.Entities.Conversation.NotifySetting notify_setting { get; set; }
			public int pinned { get; set; }
			public Dino.Entities.Message? read_up_to { get; set; }
			public int read_up_to_item { get; set; }
			public Dino.Entities.Conversation.Setting send_marker { get; set; }
			public Dino.Entities.Conversation.Setting send_typing { get; set; }
			public Dino.Entities.Conversation.Type type_ { get; set; }
			public signal void object_updated (Dino.Entities.Conversation conversation);
		}
		[CCode (cheader_filename = "libdino.h")]
		public class FileTransfer : GLib.Object {
			public enum State {
				COMPLETE,
				IN_PROGRESS,
				NOT_STARTED,
				FAILED
			}
			public Gee.List<Xmpp.Xep.CryptographicHashes.Hash> hashes;
			public Gee.List<Xmpp.Xep.StatelessFileSharing.Source> sfs_sources;
			public Gee.List<Xmpp.Xep.JingleContentThumbnails.Thumbnail> thumbnails;
			public const bool DIRECTION_RECEIVED;
			public const bool DIRECTION_SENT;
			public FileTransfer ();
			public void add_sfs_source (Xmpp.Xep.StatelessFileSharing.Source source);
			public FileTransfer.from_row (Dino.Database db, Qlite.Row row, string storage_dir) throws Xmpp.InvalidJidError;
			public GLib.File? get_file ();
			public void persist (Dino.Database db);
			public Dino.Entities.Account account { get; set; }
			public GLib.Cancellable cancellable { get; }
			public Xmpp.Jid counterpart { get; set; }
			public string? desc { get; set; }
			public bool direction { get; set; }
			public Dino.Entities.Encryption encryption { get; set; }
			public Xmpp.Xep.FileMetadataElement.FileMetadata file_metadata { owned get; set; }
			public string file_name { get; set; }
			public string? file_sharing_id { get; set; }
			public Xmpp.Jid? from { get; }
			public int height { get; set; }
			public int id { get; set; }
			public string info { get; set; }
			public GLib.InputStream input_stream { get; set; }
			public int64 length { get; set; }
			public GLib.DateTime? local_time { get; set; }
			public string? mime_type { get; set; }
			public GLib.DateTime? modification_date { get; set; }
			public Xmpp.Jid ourpart { get; set; }
			public string path { get; set; }
			public int provider { get; set; }
			public string server_file_name { get; set; }
			public int64 size { get; set; }
			public Dino.Entities.FileTransfer.State state { get; set; }
			public GLib.DateTime time { get; set; }
			public Xmpp.Jid? to { get; }
			public int64 transferred_bytes { get; set; }
			public int width { get; set; }
			public signal void sources_changed ();
		}
		[CCode (cheader_filename = "libdino.h")]
		public class Message : GLib.Object {
			public enum Marked {
				NONE,
				RECEIVED,
				READ,
				ACKNOWLEDGED,
				UNSENT,
				WONTSEND,
				SENDING,
				SENT,
				ERROR
			}
			public enum Type {
				ERROR,
				CHAT,
				GROUPCHAT,
				GROUPCHAT_PM,
				UNKNOWN;
				public bool is_muc_semantic ();
			}
			public static Dino.Entities.Message.Marked[] MARKED_RECEIVED;
			public string? edit_to;
			public const bool DIRECTION_RECEIVED;
			public const bool DIRECTION_SENT;
			public Message (string? body);
			public bool equals (Dino.Entities.Message? m);
			public static bool equals_func (Dino.Entities.Message m1, Dino.Entities.Message m2);
			public Message.from_row (Dino.Database db, Qlite.Row row) throws Xmpp.InvalidJidError;
			public Gee.List<Xmpp.Xep.FallbackIndication.Fallback> get_fallbacks ();
			public Gee.List<Xmpp.Xep.MessageMarkup.Span> get_markups ();
			public new string get_type_string ();
			public static uint hash_func (Dino.Entities.Message message);
			public void persist (Dino.Database db);
			public void persist_markups (Gee.List<Xmpp.Xep.MessageMarkup.Span> markups, int message_id);
			public void set_fallbacks (Gee.List<Xmpp.Xep.FallbackIndication.Fallback> fallbacks);
			public void set_quoted_item (int quoted_content_item_id);
			public void set_type_string (string type);
			public Dino.Entities.Account account { get; set; }
			public string? body { get; set; }
			public Xmpp.Jid? counterpart { get; set; }
			public bool direction { get; set; }
			public Dino.Entities.Encryption encryption { get; set; }
			public Xmpp.Jid? from { get; }
			public int id { get; set; }
			public GLib.DateTime? local_time { get; set; }
			public Dino.Entities.Message.Marked marked { get; set; }
			public int occupant_db_id { get; set; }
			public Xmpp.Jid? ourpart { get; set; }
			public int quoted_item_id { get; private set; }
			public Xmpp.Jid? real_jid { get; set; }
			public string? server_id { get; set; }
			public string? stanza_id { get; set; }
			public GLib.DateTime? time { get; set; }
			public Xmpp.Jid? to { get; }
			public Dino.Entities.Message.Type type_ { get; set; }
		}
		[CCode (cheader_filename = "libdino.h")]
		public class Settings : GLib.Object {
			public Settings ();
			public Settings.from_db (Dino.Database db);
			public Dino.Entities.Encryption get_default_encryption (Dino.Entities.Account account);
			public void set_default_encryption (Dino.Entities.Account account, Dino.Entities.Encryption encryption);
			public bool check_spelling { get; set; }
			public bool convert_utf8_smileys { get; set; }
			public bool notifications { get; set; }
			public bool send_marker { get; set; }
			public bool send_typing { get; set; }
		}
		[CCode (cheader_filename = "libdino.h")]
		public enum Encryption {
			NONE,
			PGP,
			OMEMO,
			DTLS_SRTP,
			SRTP,
			UNKNOWN;
			public bool is_some ();
		}
	}
	namespace Model {
		[CCode (cheader_filename = "libdino.h")]
		public class ConversationDisplayName : GLib.Object {
			public ConversationDisplayName ();
			public string display_name { get; set; }
		}
	}
	namespace Plugins {
		[CCode (cheader_filename = "libdino.h")]
		public abstract class AccountSettingsEntry : GLib.Object {
			protected AccountSettingsEntry ();
			public abstract void deactivate ();
			public abstract GLib.Object? get_widget (Dino.Plugins.WidgetType type);
			public abstract void set_account (Dino.Entities.Account account);
			public abstract string id { get; }
			public virtual int16 label_top_padding { get; }
			public abstract string name { get; }
			public virtual Dino.Plugins.Priority priority { get; }
			public signal void activated ();
		}
		[CCode (cheader_filename = "libdino.h")]
		public class ContactDetails : GLib.Object {
			public ContactDetails ();
			public signal void add_settings_action_row (GLib.Object action_row_model);
			public signal void save ();
		}
		[CCode (cheader_filename = "libdino.h")]
		public abstract class EncryptionPreferencesEntry : GLib.Object {
			protected EncryptionPreferencesEntry ();
			public abstract GLib.Object? get_widget (Dino.Entities.Account account, Dino.Plugins.WidgetType type);
			public abstract string id { get; }
			public virtual Dino.Plugins.Priority priority { get; }
		}
		[CCode (cheader_filename = "libdino.h")]
		public class InputFieldStatus : GLib.Object {
			public enum InputState {
				NORMAL,
				DISABLED,
				NO_SEND
			}
			public enum MessageType {
				NONE,
				INFO,
				WARNING,
				ERROR
			}
			public bool contains_markup;
			public Dino.Plugins.InputFieldStatus.InputState input_state;
			public string? message;
			public Dino.Plugins.InputFieldStatus.MessageType message_type;
			public InputFieldStatus (string? message, Dino.Plugins.InputFieldStatus.MessageType message_type, Dino.Plugins.InputFieldStatus.InputState input_state, bool contains_markup = false);
		}
		[CCode (cheader_filename = "libdino.h")]
		public class Loader : GLib.Object {
			public Loader (Dino.Application app);
			public Dino.Plugins.RootInterface load (string name) throws GLib.Error;
			public void load_all () throws GLib.Error;
			public void shutdown ();
		}
		[CCode (cheader_filename = "libdino.h")]
		public class MessageAction : GLib.Object {
			public Dino.Plugins.MessageActionEvoked? callback;
			public string icon_name;
			public string name;
			public GLib.Object? popover;
			public bool sensitive;
			public string? tooltip;
			public MessageAction ();
		}
		[CCode (cheader_filename = "libdino.h")]
		public abstract class MetaConversationItem : GLib.Object {
			protected MetaConversationItem ();
			public abstract Gee.List<Dino.Plugins.MessageAction>? get_item_actions (Dino.Plugins.WidgetType type);
			public abstract GLib.Object? get_widget (Dino.Plugins.ConversationItemWidgetInterface outer, Dino.Plugins.WidgetType type);
			public bool can_merge { get; set; }
			public virtual Dino.Entities.Encryption encryption { get; set; }
			public bool in_edit_mode { get; set; }
			public virtual Xmpp.Jid? jid { get; set; }
			public virtual Dino.Entities.Message.Marked mark { get; set; }
			public virtual string populator_id { get; set; }
			public bool requires_avatar { get; set; }
			public bool requires_header { get; set; }
			public virtual int secondary_sort_indicator { get; set; }
			public virtual GLib.DateTime time { get; set; }
		}
		[CCode (cheader_filename = "libdino.h")]
		public abstract class MetaConversationNotification : GLib.Object {
			protected MetaConversationNotification ();
			public abstract GLib.Object? get_widget (Dino.Plugins.WidgetType type);
		}
		[CCode (cheader_filename = "libdino.h")]
		public class Registry {
			public Gee.ArrayList<Dino.Plugins.AccountSettingsEntry> account_settings_entries;
			public Gee.HashMap<string,Dino.Plugins.CallEncryptionEntry> call_encryption_entries;
			public Gee.ArrayList<Dino.Plugins.ContactDetailsProvider> contact_details_entries;
			public Gee.List<Dino.Plugins.ConversationAdditionPopulator> conversation_addition_populators;
			public Gee.Collection<Dino.Plugins.ConversationTitlebarEntry> conversation_titlebar_entries;
			public Gee.HashMap<Dino.Entities.Encryption,Dino.Plugins.EncryptionListEntry> encryption_list_entries;
			public Gee.ArrayList<Dino.Plugins.EncryptionPreferencesEntry> encryption_preferences_entries;
			public Gee.List<Dino.Plugins.NotificationPopulator> notification_populators;
			public Gee.Map<string,Dino.Plugins.TextCommand> text_commands;
			public Dino.Plugins.VideoCallPlugin? video_call_plugin;
			public Registry ();
			public bool register_account_settings_entry (Dino.Plugins.AccountSettingsEntry entry);
			public bool register_call_entryption_entry (string ns, Dino.Plugins.CallEncryptionEntry entry);
			public bool register_contact_details_entry (Dino.Plugins.ContactDetailsProvider entry);
			public bool register_contact_titlebar_entry (Dino.Plugins.ConversationTitlebarEntry entry);
			public bool register_conversation_addition_populator (Dino.Plugins.ConversationAdditionPopulator populator);
			public bool register_encryption_list_entry (Dino.Plugins.EncryptionListEntry entry);
			public bool register_encryption_preferences_entry (Dino.Plugins.EncryptionPreferencesEntry entry);
			public bool register_notification_populator (Dino.Plugins.NotificationPopulator populator);
			public bool register_text_command (Dino.Plugins.TextCommand cmd);
		}
		[CCode (cheader_filename = "libdino.h")]
		public interface CallEncryptionEntry : GLib.Object {
			public abstract Dino.Plugins.CallEncryptionWidget? get_widget (Dino.Entities.Account account, Xmpp.Xep.Jingle.ContentEncryption encryption);
		}
		[CCode (cheader_filename = "libdino.h")]
		public interface CallEncryptionWidget : GLib.Object {
			public abstract string? get_icon_name ();
			public abstract string? get_title ();
			public abstract bool show_keys ();
		}
		[CCode (cheader_filename = "libdino.h")]
		public interface ContactDetailsProvider : GLib.Object {
			public abstract GLib.Object? get_widget (Dino.Entities.Conversation conversation);
			public abstract void populate (Dino.Entities.Conversation conversation, Dino.Plugins.ContactDetails contact_details, Dino.Plugins.WidgetType type);
			public abstract string id { get; }
			public abstract string tab { get; }
		}
		[CCode (cheader_filename = "libdino.h")]
		public interface ConversationAdditionPopulator : Dino.Plugins.ConversationItemPopulator {
			public virtual void populate_timespan (Dino.Entities.Conversation conversation, GLib.DateTime from, GLib.DateTime to);
		}
		[CCode (cheader_filename = "libdino.h")]
		public interface ConversationItemCollection : GLib.Object {
			public abstract void insert_item (Dino.Plugins.MetaConversationItem item);
			public abstract void remove_item (Dino.Plugins.MetaConversationItem item);
			public signal void inserted_item (Dino.Plugins.MetaConversationItem item);
			public signal void removed_item (Dino.Plugins.MetaConversationItem item);
		}
		[CCode (cheader_filename = "libdino.h")]
		public interface ConversationItemPopulator : GLib.Object {
			public abstract void close (Dino.Entities.Conversation conversation);
			public abstract void init (Dino.Entities.Conversation conversation, Dino.Plugins.ConversationItemCollection summary, Dino.Plugins.WidgetType type);
			public abstract string id { get; }
		}
		[CCode (cheader_filename = "libdino.h")]
		public interface ConversationItemWidgetInterface : GLib.Object {
			public abstract void set_widget (GLib.Object object, Dino.Plugins.WidgetType type, int priority);
		}
		[CCode (cheader_filename = "libdino.h")]
		public interface ConversationTitlebarEntry : GLib.Object {
			public abstract GLib.Object? get_widget (Dino.Plugins.WidgetType type);
			public abstract void set_conversation (Dino.Entities.Conversation conversation);
			public abstract void unset_conversation ();
			public abstract string id { get; }
			public abstract double order { get; }
		}
		[CCode (cheader_filename = "libdino.h")]
		public interface EncryptionListEntry : GLib.Object {
			public abstract void encryption_activated (Dino.Entities.Conversation conversation, Dino.Plugins.SetInputFieldStatus callback);
			public abstract GLib.Object? get_encryption_icon (Dino.Entities.Conversation conversation, Dino.ContentItem content_item);
			public abstract string? get_encryption_icon_name (Dino.Entities.Conversation conversation, Dino.ContentItem content_item);
			public abstract Dino.Entities.Encryption encryption { get; }
			public abstract string name { get; }
		}
		[CCode (cheader_filename = "libdino.h")]
		public interface MediaDevice : GLib.Object {
			public abstract string? detail_name { owned get; }
			public abstract string display_name { owned get; }
			public abstract string id { owned get; }
			public abstract bool incoming { get; }
			public abstract string? media { owned get; }
		}
		[CCode (cheader_filename = "libdino.h")]
		public interface NotificationCollection : GLib.Object {
			public signal void add_meta_notification (Dino.Plugins.MetaConversationNotification item);
			public signal void remove_meta_notification (Dino.Plugins.MetaConversationNotification item);
		}
		[CCode (cheader_filename = "libdino.h")]
		public interface NotificationPopulator : GLib.Object {
			public abstract void close (Dino.Entities.Conversation conversation);
			public abstract void init (Dino.Entities.Conversation conversation, Dino.Plugins.NotificationCollection summary, Dino.Plugins.WidgetType type);
			public abstract string id { get; }
		}
		[CCode (cheader_filename = "libdino.h")]
		public interface RootInterface : GLib.Object {
			public abstract void registered (Dino.Application app);
			public abstract void shutdown ();
		}
		[CCode (cheader_filename = "libdino.h")]
		public interface TextCommand : GLib.Object {
			public abstract string? handle_command (string? text, Dino.Entities.Conversation? conversation);
			public abstract string cmd { get; }
		}
		[CCode (cheader_filename = "libdino.h")]
		public interface VideoCallPlugin : GLib.Object {
			public abstract Dino.Plugins.VideoCallWidget? create_widget (Dino.Plugins.WidgetType type);
			public abstract void dump_dot ();
			public abstract Dino.Plugins.MediaDevice? get_device (Xmpp.Xep.JingleRtp.Stream? stream, bool incoming);
			public abstract Gee.List<Dino.Plugins.MediaDevice> get_devices (string media, bool incoming);
			public abstract Dino.Plugins.MediaDevice? get_preferred_device (string media, bool incoming);
			public abstract void set_device (Xmpp.Xep.JingleRtp.Stream? stream, Dino.Plugins.MediaDevice? device);
			public abstract void set_pause (Xmpp.Xep.JingleRtp.Stream? stream, bool pause);
			public abstract bool supported ();
			public signal void devices_changed (string media, bool incoming);
		}
		[CCode (cheader_filename = "libdino.h")]
		public interface VideoCallWidget : GLib.Object {
			public abstract void detach ();
			public abstract void display_device (Dino.Plugins.MediaDevice device);
			public abstract void display_stream (Xmpp.Xep.JingleRtp.Stream? stream, Xmpp.Jid jid);
			public signal void resolution_changed (uint width, uint height);
		}
		[CCode (cheader_filename = "libdino.h")]
		public enum Priority {
			LOWEST,
			LOWER,
			DEFAULT,
			HIGHER,
			HIGHEST
		}
		[CCode (cheader_filename = "libdino.h")]
		public enum WidgetType {
			GTK3,
			GTK4
		}
		[CCode (cheader_filename = "libdino.h")]
		public delegate void MessageActionEvoked (GLib.Variant? variant);
		[CCode (cheader_filename = "libdino.h")]
		public delegate void SetInputFieldStatus (Dino.Plugins.InputFieldStatus field_status);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class AvatarManager : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.AvatarManager> IDENTITY;
		public async bool fetch_and_store_for_jid (Dino.Entities.Account account, Xmpp.Jid jid);
		public GLib.File? get_avatar_file (Dino.Entities.Account account, Xmpp.Jid jid_);
		public Gee.HashMap<Xmpp.Jid,string> get_avatar_hashes (Dino.Entities.Account account, int type);
		public bool has_avatar (Dino.Entities.Account account, Xmpp.Jid jid);
		public bool has_image (string id);
		public void publish (Dino.Entities.Account account, string file);
		public void remove_avatar_hash (Dino.Entities.Account account, Xmpp.Jid jid, int type);
		public void set_avatar_hash (Dino.Entities.Account account, Xmpp.Jid jid, string hash, int type);
		public static void start (Dino.StreamInteractor stream_interactor, Dino.Database db);
		public void unset_avatar (Dino.Entities.Account account);
		public signal void fetched_avatar (Xmpp.Jid jid, Dino.Entities.Account account);
		public signal void received_avatar (Xmpp.Jid jid, Dino.Entities.Account account);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class BlockingManager : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.BlockingManager> IDENTITY;
		public void block (Dino.Entities.Account account, Xmpp.Jid jid);
		public bool is_blocked (Dino.Entities.Account account, Xmpp.Jid jid);
		public bool is_supported (Dino.Entities.Account account);
		public static void start (Dino.StreamInteractor stream_interactor);
		public void unblock (Dino.Entities.Account account, Xmpp.Jid jid);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class CallItem : Dino.ContentItem {
		public Dino.Entities.Call call;
		public Dino.Entities.Conversation conversation;
		public const string TYPE;
		public CallItem (Dino.Entities.Call call, Dino.Entities.Conversation conversation, int id);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class CallState : GLib.Object {
		public Dino.Entities.Call call;
		public Dino.Plugins.VideoCallPlugin call_plugin;
		public string? cim_call_id;
		public Xmpp.Jid? cim_counterpart;
		public Gee.ArrayList<Xmpp.Jid> cim_jids_to_inform;
		public Xmpp.Jid? invited_to_group_call;
		public Gee.HashMap<Xmpp.Jid,Dino.PeerState> peers;
		public Dino.StreamInteractor stream_interactor;
		public bool use_cim;
		public CallState (Dino.Entities.Call call, Dino.StreamInteractor stream_interactor);
		public void accept ();
		public async bool can_convert_into_groupcall ();
		public async void convert_into_group_call ();
		public void end (string? reason_text = null);
		public Dino.Plugins.MediaDevice? get_microphone_device ();
		public Dino.Plugins.MediaDevice? get_speaker_device ();
		public Dino.Plugins.MediaDevice? get_video_device ();
		public async void invite_to_call (Xmpp.Jid invitee);
		public async void join_group_call (Xmpp.Jid muc_jid);
		public void mute_own_audio (bool mute);
		public void mute_own_video (bool mute);
		public void reject ();
		public void set_audio_device (Dino.Plugins.MediaDevice? device);
		public void set_video_device (Dino.Plugins.MediaDevice? device);
		public bool should_we_send_video ();
		public bool accepted { get; private set; }
		public string cim_message_type { get; set; }
		public Xmpp.Xep.Muji.GroupCall? group_call { get; set; }
		public Xmpp.Jid? parent_muc { get; set; }
		public bool we_should_send_audio { get; set; }
		public bool we_should_send_video { get; set; }
		public signal void peer_joined (Xmpp.Jid jid, Dino.PeerState peer_state);
		public signal void peer_left (Xmpp.Jid jid, Dino.PeerState peer_state, string? reason_name, string? reason_text);
		public signal void terminated (Xmpp.Jid who_terminated, string? reason_name, string? reason_text);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class CallStore : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.CallStore> IDENTITY;
		public void add_call (Dino.Entities.Call call, Dino.Entities.Conversation conversation);
		public Dino.Entities.Call? get_call_by_id (int id, Dino.Entities.Conversation conversation);
		public static void start (Dino.StreamInteractor stream_interactor, Dino.Database db);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class Calls : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.Calls> IDENTITY;
		public Gee.HashMap<Dino.Entities.Call,Dino.CallState> call_states;
		public Gee.HashMap<Dino.Entities.Call,Dino.PeerState> jmi_request_peer;
		public async bool can_conversation_do_calls (Dino.Entities.Conversation conversation);
		public bool can_initiate_groupcall (Dino.Entities.Account account);
		public bool can_we_do_calls (Dino.Entities.Account account);
		public async bool contains_jmi_resources (Dino.Entities.Account account, Gee.List<Xmpp.Jid> full_jids);
		public async Gee.List<Xmpp.Jid> get_call_resources (Dino.Entities.Account account, Xmpp.Jid counterpart);
		public bool has_jmi_resources (Xmpp.Jid counterpart);
		public async Dino.CallState? initiate_call (Dino.Entities.Conversation conversation, bool video);
		public bool is_call_in_progress ();
		public static void start (Dino.StreamInteractor stream_interactor, Dino.Database db);
		public signal void call_incoming (Dino.Entities.Call call, Dino.CallState state, Dino.Entities.Conversation conversation, bool video, bool multiparty);
		public signal void call_outgoing (Dino.Entities.Call call, Dino.CallState state, Dino.Entities.Conversation conversation);
		public signal void call_terminated (Dino.Entities.Call call, string? reason_name, string? reason_text);
		public signal void conference_info_received (Dino.Entities.Call call, Xmpp.Xep.Coin.ConferenceInfo conference_info);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class CapsCacheImpl : Xmpp.Xep.ServiceDiscovery.CapsCache, GLib.Object {
		public CapsCacheImpl (Dino.Entities.Account account, Dino.EntityInfo entity_info);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class ChatInteraction : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.ChatInteraction> IDENTITY;
		public int get_num_unread (Dino.Entities.Conversation conversation);
		public bool is_active_focus (Dino.Entities.Conversation? conversation = null);
		public void on_conversation_selected (Dino.Entities.Conversation conversation);
		public void on_message_cleared (Dino.Entities.Conversation? conversation);
		public void on_message_entered (Dino.Entities.Conversation? conversation);
		public void on_window_focus_in (Dino.Entities.Conversation? conversation);
		public void on_window_focus_out (Dino.Entities.Conversation? conversation);
		public static void start (Dino.StreamInteractor stream_interactor);
		public signal void focused_in (Dino.Entities.Conversation conversation);
		public signal void focused_out (Dino.Entities.Conversation conversation);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class ConnectionManager : GLib.Object {
		public class ConnectionError {
			public enum Reconnect {
				NOW,
				LATER,
				NEVER
			}
			public enum Source {
				CONNECTION,
				SASL,
				TLS,
				STREAM_ERROR
			}
			public string? identifier;
			public Dino.ConnectionManager.ConnectionError.Source source;
			public ConnectionError (Dino.ConnectionManager.ConnectionError.Source source, string? identifier);
			public Dino.ConnectionManager.ConnectionError.Reconnect reconnect_recomendation { get; set; }
		}
		public enum ConnectionState {
			CONNECTED,
			CONNECTING,
			DISCONNECTED
		}
		public string? log_options;
		public ConnectionManager (Dino.ModuleManager module_manager);
		public void connect_account (Dino.Entities.Account account);
		public async void disconnect_account (Dino.Entities.Account account);
		public Dino.ConnectionManager.ConnectionError? get_error (Dino.Entities.Account account);
		public Gee.Collection<Dino.Entities.Account> get_managed_accounts ();
		public Dino.ConnectionManager.ConnectionState get_state (Dino.Entities.Account account);
		public Xmpp.XmppStream? get_stream (Dino.Entities.Account account);
		public void make_offline_all ();
		public static bool on_invalid_certificate (string domain, GLib.TlsCertificate peer_cert, GLib.TlsCertificateFlags errors);
		public signal void connection_error (Dino.Entities.Account account, Dino.ConnectionManager.ConnectionError error);
		public signal void connection_state_changed (Dino.Entities.Account account, Dino.ConnectionManager.ConnectionState state);
		public signal void stream_attached_modules (Dino.Entities.Account account, Xmpp.XmppStream stream);
		public signal void stream_opened (Dino.Entities.Account account, Xmpp.XmppStream stream);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class ContactModels : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.ContactModels> IDENTITY;
		public Dino.Model.ConversationDisplayName get_display_name_model (Dino.Entities.Conversation conversation);
		public static void start (Dino.StreamInteractor stream_interactor);
	}
	[CCode (cheader_filename = "libdino.h")]
	public abstract class ContentItem : GLib.Object {
		public int compare (Dino.ContentItem c);
		public static int compare_func (Dino.ContentItem a, Dino.ContentItem b);
		public Dino.Entities.Encryption encryption { get; set; }
		public int id { get; set; }
		public Xmpp.Jid jid { get; set; }
		public Dino.Entities.Message.Marked mark { get; set; }
		public GLib.DateTime time { get; set; }
		public string type_ { get; set; }
	}
	[CCode (cheader_filename = "libdino.h")]
	public class ContentItemStore : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.ContentItemStore> IDENTITY;
		public ContentItemStore (Dino.StreamInteractor stream_interactor, Dino.Database db);
		public Gee.List<Dino.ContentItem> get_after (Dino.Entities.Conversation conversation, Dino.ContentItem item, int count);
		public Gee.List<Dino.ContentItem> get_before (Dino.Entities.Conversation conversation, Dino.ContentItem item, int count);
		public Dino.ContentItem? get_content_item_for_referencing_id (Dino.Entities.Conversation conversation, string message_id);
		public int get_content_item_id_for_referencing_id (Dino.Entities.Conversation conversation, string message_id);
		public Dino.ContentItem? get_item_by_foreign (Dino.Entities.Conversation conversation, int type, int foreign_id);
		public Dino.ContentItem? get_item_by_id (Dino.Entities.Conversation conversation, int id);
		public bool get_item_hide (Dino.ContentItem content_item);
		public Dino.ContentItem? get_latest (Dino.Entities.Conversation conversation);
		public Dino.Entities.Message? get_message_for_content_item (Dino.Entities.Conversation conversation, Dino.ContentItem content_item);
		public string? get_message_id_for_content_item (Dino.Entities.Conversation conversation, Dino.ContentItem content_item);
		public Xmpp.Jid? get_message_sender_for_content_item (Dino.Entities.Conversation conversation, Dino.ContentItem content_item);
		public Gee.List<Dino.ContentItem> get_n_latest (Dino.Entities.Conversation conversation, int count);
		public void init (Dino.Entities.Conversation conversation, Dino.ContentItemCollection item_collection);
		public void insert_message (Dino.Entities.Message message, Dino.Entities.Conversation conversation, bool hide = false);
		public void set_item_hide (Dino.ContentItem content_item, bool hide);
		public static void start (Dino.StreamInteractor stream_interactor, Dino.Database db);
		public void uninit (Dino.Entities.Conversation conversation, Dino.ContentItemCollection item_collection);
		public signal void new_item (Dino.ContentItem item, Dino.Entities.Conversation conversation);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class ConversationManager : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.ConversationManager> IDENTITY;
		public Dino.Entities.Conversation? approx_conversation_for_stanza (Xmpp.Jid from, Xmpp.Jid to, Dino.Entities.Account account, string msg_ty);
		public void close_conversation (Dino.Entities.Conversation conversation);
		public Dino.Entities.Conversation create_conversation (Xmpp.Jid jid, Dino.Entities.Account account, Dino.Entities.Conversation.Type? type = null);
		public Gee.List<Dino.Entities.Conversation> get_active_conversations (Dino.Entities.Account? account = null);
		public Dino.Entities.Conversation? get_conversation (Xmpp.Jid jid, Dino.Entities.Account account, Dino.Entities.Conversation.Type? type = null);
		public Dino.Entities.Conversation? get_conversation_by_id (int id);
		public Dino.Entities.Conversation? get_conversation_for_message (Dino.Entities.Message message);
		public Gee.List<Dino.Entities.Conversation> get_conversations (Xmpp.Jid jid, Dino.Entities.Account account);
		public static void start (Dino.StreamInteractor stream_interactor, Dino.Database db);
		public void start_conversation (Dino.Entities.Conversation conversation);
		public signal void conversation_activated (Dino.Entities.Conversation conversation);
		public signal void conversation_deactivated (Dino.Entities.Conversation conversation);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class CounterpartInteractionManager : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.CounterpartInteractionManager> IDENTITY;
		public Gee.List<Xmpp.Jid>? get_typing_jids (Dino.Entities.Conversation conversation);
		public static void start (Dino.StreamInteractor stream_interactor);
		public signal void received_marker (Dino.Entities.Account account, Xmpp.Jid jid, Dino.Entities.Message message, Dino.Entities.Message.Marked marker);
		public signal void received_message_displayed (Dino.Entities.Account account, Xmpp.Jid jid, Dino.Entities.Message message);
		public signal void received_message_received (Dino.Entities.Account account, Xmpp.Jid jid, Dino.Entities.Message message);
		public signal void received_state (Dino.Entities.Conversation conversation, string state);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class Database : Qlite.Database {
		public class AccountSettingsTable : Qlite.Table {
			public Qlite.Column<int> account_id;
			public Qlite.Column<int> id;
			public Qlite.Column<string> key;
			public Qlite.Column<string> value;
			public string? get_value (int account_id, string key);
		}
		public class AccountTable : Qlite.Table {
			public Qlite.Column<string> alias;
			public Qlite.Column<string> bare_jid;
			public Qlite.Column<bool> enabled;
			public Qlite.Column<int> id;
			public Qlite.Column<long> mam_earliest_synced;
			public Qlite.Column<string> password;
			public Qlite.Column<string> resourcepart;
			public Qlite.Column<string> roster_version;
		}
		public class AvatarTable : Qlite.Table {
			public Qlite.Column<int> account_id;
			public Qlite.Column<string> hash;
			public Qlite.Column<int> jid_id;
			public Qlite.Column<int> type_;
		}
		public class BodyMeta : Qlite.Table {
			public Qlite.Column<int> from_char;
			public Qlite.Column<int> id;
			public Qlite.Column<string> info;
			public Qlite.Column<string> info_type;
			public Qlite.Column<int> message_id;
			public Qlite.Column<int> to_char;
		}
		public class CallCounterpartTable : Qlite.Table {
			public Qlite.Column<int> call_id;
			public Qlite.Column<int> id;
			public Qlite.Column<int> jid_id;
			public Qlite.Column<string> resource;
		}
		public class CallTable : Qlite.Table {
			public Qlite.Column<int> account_id;
			public Qlite.Column<int> counterpart_id;
			public Qlite.Column<string> counterpart_resource;
			public Qlite.Column<bool> direction;
			public Qlite.Column<int> encryption;
			public Qlite.Column<long> end_time;
			public Qlite.Column<int> id;
			public Qlite.Column<long> local_time;
			public Qlite.Column<string> our_resource;
			public Qlite.Column<int> state;
			public Qlite.Column<long> time;
		}
		public class ContentItemTable : Qlite.Table {
			public Qlite.Column<int> content_type;
			public Qlite.Column<int> conversation_id;
			public Qlite.Column<int> foreign_id;
			public Qlite.Column<bool> hide;
			public Qlite.Column<int> id;
			public Qlite.Column<long> local_time;
			public Qlite.Column<long> time;
		}
		public class ConversationSettingsTable : Qlite.Table {
			public Qlite.Column<int> conversation_id;
			public Qlite.Column<int> id;
			public Qlite.Column<string> key;
			public Qlite.Column<string> value;
		}
		public class ConversationTable : Qlite.Table {
			public Qlite.Column<int> account_id;
			public Qlite.Column<bool> active;
			public Qlite.Column<long> active_last_changed;
			public Qlite.Column<int> encryption;
			public Qlite.Column<int> id;
			public Qlite.Column<int> jid_id;
			public Qlite.Column<long> last_active;
			public Qlite.Column<int> notification;
			public Qlite.Column<int> pinned;
			public Qlite.Column<int> read_up_to;
			public Qlite.Column<int> read_up_to_item;
			public Qlite.Column<string> resource;
			public Qlite.Column<int> send_marker;
			public Qlite.Column<int> send_typing;
			public Qlite.Column<int> type_;
		}
		public class EntityFeatureTable : Qlite.Table {
			public Qlite.Column<string> entity;
			public Qlite.Column<string> feature;
		}
		public class EntityIdentityTable : Qlite.Table {
			public Qlite.Column<string> category;
			public Qlite.Column<string> entity;
			public Qlite.Column<string> entity_name;
			public Qlite.Column<string> type;
		}
		public class EntityTable : Qlite.Table {
			public Qlite.Column<int> account_id;
			public Qlite.Column<string> caps_hash;
			public Qlite.Column<int> id;
			public Qlite.Column<int> jid_id;
			public Qlite.Column<long> last_seen;
			public Qlite.Column<string> resource;
		}
		public class FileHashesTable : Qlite.Table {
			public Qlite.Column<string> algo;
			public Qlite.Column<int> id;
			public Qlite.Column<string> value;
		}
		public class FileThumbnailsTable : Qlite.Table {
			public Qlite.Column<int> height;
			public Qlite.Column<int> id;
			public Qlite.Column<string> mime_type;
			public Qlite.Column<string> uri;
			public Qlite.Column<int> width;
		}
		public class FileTransferTable : Qlite.Table {
			public Qlite.Column<int> account_id;
			public Qlite.Column<int> counterpart_id;
			public Qlite.Column<string> counterpart_resource;
			public Qlite.Column<bool> direction;
			public Qlite.Column<int> encryption;
			public Qlite.Column<string> file_name;
			public Qlite.Column<string> file_sharing_id;
			public Qlite.Column<int> height;
			public Qlite.Column<int> id;
			public Qlite.Column<string> info;
			public Qlite.Column<long> length;
			public Qlite.Column<long> local_time;
			public Qlite.Column<string> mime_type;
			public Qlite.Column<long> modification_date;
			public Qlite.Column<string> our_resource;
			public Qlite.Column<string> path;
			public Qlite.Column<int> provider;
			public Qlite.Column<long> size;
			public Qlite.Column<int> state;
			public Qlite.Column<long> time;
			public Qlite.Column<int> width;
		}
		public class JidTable : Qlite.Table {
			public Qlite.Column<string> bare_jid;
			public Qlite.Column<int> id;
		}
		public class MamCatchupTable : Qlite.Table {
			public Qlite.Column<int> account_id;
			public Qlite.Column<bool> from_end;
			public Qlite.Column<string> from_id;
			public Qlite.Column<long> from_time;
			public Qlite.Column<int> id;
			public Qlite.Column<string> server_jid;
			public Qlite.Column<string> to_id;
			public Qlite.Column<long> to_time;
		}
		public class MessageCorrectionTable : Qlite.Table {
			public Qlite.Column<int> id;
			public Qlite.Column<int> message_id;
			public Qlite.Column<string> to_stanza_id;
		}
		public class MessageOccupantId : Qlite.Table {
			public Qlite.Column<int> id;
			public Qlite.Column<int> message_id;
			public Qlite.Column<int> occupant_id;
		}
		public class MessageTable : Qlite.Table {
			public Qlite.Column<int> account_id;
			public Qlite.Column<string> body;
			public Qlite.Column<int> counterpart_id;
			public Qlite.Column<string> counterpart_resource;
			public Qlite.Column<bool> direction;
			public Qlite.Column<int> encryption;
			public Qlite.Column<int> id;
			public Qlite.Column<long> local_time;
			public Qlite.Column<int> marked;
			public Qlite.Column<string> our_resource;
			public Qlite.Column<string> server_id;
			public Qlite.Column<string> stanza_id;
			public Qlite.Column<long> time;
			public Qlite.Column<int> type_;
		}
		public class OccupantIdTable : Qlite.Table {
			public Qlite.Column<int> account_id;
			public Qlite.Column<int> id;
			public Qlite.Column<int> jid_id;
			public Qlite.Column<string> last_nick;
			public Qlite.Column<string> occupant_id;
		}
		public class ReactionTable : Qlite.Table {
			public Qlite.Column<int> account_id;
			public Qlite.Column<int> content_item_id;
			public Qlite.Column<string> emojis;
			public Qlite.Column<int> id;
			public Qlite.Column<int> jid_id;
			public Qlite.Column<int> occupant_id;
			public Qlite.Column<long> time;
		}
		public class RealJidTable : Qlite.Table {
			public Qlite.Column<int> message_id;
			public Qlite.Column<string> real_jid;
		}
		public class ReplyTable : Qlite.Table {
			public Qlite.Column<int> id;
			public Qlite.Column<int> message_id;
			public Qlite.Column<int> quoted_content_item_id;
			public Qlite.Column<string?> quoted_message_from;
			public Qlite.Column<string?> quoted_message_stanza_id;
		}
		public class RosterTable : Qlite.Table {
			public Qlite.Column<int> account_id;
			public Qlite.Column<string> ask;
			public Qlite.Column<string> handle;
			public Qlite.Column<string> jid;
			public Qlite.Column<string> subscription;
		}
		public class SettingsTable : Qlite.Table {
			public Qlite.Column<int> id;
			public Qlite.Column<string> key;
			public Qlite.Column<string> value;
		}
		public class SourcesTable : Qlite.Table {
			public Qlite.Column<string> data;
			public Qlite.Column<int> file_transfer_id;
			public Qlite.Column<string> type;
		}
		public class UndecryptedTable : Qlite.Table {
			public Qlite.Column<string> data;
			public Qlite.Column<int> message_id;
			public Qlite.Column<int> type_;
		}
		public Gee.Map<int,Dino.Entities.Account> account_table_cache;
		public Gee.Map<int,Xmpp.Jid> jid_table_cache;
		public Gee.Map<Xmpp.Jid,int> jid_table_reverse;
		public Database (string fileName);
		public int add_content_item (Dino.Entities.Conversation conversation, GLib.DateTime time, GLib.DateTime local_time, int content_type, int foreign_id, bool hide);
		public Dino.Entities.Account? get_account_by_id (int id);
		public Gee.ArrayList<Dino.Entities.Account> get_accounts ();
		public Gee.ArrayList<Dino.Entities.Conversation> get_conversations (Dino.Entities.Account account);
		public Xmpp.Jid? get_jid_by_id (int id) throws Xmpp.InvalidJidError;
		public int get_jid_id (Xmpp.Jid jid_obj);
		public Dino.Entities.Message? get_message_by_id (int id);
		public Gee.List<Dino.Entities.Message> get_messages (Xmpp.Jid jid, Dino.Entities.Account account, Dino.Entities.Message.Type? type, int count, GLib.DateTime? before, GLib.DateTime? after, int id);
		public override void migrate (long oldVersion);
		public Dino.Database.AccountTable account { get; private set; }
		public Dino.Database.AccountSettingsTable account_settings { get; private set; }
		public Dino.Database.AvatarTable avatar { get; private set; }
		public Dino.Database.BodyMeta body_meta { get; private set; }
		public Dino.Database.CallTable call { get; private set; }
		public Dino.Database.CallCounterpartTable call_counterpart { get; private set; }
		public Dino.Database.ContentItemTable content_item { get; private set; }
		public Dino.Database.ConversationTable conversation { get; private set; }
		public Dino.Database.ConversationSettingsTable conversation_settings { get; private set; }
		public Dino.Database.EntityTable entity { get; private set; }
		public Dino.Database.EntityFeatureTable entity_feature { get; private set; }
		public Dino.Database.EntityIdentityTable entity_identity { get; private set; }
		public Dino.Database.FileHashesTable file_hashes { get; private set; }
		public Dino.Database.FileThumbnailsTable file_thumbnails { get; private set; }
		public Dino.Database.FileTransferTable file_transfer { get; private set; }
		public Dino.Database.JidTable jid { get; private set; }
		public Dino.Database.MamCatchupTable mam_catchup { get; private set; }
		public Dino.Database.MessageTable message { get; private set; }
		public Dino.Database.MessageCorrectionTable message_correction { get; private set; }
		public Dino.Database.MessageOccupantId message_occupant_id { get; private set; }
		public Dino.Database.OccupantIdTable occupantid { get; private set; }
		public Dino.Database.ReactionTable reaction { get; private set; }
		public Dino.Database.RealJidTable real_jid { get; private set; }
		public Dino.Database.ReplyTable reply { get; private set; }
		public Dino.Database.RosterTable roster { get; private set; }
		public Dino.Database.SettingsTable settings { get; private set; }
		public Dino.Database.SourcesTable sfs_sources { get; private set; }
	}
	[CCode (cheader_filename = "libdino.h")]
	public class EntityCapabilitiesStorage : Xmpp.Xep.EntityCapabilities.Storage, GLib.Object {
		public EntityCapabilitiesStorage (Dino.Database db);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class EntityInfo : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.EntityInfo> IDENTITY;
		public async Gee.Set<Xmpp.Xep.ServiceDiscovery.Identity>? get_identities (Dino.Entities.Account account, Xmpp.Jid jid);
		public async Xmpp.Xep.ServiceDiscovery.Identity? get_identity (Dino.Entities.Account account, Xmpp.Jid jid);
		public async bool has_feature (Dino.Entities.Account account, Xmpp.Jid jid, string feature);
		public bool has_feature_cached (Dino.Entities.Account account, Xmpp.Jid jid, string feature);
		public bool has_feature_offline (Dino.Entities.Account account, Xmpp.Jid jid, string feature);
		public static void start (Dino.StreamInteractor stream_interactor, Dino.Database db);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class FallbackBody : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.FallbackBody> IDENTITY;
		public static string get_quoted_fallback_body (Dino.ContentItem content_item);
		public static void start (Dino.StreamInteractor stream_interactor, Dino.Database db);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class FileItem : Dino.ContentItem {
		public Dino.Entities.Conversation conversation;
		public Dino.Entities.FileTransfer file_transfer;
		public const string TYPE;
		public FileItem (Dino.Entities.FileTransfer file_transfer, Dino.Entities.Conversation conversation, int id, Dino.Entities.Message? message = null);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class FileManager : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.FileManager> IDENTITY;
		public const int HTTP_PROVIDER_ID;
		public const int SFS_PROVIDER_ID;
		public void add_file_decryptor (Dino.FileDecryptor decryptor);
		public void add_file_encryptor (Dino.FileEncryptor encryptor);
		public void add_metadata_provider (Dino.FileMetadataProvider file_metadata_provider);
		public void add_provider (Dino.FileProvider file_provider);
		public void add_sender (Dino.FileSender file_sender);
		public Dino.Entities.FileTransfer create_file_transfer_from_provider_incoming (Dino.FileProvider file_provider, string info, Xmpp.Jid from, GLib.DateTime time, GLib.DateTime local_time, Dino.Entities.Conversation conversation, Dino.FileReceiveData receive_data, Dino.FileMeta file_meta);
		public async void download_file (Dino.Entities.FileTransfer file_transfer);
		public async Gee.HashMap<int,long> get_file_size_limits (Dino.Entities.Conversation conversation);
		public static string get_storage_dir ();
		public bool is_sender_trustworthy (Dino.Entities.FileTransfer file_transfer, Dino.Entities.Conversation conversation);
		public async bool is_upload_available (Dino.Entities.Conversation? conversation);
		public Dino.FileProvider? select_file_provider (Dino.Entities.FileTransfer file_transfer);
		public async void send_file (GLib.File file, Dino.Entities.Conversation conversation);
		public static void start (Dino.StreamInteractor stream_interactor, Dino.Database db);
		public Dino.StatelessFileSharing sfs { owned get; private set; }
		public signal void received_file (Dino.Entities.FileTransfer file_transfer, Dino.Entities.Conversation conversation);
		public signal void upload_available (Dino.Entities.Account account);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class FileMeta {
		public Dino.Entities.Encryption encryption;
		public string? file_name;
		public string? mime_type;
		public int64 size;
		public FileMeta ();
	}
	[CCode (cheader_filename = "libdino.h")]
	public class FileReceiveData {
		public FileReceiveData ();
	}
	[CCode (cheader_filename = "libdino.h")]
	public class FileSendData {
		public FileSendData ();
	}
	[CCode (cheader_filename = "libdino.h")]
	public class FileTransferStorage : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.FileTransferStorage> IDENTITY;
		public void add_file (Dino.Entities.FileTransfer file_transfer);
		public Dino.Entities.FileTransfer? get_file_by_id (int id, Dino.Entities.Conversation conversation);
		public Dino.Entities.FileTransfer? get_file_by_message_id (int id, Dino.Entities.Conversation conversation);
		public Dino.Entities.FileTransfer get_files_by_message_and_file_id (int message_id, string file_sharing_id, Dino.Entities.Conversation conversation);
		public static void start (Dino.StreamInteractor stream_interactor, Dino.Database db);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class HistorySync {
		public Gee.HashMap<Dino.Entities.Account,Gee.HashMap<Xmpp.Jid,GLib.Cancellable>> cancellables;
		public Gee.HashMap<Dino.Entities.Account,string> catchup_until_id;
		public Gee.HashMap<Dino.Entities.Account,GLib.DateTime> catchup_until_time;
		public Gee.HashMap<Dino.Entities.Account,Gee.HashMap<Xmpp.Jid,int>> current_catchup_id;
		public Gee.HashMap<string,int> hitted_range;
		public Gee.HashMap<Dino.Entities.Account,Gee.HashMap<string,GLib.DateTime>> mam_times;
		public WeakMap<Dino.Entities.Account,Xmpp.XmppStream> sync_streams;
		public HistorySync (Dino.Database db, Dino.StreamInteractor stream_interactor);
		public static void cleanup_db_ranges (Dino.Database db, Dino.Entities.Account account);
		public async void fetch_everything (Dino.Entities.Account account, Xmpp.Jid mam_server, GLib.Cancellable? cancellable = null, GLib.DateTime until_earliest_time = new GLib.DateTime.from_unix_utc (0));
		public async Qlite.Row? fetch_latest_page (Dino.Entities.Account account, Xmpp.Jid mam_server, Qlite.Row? latest_row, GLib.DateTime? until_earliest_time, GLib.Cancellable? cancellable = null);
		public void on_server_id_duplicate (Dino.Entities.Account account, Xmpp.MessageStanza message_stanza, Dino.Entities.Message message);
		public bool process (Dino.Entities.Account account, Xmpp.MessageStanza message_stanza);
		public void process_mam_message (Dino.Entities.Account account, Xmpp.MessageStanza message_stanza, Xmpp.MessageArchiveManagement.MessageFlag mam_flag);
		public void update_latest_db_range (Dino.Entities.Account account, Xmpp.MessageStanza message_stanza);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class HttpFileMeta : Dino.FileMeta {
		public Dino.Entities.Message message;
		public HttpFileMeta ();
	}
	[CCode (cheader_filename = "libdino.h")]
	public class HttpFileReceiveData : Dino.FileReceiveData {
		public HttpFileReceiveData ();
		public string url { get; set; }
	}
	[CCode (cheader_filename = "libdino.h")]
	public class HttpFileSendData : Dino.FileSendData {
		public HttpFileSendData ();
		public bool encrypt_message { get; set; }
		public Gee.HashMap<string,string> headers { get; set; }
		public string url_down { get; set; }
		public string url_up { get; set; }
	}
	[CCode (cheader_filename = "libdino.h")]
	public class ImageFileMetadataProvider : Dino.FileMetadataProvider, GLib.Object {
		public ImageFileMetadataProvider ();
	}
	[CCode (cheader_filename = "libdino.h")]
	public class JingleFileEncryptionHelperTransferOnly : Dino.JingleFileEncryptionHelper, GLib.Object {
		public JingleFileEncryptionHelperTransferOnly ();
	}
	[CCode (cheader_filename = "libdino.h")]
	public class JingleFileHelperRegistry {
		public JingleFileHelperRegistry ();
		public void add_encryption_helper (Dino.Entities.Encryption encryption, Dino.JingleFileEncryptionHelper helper);
		public Dino.JingleFileEncryptionHelper? get_encryption_helper (Dino.Entities.Encryption encryption);
		public static Dino.JingleFileHelperRegistry instance { get; }
	}
	[CCode (cheader_filename = "libdino.h")]
	public class JingleFileProvider : Dino.FileProvider, GLib.Object {
		public JingleFileProvider (Dino.StreamInteractor stream_interactor);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class JingleFileSender : Dino.FileSender, GLib.Object {
		public JingleFileSender (Dino.StreamInteractor stream_interactor);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class LimitInputStream : GLib.InputStream, GLib.PollableInputStream {
		public LimitInputStream (GLib.InputStream inner, int64 max_bytes);
		public override bool close (GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public override async bool close_async (int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public override ssize_t read (uint8[] buffer, GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public override async ssize_t read_async (uint8[]? buffer, int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public int64 max_bytes { get; private set; }
		public int64 remaining_bytes { get; }
		public int64 retrieved_bytes { get; private set; }
	}
	[CCode (cheader_filename = "libdino.h")]
	public class MessageCorrection : Dino.StreamInteractionModule, Dino.MessageListener {
		public static Dino.ModuleIdentity<Dino.MessageCorrection> IDENTITY;
		public string[] after_actions_const;
		public Gee.HashMap<Dino.Entities.Conversation,Gee.List<Dino.ContentItem>> unmatched_corrections;
		public MessageCorrection (Dino.StreamInteractor stream_interactor, Dino.Database db);
		public int get_latest_correction_message_id (Dino.Entities.Conversation conversation, string stanza_ref_id);
		public bool is_own_correction_allowed (Dino.Entities.Conversation conversation, Dino.Entities.Message message);
		public void on_received_correction (Dino.Entities.Conversation conversation, int message_id);
		public override async bool run (Dino.Entities.Message message, Xmpp.MessageStanza stanza, Dino.Entities.Conversation conversation);
		public void set_correction (Dino.Entities.Conversation conversation, Dino.Entities.Message message, Dino.Entities.Message old_message);
		public static void start (Dino.StreamInteractor stream_interactor, Dino.Database db);
		public override string action_group { get; }
		public override string[] after_actions { get; }
		public signal void received_correction (Dino.ContentItem content_item);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class MessageItem : Dino.ContentItem {
		public Dino.Entities.Conversation conversation;
		public Dino.Entities.Message message;
		public const string TYPE;
		public MessageItem (Dino.Entities.Message message, Dino.Entities.Conversation conversation, int id);
	}
	[CCode (cheader_filename = "libdino.h")]
	public abstract class MessageListener : Xmpp.OrderedListener {
		protected MessageListener ();
		public abstract async bool run (Dino.Entities.Message message, Xmpp.MessageStanza stanza, Dino.Entities.Conversation conversation);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class MessageListenerHolder : Xmpp.ListenerHolder {
		public MessageListenerHolder ();
		public async bool run (Dino.Entities.Message message, Xmpp.MessageStanza stanza, Dino.Entities.Conversation conversation);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class MessageProcessor : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.MessageProcessor> IDENTITY;
		public Dino.HistorySync history_sync;
		public Dino.MessageListenerHolder received_pipeline;
		public Dino.Entities.Message create_out_message (string? text, Dino.Entities.Conversation conversation);
		public async Dino.Entities.Message parse_message_stanza (Dino.Entities.Account account, Xmpp.MessageStanza message);
		public async void run_pipeline_announce (Dino.Entities.Account account, Xmpp.MessageStanza message_stanza);
		public void send_unsent_muc_messages (Dino.Entities.Account account, Xmpp.Jid muc_jid);
		public void send_xmpp_message (Dino.Entities.Message message, Dino.Entities.Conversation conversation, bool delayed = false);
		public static void start (Dino.StreamInteractor stream_interactor, Dino.Database db);
		public signal void build_message_stanza (Dino.Entities.Message message, Xmpp.MessageStanza message_stanza, Dino.Entities.Conversation conversation);
		public signal void history_synced (Dino.Entities.Account account);
		public signal void message_received (Dino.Entities.Message message, Dino.Entities.Conversation conversation);
		public signal void message_sent (Dino.Entities.Message message, Dino.Entities.Conversation conversation);
		public signal void message_sent_or_received (Dino.Entities.Message message, Dino.Entities.Conversation conversation);
		public signal void pre_message_send (Dino.Entities.Message message, Xmpp.MessageStanza message_stanza, Dino.Entities.Conversation conversation);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class MessageStorage : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.MessageStorage> IDENTITY;
		public void add_message (Dino.Entities.Message message, Dino.Entities.Conversation conversation);
		public Dino.Entities.Message? get_last_message (Dino.Entities.Conversation conversation);
		public Dino.Entities.Message? get_message_by_id (int id, Dino.Entities.Conversation conversation);
		public Dino.Entities.Message? get_message_by_referencing_id (string id, Dino.Entities.Conversation conversation);
		public Dino.Entities.Message? get_message_by_server_id (string server_id, Dino.Entities.Conversation conversation);
		public Dino.Entities.Message? get_message_by_stanza_id (string stanza_id, Dino.Entities.Conversation conversation);
		public Gee.List<Dino.Entities.Message> get_messages (Dino.Entities.Conversation conversation, int count = 50);
		public Gee.List<Dino.MessageItem> get_messages_after_message (Dino.Entities.Conversation? conversation, GLib.DateTime after, int id, int count = 20);
		public Gee.List<Dino.MessageItem> get_messages_before_message (Dino.Entities.Conversation? conversation, GLib.DateTime before, int id, int count = 20);
		public static string? get_reference_id (Dino.Entities.Message message);
		public static void start (Dino.StreamInteractor stream_interactor, Dino.Database db);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class ModuleIdentity<T> : GLib.Object {
		public ModuleIdentity (string id);
		public T cast (Dino.StreamInteractionModule module);
		public bool matches (Dino.StreamInteractionModule module);
		public string id { get; private set; }
	}
	[CCode (cheader_filename = "libdino.h")]
	public class ModuleManager {
		public ModuleManager ();
		public T get_module<T> (Dino.Entities.Account account, Xmpp.ModuleIdentity<T> identity);
		public Gee.ArrayList<Xmpp.XmppStreamModule> get_modules (Dino.Entities.Account account);
		public void initialize (Dino.Entities.Account account);
		public signal void initialize_account_modules (Dino.Entities.Account account, Gee.ArrayList<Xmpp.XmppStreamModule> modules);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class MucManager : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.MucManager> IDENTITY;
		public Gee.HashMap<Dino.Entities.Account,Xmpp.Jid> default_muc_server;
		public void add_bookmark (Dino.Entities.Account account, Xmpp.Conference conference);
		public void change_affiliation (Dino.Entities.Account account, Xmpp.Jid jid, string nick, string role);
		public async void change_nick (Dino.Entities.Conversation conversation, string new_nick);
		public void change_role (Dino.Entities.Account account, Xmpp.Jid jid, string nick, string role);
		public void change_subject (Dino.Entities.Account account, Xmpp.Jid jid, string subject);
		public Xmpp.Xep.Muc.Affiliation? get_affiliation (Xmpp.Jid muc_jid, Xmpp.Jid jid, Dino.Entities.Account account);
		public async Gee.Set<Xmpp.Conference>? get_bookmarks (Dino.Entities.Account account);
		public async Xmpp.Xep.DataForms.DataForm? get_config_form (Dino.Entities.Account account, Xmpp.Jid jid);
		public string? get_groupchat_subject (Xmpp.Jid jid, Dino.Entities.Account account);
		public Xmpp.Jid? get_occupant_jid (Dino.Entities.Account account, Xmpp.Jid room, Xmpp.Jid occupant_real_jid);
		public Gee.List<Xmpp.Jid>? get_occupants (Xmpp.Jid jid, Dino.Entities.Account account);
		public Gee.List<Xmpp.Jid>? get_offline_members (Xmpp.Jid jid, Dino.Entities.Account account);
		public Gee.List<Xmpp.Jid>? get_other_occupants (Xmpp.Jid jid, Dino.Entities.Account account);
		public Gee.List<Xmpp.Jid>? get_other_offline_members (Xmpp.Jid jid, Dino.Entities.Account account);
		public Xmpp.Jid? get_own_jid (Xmpp.Jid muc_jid, Dino.Entities.Account account);
		public string? get_own_occupant_id (Dino.Entities.Account account, Xmpp.Jid muc_jid);
		public Xmpp.Jid? get_real_jid (Xmpp.Jid jid, Dino.Entities.Account account);
		public Xmpp.Xep.Muc.Role? get_role (Xmpp.Jid jid, Dino.Entities.Account account);
		public string? get_room_name (Dino.Entities.Account account, Xmpp.Jid jid);
		public void invite (Dino.Entities.Account account, Xmpp.Jid muc, Xmpp.Jid invitee);
		public bool is_groupchat (Xmpp.Jid jid, Dino.Entities.Account account);
		public bool is_groupchat_occupant (Xmpp.Jid jid, Dino.Entities.Account account);
		public bool is_joined (Xmpp.Jid jid, Dino.Entities.Account account);
		public bool is_moderated_room (Dino.Entities.Account account, Xmpp.Jid jid);
		public bool is_own_muc_jid (Xmpp.Jid full_jid, Dino.Entities.Account account);
		public bool is_private_room (Dino.Entities.Account account, Xmpp.Jid jid);
		public bool is_public_room (Dino.Entities.Account account, Xmpp.Jid jid);
		public async Xmpp.Xep.Muc.JoinResult? join (Dino.Entities.Account account, Xmpp.Jid jid, string? nick, string? password, bool already_autojoin = false, GLib.Cancellable? cancellable = null);
		public void kick (Dino.Entities.Account account, Xmpp.Jid jid, string nick);
		public bool kick_possible (Dino.Entities.Account account, Xmpp.Jid occupant);
		public bool might_be_groupchat (Xmpp.Jid jid, Dino.Entities.Account account);
		public void part (Dino.Entities.Account account, Xmpp.Jid jid);
		public void remove_bookmark (Dino.Entities.Account account, Xmpp.Conference conference);
		public void request_voice (Dino.Entities.Account account, Xmpp.Jid jid);
		public async void set_config_form (Dino.Entities.Account account, Xmpp.Jid jid, Xmpp.Xep.DataForms.DataForm data_form);
		public static void start (Dino.StreamInteractor stream_interactor);
		public signal void bookmarks_updated (Dino.Entities.Account account, Gee.Set<Xmpp.Conference> conferences);
		public signal void conference_added (Dino.Entities.Account account, Xmpp.Conference conference);
		public signal void conference_removed (Dino.Entities.Account account, Xmpp.Jid jid);
		public signal void invite_received (Dino.Entities.Account account, Xmpp.Jid room_jid, Xmpp.Jid from_jid, string? password, string? reason);
		public signal void left (Dino.Entities.Account account, Xmpp.Jid jid);
		public signal void private_room_occupant_updated (Dino.Entities.Account account, Xmpp.Jid room, Xmpp.Jid occupant);
		public signal void received_occupant_role (Dino.Entities.Account account, Xmpp.Jid jid, Xmpp.Xep.Muc.Role? role);
		public signal void room_info_updated (Dino.Entities.Account account, Xmpp.Jid muc_jid);
		public signal void subject_set (Dino.Entities.Account account, Xmpp.Jid jid, string? subject);
		public signal void voice_request_received (Dino.Entities.Account account, Xmpp.Jid room_jid, Xmpp.Jid from_jid, string nick);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class NotificationEvents : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.NotificationEvents> IDENTITY;
		public NotificationEvents (Dino.StreamInteractor stream_interactor);
		public async void register_notification_provider (Dino.NotificationProvider notification_provider);
		public static void start (Dino.StreamInteractor stream_interactor);
		public signal void notify_content_item (Dino.ContentItem content_item, Dino.Entities.Conversation conversation);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class OccupantIdStore : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.OccupantIdStore> IDENTITY;
		public int cache_occupant_id (Dino.Entities.Account account, string occupant_id, Xmpp.Jid occupant_jid);
		public int get_occupant_db_id (Dino.Entities.Account account, string occupant_id, Xmpp.Jid muc_jid);
		public static void start (Dino.StreamInteractor stream_interactor, Dino.Database db);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class PeerContentInfo {
		public PeerContentInfo ();
		public ulong? bytes_received { get; set; }
		public ulong? bytes_sent { get; set; }
		public uint32 clockrate { get; set; }
		public string? codec { get; set; }
		public bool rtcp_ready { get; set; }
		public bool rtp_ready { get; set; }
		public uint target_receive_bytes { get; set; }
		public uint target_send_bytes { get; set; }
	}
	[CCode (cheader_filename = "libdino.h")]
	public class PeerInfo {
		public Dino.PeerContentInfo? audio;
		public Dino.PeerContentInfo? video;
		public PeerInfo ();
	}
	[CCode (cheader_filename = "libdino.h")]
	public class PeerState : GLib.Object {
		public Xmpp.Xep.Jingle.Content? audio_content;
		public Xmpp.Xep.JingleRtp.Parameters? audio_content_parameter;
		public Xmpp.Xep.Jingle.ContentEncryption? audio_encryption;
		public Gee.HashMap<string,Xmpp.Xep.Jingle.ContentEncryption>? audio_encryptions;
		public Dino.Entities.Call call;
		public Dino.CallState call_state;
		public Dino.Calls calls;
		public bool counterpart_sends_video;
		public bool encryption_keys_same;
		public bool first_peer;
		public string internal_id;
		public Xmpp.Jid jid;
		public Xmpp.Xep.Jingle.Session session;
		public string sid;
		public Dino.StreamInteractor stream_interactor;
		public Xmpp.Xep.Jingle.Content? video_content;
		public Xmpp.Xep.JingleRtp.Parameters? video_content_parameter;
		public Xmpp.Xep.Jingle.ContentEncryption? video_encryption;
		public Gee.HashMap<string,Xmpp.Xep.Jingle.ContentEncryption>? video_encryptions;
		public bool waiting_for_inbound_muji_connection;
		public PeerState (Xmpp.Jid jid, Dino.Entities.Call call, Dino.CallState call_state, Dino.StreamInteractor stream_interactor);
		public void accept ();
		public async void call_resource (Xmpp.Jid full_jid);
		public void end (string terminate_reason, string? reason_text = null);
		public Xmpp.Xep.JingleRtp.Stream? get_audio_stream ();
		public Dino.PeerInfo get_info ();
		public Xmpp.Xep.JingleRtp.Stream? get_video_stream ();
		public async void initiate_call (Xmpp.Jid counterpart);
		public void reject ();
		public Xmpp.Xep.Muji.GroupCall? group_call { get; set; }
		public bool we_should_send_audio { get; set; }
		public bool we_should_send_video { get; set; }
		public signal void connection_ready ();
		public signal void counterpart_sends_video_updated (bool mute);
		public signal void encryption_updated (Xmpp.Xep.Jingle.ContentEncryption? audio_encryption, Xmpp.Xep.Jingle.ContentEncryption? video_encryption);
		public signal void info_received (Xmpp.Xep.JingleRtp.CallSessionInfo session_info);
		public signal void session_terminated (bool we_terminated, string? reason_name, string? reason_text);
		public signal void stream_created (string media);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class PresenceManager : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.PresenceManager> IDENTITY;
		public void approve_subscription (Dino.Entities.Account account, Xmpp.Jid jid);
		public void cancel_subscription (Dino.Entities.Account account, Xmpp.Jid jid);
		public void deny_subscription (Dino.Entities.Account account, Xmpp.Jid jid);
		public bool exists_subscription_request (Dino.Entities.Account account, Xmpp.Jid jid);
		public Gee.List<Xmpp.Jid>? get_full_jids (Xmpp.Jid jid, Dino.Entities.Account account);
		public string? get_last_show (Xmpp.Jid jid, Dino.Entities.Account account);
		public void request_subscription (Dino.Entities.Account account, Xmpp.Jid jid);
		public static void start (Dino.StreamInteractor stream_interactor);
		public signal void received_offline_presence (Xmpp.Jid jid, Dino.Entities.Account account);
		public signal void received_subscription_approval (Xmpp.Jid jid, Dino.Entities.Account account);
		public signal void received_subscription_request (Xmpp.Jid jid, Dino.Entities.Account account);
		public signal void show_received (Xmpp.Jid jid, Dino.Entities.Account account);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class ReactionInfo {
		public ReactionInfo ();
		public Dino.Entities.Conversation conversation { get; set; }
		public Xmpp.Jid from_jid { get; set; }
		public Gee.List<string> reactions { get; set; }
		public GLib.DateTime received_time { get; set; }
		public Xmpp.MessageStanza stanza { get; set; }
	}
	[CCode (cheader_filename = "libdino.h")]
	public class ReactionUsers {
		public ReactionUsers ();
		public Gee.List<Xmpp.Jid> jids { get; set; }
		public string reaction { get; set; }
	}
	[CCode (cheader_filename = "libdino.h")]
	public class Reactions : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.Reactions> IDENTITY;
		public void add_reaction (Dino.Entities.Conversation conversation, Dino.ContentItem content_item, string reaction);
		public bool conversation_supports_reactions (Dino.Entities.Conversation conversation);
		public Gee.List<Dino.ReactionUsers> get_chat_message_reactions (Dino.Entities.Account account, Dino.ContentItem content_item);
		public Gee.List<Dino.ReactionUsers> get_item_reactions (Dino.Entities.Conversation conversation, Dino.ContentItem content_item);
		public Gee.List<Dino.ReactionUsers> get_muc_message_reactions (Dino.Entities.Account account, Dino.ContentItem content_item);
		public void remove_reaction (Dino.Entities.Conversation conversation, Dino.ContentItem content_item, string reaction);
		public static void start (Dino.StreamInteractor stream_interactor, Dino.Database database);
		public signal void reaction_added (Dino.Entities.Account account, int content_item_id, Xmpp.Jid jid, string reaction);
		public signal void reaction_removed (Dino.Entities.Account account, int content_item_id, Xmpp.Jid jid, string reaction);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class Register : Dino.StreamInteractionModule, GLib.Object {
		public class RegistrationFormReturn {
			public RegistrationFormReturn ();
			public GLib.TlsCertificateFlags? error_flags { get; set; }
			public Xmpp.Xep.InBandRegistration.Form? form { get; set; }
		}
		public class ServerAvailabilityReturn {
			public ServerAvailabilityReturn ();
			public bool available { get; set; }
			public GLib.TlsCertificateFlags? error_flags { get; set; }
		}
		public static Dino.ModuleIdentity<Dino.Register> IDENTITY;
		public async Dino.ConnectionManager.ConnectionError.Source? add_check_account (Dino.Entities.Account account);
		public async string? change_password (Dino.Entities.Account account, string new_pw);
		public static async Dino.Register.ServerAvailabilityReturn check_server_availability (Xmpp.Jid jid);
		public static async Dino.Register.RegistrationFormReturn get_registration_form (Xmpp.Jid jid);
		public static void start (Dino.StreamInteractor stream_interactor, Dino.Database db);
		public static async string? submit_form (Xmpp.Jid jid, Xmpp.Xep.InBandRegistration.Form form);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class Replies : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.Replies> IDENTITY;
		public Dino.ContentItem? get_quoted_content_item (Dino.Entities.Message message, Dino.Entities.Conversation conversation);
		public static void start (Dino.StreamInteractor stream_interactor, Dino.Database db);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class RosterManager : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.RosterManager> IDENTITY;
		public RosterManager (Dino.StreamInteractor stream_interactor, Dino.Database db);
		public void add_jid (Dino.Entities.Account account, Xmpp.Jid jid, string? handle);
		public Gee.Collection<Xmpp.Roster.Item> get_roster (Dino.Entities.Account account);
		public Xmpp.Roster.Item? get_roster_item (Dino.Entities.Account account, Xmpp.Jid jid);
		public void remove_jid (Dino.Entities.Account account, Xmpp.Jid jid);
		public void set_jid_handle (Dino.Entities.Account account, Xmpp.Jid jid, string? handle);
		public static void start (Dino.StreamInteractor stream_interactor, Dino.Database db);
		public signal void mutual_subscription (Dino.Entities.Account account, Xmpp.Jid jid);
		public signal void removed_roster_item (Dino.Entities.Account account, Xmpp.Jid jid, Xmpp.Roster.Item roster_item);
		public signal void updated_roster_item (Dino.Entities.Account account, Xmpp.Jid jid, Xmpp.Roster.Item roster_item);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class RosterStoreImpl : Xmpp.Roster.Storage, GLib.Object {
		public RosterStoreImpl (Dino.Entities.Account account, Dino.Database db);
		public Xmpp.Roster.Item? get_item (Xmpp.Jid jid);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class SearchPathGenerator {
		public SearchPathGenerator (string? exec_path);
		public string get_locale_path (string gettext_package, string locale_install_dir);
		public string[] get_plugin_paths ();
		public string? exec_path { get; private set; }
	}
	[CCode (cheader_filename = "libdino.h")]
	public class SearchProcessor : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.SearchProcessor> IDENTITY;
		public SearchProcessor (Dino.StreamInteractor stream_interactor, Dino.Database db);
		public int count_match_messages (string query);
		public Gee.List<Dino.MessageItem> match_messages (string query, int offset = -1);
		public static void start (Dino.StreamInteractor stream_interactor, Dino.Database db);
		public Gee.List<Dino.SearchSuggestion> suggest_auto_complete (string query, int cursor_position, int limit = 5);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class SearchSuggestion : GLib.Object {
		public SearchSuggestion (Dino.Entities.Conversation conversation, Xmpp.Jid? jid, string completion, int start_index, int end_index);
		public Dino.Entities.Account account { get; }
		public string completion { get; private set; }
		public Dino.Entities.Conversation conversation { get; private set; }
		public int end_index { get; private set; }
		public Xmpp.Jid? jid { get; private set; }
		public long order { get; set; }
		public int start_index { get; private set; }
	}
	[CCode (cheader_filename = "libdino.h")]
	public class StatelessFileSharing : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.StatelessFileSharing> IDENTITY;
		public const int SFS_PROVIDER_ID;
		public async void create_file_transfer (Dino.Entities.Conversation conversation, Dino.Entities.Message message, string? file_sharing_id, Xmpp.Xep.FileMetadataElement.FileMetadata metadata, Gee.List<Xmpp.Xep.StatelessFileSharing.Source>? sources);
		public void on_received_sources (Xmpp.Jid from, Dino.Entities.Conversation conversation, string attach_to_message_id, string? attach_to_file_id, Gee.List<Xmpp.Xep.StatelessFileSharing.Source> sources);
		public static void start (Dino.StreamInteractor stream_interactor, Dino.Database db);
		public Dino.Database db { owned get; private set; }
		public Dino.FileManager file_manager { owned get; private set; }
		public Dino.StreamInteractor stream_interactor { owned get; private set; }
	}
	[CCode (cheader_filename = "libdino.h")]
	public class StreamInteractor : GLib.Object {
		public Dino.ConnectionManager connection_manager;
		public Dino.ModuleManager module_manager;
		public StreamInteractor (Dino.Database db);
		public void add_module (Dino.StreamInteractionModule module);
		public void connect_account (Dino.Entities.Account account);
		public async void disconnect_account (Dino.Entities.Account account);
		public new T @get<T> ();
		public Gee.ArrayList<Dino.Entities.Account> get_accounts ();
		public T get_module<T> (Dino.ModuleIdentity<T>? identity);
		public Xmpp.XmppStream? get_stream (Dino.Entities.Account account);
		public signal void account_added (Dino.Entities.Account account);
		public signal void account_removed (Dino.Entities.Account account);
		public signal void stream_attached_modules (Dino.Entities.Account account, Xmpp.XmppStream stream);
		public signal void stream_negotiated (Dino.Entities.Account account, Xmpp.XmppStream stream);
		public signal void stream_resumed (Dino.Entities.Account account, Xmpp.XmppStream stream);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class Util {
		public Util ();
		public static Dino.Entities.Conversation.Type get_conversation_type_for_message (Dino.Entities.Message message);
		public static Dino.Entities.Message.Type get_message_type_for_conversation (Dino.Entities.Conversation conversation);
		public static bool is_pixbuf_supported_mime_type (string mime_type);
	}
	[CCode (cheader_filename = "libdino.h")]
	public class WeakTimeout {
		[CCode (has_target = false, instance_pos = 0)]
		public delegate bool SourceFunc<T> (T object);
		[CCode (has_target = false, instance_pos = 0)]
		public delegate void SourceOnceFunc<T> (T object);
		public WeakTimeout ();
		public static uint add<T> (uint interval, T object, owned Dino.WeakTimeout.SourceFunc<T> function, int priority = GLib.Priority.DEFAULT);
		public static uint add_once<T> (uint interval, T object, owned Dino.WeakTimeout.SourceOnceFunc<T> function, int priority = GLib.Priority.DEFAULT);
		public static uint add_seconds<T> (uint interval, T object, owned Dino.WeakTimeout.SourceFunc<T> function, int priority = GLib.Priority.DEFAULT);
		public static uint add_seconds_once<T> (uint interval, T object, owned Dino.WeakTimeout.SourceOnceFunc<T> function, int priority = GLib.Priority.DEFAULT);
	}
	[CCode (cheader_filename = "libdino.h")]
	public interface Application : GLib.Application {
		protected void add_connection (Dino.Entities.Account account);
		public void create_actions ();
		public static unowned Dino.Application get_default ();
		public static string get_storage_dir ();
		public abstract void handle_uri (string jid, string query, Gee.Map<string,string> options);
		public void init () throws GLib.Error;
		protected void remove_connection (Dino.Entities.Account account);
		public abstract Dino.Database db { get; set; }
		public abstract Dino.Plugins.Registry plugin_registry { get; set; }
		public abstract Dino.SearchPathGenerator? search_path_generator { get; set; }
		public abstract Dino.Entities.Settings settings { get; set; }
		public abstract Dino.StreamInteractor stream_interactor { get; set; }
	}
	[CCode (cheader_filename = "libdino.h")]
	public interface ContentItemCollection : GLib.Object {
		public abstract void insert_item (Dino.ContentItem item);
		public abstract void remove_item (Dino.ContentItem item);
	}
	[CCode (cheader_filename = "libdino.h")]
	[DBus (name = "org.freedesktop.Notifications")]
	public interface DBusNotifications : GLib.Object {
		public abstract async void close_notification (uint id) throws GLib.DBusError, GLib.IOError;
		public abstract async void get_capabilities (out string[] capabilities) throws GLib.Error;
		public abstract async void get_server_information (out string name, out string vendor, out string version, out string spec_version) throws GLib.DBusError, GLib.IOError;
		public abstract async uint32 notify (string app_name, uint32 replaces_id, string app_icon, string summary, string body, string[] actions, GLib.HashTable<string,GLib.Variant> hints, int32 expire_timeout) throws GLib.DBusError, GLib.IOError;
		public signal void action_invoked (uint32 key, string action_key);
		public signal void notification_closed (uint32 id, uint32 reason);
	}
	[CCode (cheader_filename = "libdino.h")]
	public interface FileDecryptor : GLib.Object {
		public abstract bool can_decrypt_file (Dino.Entities.Conversation conversation, Dino.Entities.FileTransfer file_transfer, Dino.FileReceiveData receive_data);
		public abstract async GLib.InputStream decrypt_file (GLib.InputStream encrypted_stream, Dino.Entities.Conversation conversation, Dino.Entities.FileTransfer file_transfer, Dino.FileReceiveData receive_data) throws Dino.FileReceiveError;
		public abstract Dino.Entities.Encryption get_encryption ();
		public abstract Dino.FileMeta prepare_download_file (Dino.Entities.Conversation conversation, Dino.Entities.FileTransfer file_transfer, Dino.FileReceiveData receive_data, Dino.FileMeta file_meta);
		public abstract Dino.FileReceiveData prepare_get_meta_info (Dino.Entities.Conversation conversation, Dino.Entities.FileTransfer file_transfer, Dino.FileReceiveData receive_data);
	}
	[CCode (cheader_filename = "libdino.h")]
	public interface FileEncryptor : GLib.Object {
		public abstract bool can_encrypt_file (Dino.Entities.Conversation conversation, Dino.Entities.FileTransfer file_transfer);
		public abstract Dino.FileMeta encrypt_file (Dino.Entities.Conversation conversation, Dino.Entities.FileTransfer file_transfer) throws Dino.FileSendError;
		public abstract Dino.FileSendData? preprocess_send_file (Dino.Entities.Conversation conversation, Dino.Entities.FileTransfer file_transfer, Dino.FileSendData file_send_data, Dino.FileMeta file_meta) throws Dino.FileSendError;
	}
	[CCode (cheader_filename = "libdino.h")]
	public interface FileMetadataProvider : GLib.Object {
		public abstract async void fill_metadata (GLib.File file, Xmpp.Xep.FileMetadataElement.FileMetadata metadata);
		public abstract bool supports_file (GLib.File file);
	}
	[CCode (cheader_filename = "libdino.h")]
	public interface FileProvider : GLib.Object {
		public abstract async GLib.InputStream download (Dino.Entities.FileTransfer file_transfer, Dino.FileReceiveData receive_data, Dino.FileMeta file_meta) throws GLib.IOError;
		public abstract Dino.Entities.Encryption get_encryption (Dino.Entities.FileTransfer file_transfer, Dino.FileReceiveData receive_data, Dino.FileMeta file_meta);
		public abstract Dino.FileMeta get_file_meta (Dino.Entities.FileTransfer file_transfer) throws Dino.FileReceiveError;
		public abstract Dino.FileReceiveData? get_file_receive_data (Dino.Entities.FileTransfer file_transfer);
		public abstract int get_id ();
		public abstract async Dino.FileMeta get_meta_info (Dino.Entities.FileTransfer file_transfer, Dino.FileReceiveData receive_data, Dino.FileMeta file_meta) throws Dino.FileReceiveError;
		public signal void file_incoming (string info, Xmpp.Jid from, GLib.DateTime time, GLib.DateTime local_time, Dino.Entities.Conversation conversation, Dino.FileReceiveData receive_data, Dino.FileMeta file_meta);
	}
	[CCode (cheader_filename = "libdino.h")]
	public interface FileSender : GLib.Object {
		public abstract async bool can_encrypt (Dino.Entities.Conversation conversation, Dino.Entities.FileTransfer file_transfer);
		public abstract async bool can_send (Dino.Entities.Conversation conversation, Dino.Entities.FileTransfer file_transfer);
		public abstract async long get_file_size_limit (Dino.Entities.Conversation conversation);
		public abstract int get_id ();
		public abstract float get_priority ();
		public abstract async bool is_upload_available (Dino.Entities.Conversation conversation);
		public abstract async Dino.FileSendData? prepare_send_file (Dino.Entities.Conversation conversation, Dino.Entities.FileTransfer file_transfer, Dino.FileMeta file_meta) throws Dino.FileSendError;
		public abstract async void send_file (Dino.Entities.Conversation conversation, Dino.Entities.FileTransfer file_transfer, Dino.FileSendData file_send_data, Dino.FileMeta file_meta) throws Dino.FileSendError;
		public signal void upload_available (Dino.Entities.Account account);
	}
	[CCode (cheader_filename = "libdino.h")]
	public interface JingleFileEncryptionHelper : GLib.Object {
		public abstract async bool can_encrypt (Dino.Entities.Conversation conversation, Dino.Entities.FileTransfer file_transfer, Xmpp.Jid? full_jid = null);
		public abstract bool can_transfer (Dino.Entities.Conversation conversation);
		public abstract Dino.Entities.Encryption get_encryption (Xmpp.Xep.JingleFileTransfer.FileTransfer jingle_transfer);
		public abstract string? get_precondition_name (Dino.Entities.Conversation conversation, Dino.Entities.FileTransfer file_transfer);
		public abstract GLib.Object? get_precondition_options (Dino.Entities.Conversation conversation, Dino.Entities.FileTransfer file_transfer);
	}
	[CCode (cheader_filename = "libdino.h")]
	[DBus (name = "org.freedesktop.login1.Manager")]
	public interface Login1Manager : GLib.Object {
		public signal void PrepareForSleep (bool suspend);
	}
	[CCode (cheader_filename = "libdino.h")]
	public interface NotificationProvider : GLib.Object {
		public abstract double get_priority ();
		public abstract async void notify_call (Dino.Entities.Call call, Dino.Entities.Conversation conversation, bool video, bool multiparty, string conversation_display_name);
		public abstract async void notify_connection_error (Dino.Entities.Account account, Dino.ConnectionManager.ConnectionError error);
		public abstract async void notify_file (Dino.Entities.FileTransfer file_transfer, Dino.Entities.Conversation conversation, bool is_image, string conversation_display_name, string? participant_display_name);
		public abstract async void notify_message (Dino.Entities.Message message, Dino.Entities.Conversation conversation, string conversation_display_name, string? participant_display_name);
		public abstract async void notify_muc_invite (Dino.Entities.Account account, Xmpp.Jid room_jid, Xmpp.Jid from_jid, string inviter_display_name);
		public abstract async void notify_subscription_request (Dino.Entities.Conversation conversation);
		public abstract async void notify_voice_request (Dino.Entities.Conversation conversation, Xmpp.Jid from_jid);
		public abstract async void retract_call_notification (Dino.Entities.Call call, Dino.Entities.Conversation conversation);
		public abstract async void retract_content_item_notifications ();
		public abstract async void retract_conversation_notifications (Dino.Entities.Conversation conversation);
	}
	[CCode (cheader_filename = "libdino.h")]
	public interface StreamInteractionModule : GLib.Object {
		public abstract string id { get; }
	}
	[CCode (cheader_filename = "libdino.h")]
	[DBus (name = "org.freedesktop.UPower")]
	public interface UPower : GLib.Object {
		public signal void Resuming ();
		public signal void Sleeping ();
	}
	[CCode (cheader_filename = "libdino.h")]
	public errordomain FileReceiveError {
		GET_METADATA_FAILED,
		DECRYPTION_FAILED
	}
	[CCode (cheader_filename = "libdino.h")]
	public errordomain FileSendError {
		ENCRYPTION_FAILED,
		UPLOAD_FAILED,
		SAVE_FAILED
	}
	[CCode (cheader_filename = "libdino.h")]
	public const string VERSION;
	[CCode (cheader_filename = "dino_i18n.h", cname = "dino_gettext")]
	public static unowned string _ (string s);
	[CCode (cheader_filename = "libdino.h")]
	public static async Gee.HashMap<GLib.ChecksumType,string> compute_file_hashes (GLib.File file, Gee.List<GLib.ChecksumType> checksum_types);
	[CCode (cheader_filename = "libdino.h")]
	public static string get_cache_dir ();
	[CCode (cheader_filename = "libdino.h")]
	public static string get_conversation_display_name (Dino.StreamInteractor stream_interactor, Dino.Entities.Conversation conversation, string? muc_pm_format);
	[CCode (cheader_filename = "libdino.h")]
	public static string get_groupchat_display_name (Dino.StreamInteractor stream_interactor, Dino.Entities.Account account, Xmpp.Jid jid);
	[CCode (cheader_filename = "libdino.h")]
	public static async Dino.Login1Manager? get_login1 ();
	[CCode (cheader_filename = "libdino.h")]
	public static async Dino.DBusNotifications? get_notifications_dbus ();
	[CCode (cheader_filename = "libdino.h")]
	public static string get_occupant_display_name (Dino.StreamInteractor stream_interactor, Dino.Entities.Conversation conversation, Xmpp.Jid jid, string? self_word = null, bool muc_real_name = false);
	[CCode (cheader_filename = "libdino.h")]
	public static string get_participant_display_name (Dino.StreamInteractor stream_interactor, Dino.Entities.Conversation conversation, Xmpp.Jid participant, string? self_word = null);
	[CCode (cheader_filename = "libdino.h")]
	public static string? get_real_display_name (Dino.StreamInteractor stream_interactor, Dino.Entities.Account account, Xmpp.Jid jid, string? self_word = null);
	[CCode (cheader_filename = "libdino.h")]
	public static string get_short_version ();
	[CCode (cheader_filename = "libdino.h")]
	public static string get_storage_dir ();
	[CCode (cheader_filename = "libdino.h")]
	public static Dino.UPower? get_upower ();
	[CCode (cheader_filename = "libdino.h")]
	public static string get_version ();
	[CCode (cheader_filename = "libdino.h")]
	public static void internationalize (string gettext_package, string locales_dir);
	[CCode (cheader_filename = "libdino.h")]
	public static string message_body_without_reply_fallback (Dino.Entities.Message message);
	[CCode (cheader_filename = "dino_i18n.h", cname = "dino_ngettext")]
	public static unowned string n (string msgid, string plural, ulong number);
	[CCode (cheader_filename = "libdino.h")]
	public static void send_message (Dino.Entities.Conversation conversation, string text, int reply_to_id, Dino.Entities.Message? correction_to, Gee.List<Xmpp.Xep.MessageMarkup.Span> markups);
}
[CCode (cheader_filename = "libdino.h")]
public class WeakMap<K,V> : Gee.AbstractMap<K,V> {
	public Gee.EqualDataFunc<K>? key_equal_func;
	public Gee.HashDataFunc<K>? key_hash_func;
	public Gee.EqualDataFunc<V>? value_equal_func;
	public WeakMap (owned Gee.HashDataFunc<K>? key_hash_func = null, owned Gee.EqualDataFunc<K>? key_equal_func = null, owned Gee.EqualDataFunc<V>? value_equal_func = null);
	public override void clear ();
	public override void dispose ();
	public override V @get (K key);
	public override bool has (K key, V value);
	public override bool has_key (K key);
	public override Gee.MapIterator<K,V> map_iterator ();
	public override void @set (K key, V value);
	public override bool unset (K key, out V value = null);
	public override Gee.Set<Gee.Map.Entry<K,V>> entries { owned get; }
	public override Gee.Set<K> keys { owned get; }
	public override bool read_only { get; }
	public override int size { get; }
	public override Gee.Collection<V> values { owned get; }
}
