/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.migration;

import jakarta.inject.Inject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Optional;
import org.cryptomator.cryptofs.VaultConfig;
import org.cryptomator.cryptofs.common.FileSystemCapabilityChecker;
import org.cryptomator.cryptofs.migration.DaggerMigrationComponent;
import org.cryptomator.cryptofs.migration.Migration;
import org.cryptomator.cryptofs.migration.MigrationComponent;
import org.cryptomator.cryptofs.migration.api.MigrationContinuationListener;
import org.cryptomator.cryptofs.migration.api.MigrationProgressListener;
import org.cryptomator.cryptofs.migration.api.Migrator;
import org.cryptomator.cryptofs.migration.api.NoApplicableMigratorException;
import org.cryptomator.cryptolib.api.CryptoException;
import org.cryptomator.cryptolib.api.UnsupportedVaultFormatException;
import org.cryptomator.cryptolib.common.MasterkeyFileAccess;

public class Migrators {
    private static final MigrationComponent COMPONENT = DaggerMigrationComponent.builder().csprng(Migrators.strongSecureRandom()).build();
    private final Map<Migration, Migrator> migrators;

    @Inject
    Migrators(Map<Migration, Migrator> migrators) {
        this.migrators = migrators;
    }

    private static SecureRandom strongSecureRandom() {
        try {
            return SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("A strong algorithm must exist in every Java platform.", e);
        }
    }

    public static Migrators get() {
        return COMPONENT.migrators();
    }

    public boolean needsMigration(Path pathToVault, String vaultConfigFilename, String masterkeyFilename) throws IOException {
        int vaultVersion = this.determineVaultVersion(pathToVault, vaultConfigFilename, masterkeyFilename);
        return vaultVersion < 8;
    }

    public void migrate(Path pathToVault, String vaultConfigFilename, String masterkeyFilename, CharSequence passphrase, MigrationProgressListener progressListener, MigrationContinuationListener continuationListener) throws NoApplicableMigratorException, CryptoException, IOException {
        FileSystemCapabilityChecker.assertAllCapabilities(pathToVault);
        int vaultVersion = this.determineVaultVersion(pathToVault, vaultConfigFilename, masterkeyFilename);
        try {
            Migrator migrator = this.findApplicableMigrator(vaultVersion).orElseThrow(NoApplicableMigratorException::new);
            migrator.migrate(pathToVault, vaultConfigFilename, masterkeyFilename, passphrase, progressListener, continuationListener);
        }
        catch (UnsupportedVaultFormatException e) {
            throw new IllegalStateException("Vault version checked beforehand but not supported by migrator.");
        }
    }

    private int determineVaultVersion(Path pathToVault, String vaultConfigFilename, String masterkeyFilename) throws IOException {
        Path vaultConfigPath = pathToVault.resolve(vaultConfigFilename);
        Path masterKeyPath = pathToVault.resolve(masterkeyFilename);
        if (Files.exists(vaultConfigPath, new LinkOption[0])) {
            String jwt = Files.readString(vaultConfigPath);
            return VaultConfig.decode(jwt).allegedVaultVersion();
        }
        if (Files.exists(masterKeyPath, new LinkOption[0])) {
            return MasterkeyFileAccess.readAllegedVaultVersion((byte[])Files.readAllBytes(masterKeyPath));
        }
        throw new IOException("Did not find " + vaultConfigFilename + " nor " + masterkeyFilename);
    }

    private Optional<Migrator> findApplicableMigrator(int version) {
        return this.migrators.entrySet().stream().filter(entry -> ((Migration)((Object)((Object)entry.getKey()))).isApplicable(version)).map(Map.Entry::getValue).findAny();
    }
}

