/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.dir;

import jakarta.inject.Inject;
import java.util.stream.Stream;
import org.cryptomator.cryptofs.dir.BrokenDirectoryFilter;
import org.cryptomator.cryptofs.dir.C9rProcessor;
import org.cryptomator.cryptofs.dir.C9sProcessor;
import org.cryptomator.cryptofs.dir.DirectoryStreamScoped;
import org.cryptomator.cryptofs.dir.Node;

@DirectoryStreamScoped
class NodeProcessor {
    private final C9rProcessor c9rProcessor;
    private final C9sProcessor c9sProcessor;
    private final BrokenDirectoryFilter brokenDirFilter;

    @Inject
    public NodeProcessor(C9rProcessor c9rProcessor, C9sProcessor c9sProcessor, BrokenDirectoryFilter brokenDirFilter) {
        this.c9rProcessor = c9rProcessor;
        this.c9sProcessor = c9sProcessor;
        this.brokenDirFilter = brokenDirFilter;
    }

    public Stream<Node> process(Node node) {
        if (node.fullCiphertextFileName.endsWith(".c9r")) {
            return this.c9rProcessor.process(node).flatMap(this.brokenDirFilter::process);
        }
        if (node.fullCiphertextFileName.endsWith(".c9s")) {
            return this.c9sProcessor.process(node).flatMap(this.brokenDirFilter::process);
        }
        return Stream.empty();
    }
}

