/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.io.BaseEncoding;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.time.Duration;
import org.cryptomator.cryptofs.CryptoFileSystemScoped;
import org.cryptomator.cryptofs.ReadonlyFlag;
import org.cryptomator.cryptolib.common.MessageDigestSupplier;
import org.cryptomator.cryptolib.common.ObjectPool;

@CryptoFileSystemScoped
public class LongFileNameProvider {
    public static final int MAX_FILENAME_BUFFER_SIZE = 10240;
    private static final BaseEncoding BASE64 = BaseEncoding.base64Url();
    private static final Duration MAX_CACHE_AGE = Duration.ofMinutes(1L);
    private final ReadonlyFlag readonlyFlag;
    private final Cache<Path, String> longNames;

    @Inject
    public LongFileNameProvider(ReadonlyFlag readonlyFlag) {
        this.readonlyFlag = readonlyFlag;
        this.longNames = Caffeine.newBuilder().expireAfterAccess(MAX_CACHE_AGE).build();
    }

    private String load(Path c9sPath) throws UncheckedIOException {
        String string;
        block10: {
            Path longNameFile = c9sPath.resolve("name.c9s");
            SeekableByteChannel ch = Files.newByteChannel(longNameFile, StandardOpenOption.READ);
            try {
                if (ch.size() > 10240L) {
                    throw new IOException("Unexpectedly large file: " + String.valueOf(longNameFile));
                }
                assert (ch.size() <= 10240L);
                ByteBuffer buf = ByteBuffer.allocate((int)ch.size());
                ch.read(buf);
                buf.flip();
                string = StandardCharsets.UTF_8.decode(buf).toString();
                if (ch == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ch != null) {
                        try {
                            ch.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            ch.close();
        }
        return string;
    }

    public boolean isDeflated(String possiblyDeflatedFileName) {
        return possiblyDeflatedFileName.endsWith(".c9s");
    }

    public String inflate(Path c9sPath) throws IOException {
        try {
            return (String)this.longNames.get((Object)c9sPath, this::load);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public DeflatedFileName deflate(Path c9rPath) {
        String longFileName = c9rPath.getFileName().toString();
        byte[] longFileNameBytes = longFileName.getBytes(StandardCharsets.UTF_8);
        try (ObjectPool.Lease sha1 = MessageDigestSupplier.SHA1.instance();){
            byte[] hash = ((MessageDigest)sha1.get()).digest(longFileNameBytes);
            String shortName = BASE64.encode(hash) + ".c9s";
            Path c9sPath = c9rPath.resolveSibling(shortName);
            this.longNames.put((Object)c9sPath, (Object)longFileName);
            DeflatedFileName deflatedFileName = new DeflatedFileName(c9sPath, longFileName, this.readonlyFlag);
            return deflatedFileName;
        }
    }

    public static class DeflatedFileName {
        public final Path c9sPath;
        public final String longName;
        private final ReadonlyFlag readonlyFlag;

        DeflatedFileName(Path c9sPath, String longName, ReadonlyFlag readonlyFlag) {
            this.c9sPath = c9sPath;
            this.longName = longName;
            this.readonlyFlag = readonlyFlag;
        }

        public void persist() throws IOException {
            this.readonlyFlag.assertWritable();
            Path longNameFile = this.c9sPath.resolve("name.c9s");
            Files.createDirectories(this.c9sPath, new FileAttribute[0]);
            Files.writeString(longNameFile, (CharSequence)this.longName, StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        }
    }
}

