/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import jakarta.inject.Inject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.CompletionException;
import org.cryptomator.cryptofs.CryptoFileSystemScoped;
import org.cryptomator.cryptofs.DirectoryIdLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CryptoFileSystemScoped
class DirectoryIdProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DirectoryIdProvider.class);
    private static final int MAX_CACHE_SIZE = 5000;
    private final LoadingCache<Path, String> ids;

    @Inject
    public DirectoryIdProvider(DirectoryIdLoader directoryIdLoader) {
        this.ids = Caffeine.newBuilder().maximumSize(5000L).build((CacheLoader)directoryIdLoader);
    }

    public String load(Path dirFilePath) throws IOException {
        try {
            return (String)this.ids.get((Object)dirFilePath);
        }
        catch (CompletionException e) {
            LOG.warn("Failed to load directory id from {}", (Object)dirFilePath, (Object)e.getCause());
            throw (IOException)e.getCause();
        }
    }

    public void delete(Path dirFilePath) {
        this.ids.invalidate((Object)dirFilePath);
    }

    public void move(Path srcDirFilePath, Path dstDirFilePath) {
        String id = (String)this.ids.getIfPresent((Object)srcDirFilePath);
        if (id != null) {
            this.ids.put((Object)dstDirFilePath, (Object)id);
            this.ids.invalidate((Object)srcDirFilePath);
        }
    }
}

