/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import jakarta.inject.Inject;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.cryptomator.cryptofs.CiphertextDirectory;
import org.cryptomator.cryptofs.CiphertextPathValidations;
import org.cryptomator.cryptofs.CryptoFileSystemScoped;
import org.cryptomator.cryptolib.api.CryptoException;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.common.DecryptingReadableByteChannel;
import org.cryptomator.cryptolib.common.EncryptingWritableByteChannel;

@CryptoFileSystemScoped
public class DirectoryIdBackup {
    private final Cryptor cryptor;

    @Inject
    public DirectoryIdBackup(Cryptor cryptor) {
        this.cryptor = cryptor;
    }

    public void write(CiphertextDirectory ciphertextDirectory) throws IOException {
        try (SeekableByteChannel channel = Files.newByteChannel(DirectoryIdBackup.getBackupFilePath(ciphertextDirectory.path()), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
             EncryptingWritableByteChannel encryptingChannel = this.wrapEncryptionAround(channel, this.cryptor);){
            encryptingChannel.write(ByteBuffer.wrap(ciphertextDirectory.dirId().getBytes(StandardCharsets.US_ASCII)));
        }
    }

    public static void write(Cryptor cryptor, CiphertextDirectory ciphertextDirectory) throws IOException {
        new DirectoryIdBackup(cryptor).write(ciphertextDirectory);
    }

    public byte[] read(Path ciphertextContentDir) throws IOException, CryptoException, IllegalStateException {
        if (!CiphertextPathValidations.isCiphertextContentDir(ciphertextContentDir)) {
            throw new IllegalArgumentException("Directory %s is not a ciphertext content dir".formatted(ciphertextContentDir));
        }
        Path dirIdBackupFile = DirectoryIdBackup.getBackupFilePath(ciphertextContentDir);
        ByteBuffer dirIdBuffer = ByteBuffer.allocate(37);
        try (SeekableByteChannel channel = Files.newByteChannel(dirIdBackupFile, StandardOpenOption.READ);
             DecryptingReadableByteChannel decryptingChannel = this.wrapDecryptionAround(channel, this.cryptor);){
            int read = decryptingChannel.read(dirIdBuffer);
            if (read < 0 || read > 36) {
                throw new IllegalStateException("Read directory id exceeds the maximum length of %d characters".formatted(36));
            }
        }
        byte[] dirId = new byte[dirIdBuffer.position()];
        dirIdBuffer.get(0, dirId);
        return dirId;
    }

    public static byte[] read(Cryptor cryptor, Path ciphertextContentDir) throws IOException, CryptoException, IllegalStateException {
        return new DirectoryIdBackup(cryptor).read(ciphertextContentDir);
    }

    private static Path getBackupFilePath(Path ciphertextContentDir) {
        return ciphertextContentDir.resolve("dirid.c9r");
    }

    DecryptingReadableByteChannel wrapDecryptionAround(ByteChannel channel, Cryptor cryptor) {
        return new DecryptingReadableByteChannel((ReadableByteChannel)channel, cryptor, true);
    }

    EncryptingWritableByteChannel wrapEncryptionAround(ByteChannel channel, Cryptor cryptor) {
        return new EncryptingWritableByteChannel((WritableByteChannel)channel, cryptor);
    }
}

