/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import jakarta.inject.Inject;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileStoreAttributeView;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.cryptomator.cryptofs.CryptoFileSystemScoped;
import org.cryptomator.cryptofs.ReadonlyFlag;
import org.cryptomator.cryptofs.attr.AttributeViewType;

@CryptoFileSystemScoped
class CryptoFileStore
extends FileStore {
    static final long DEFAULT_TOTAL_SPACE = 10000000000L;
    static final long DEFAULT_USABLE_SPACE = 10000000000L;
    static final long DEFAULT_UNALLOCATED_SPACE = 10000000000L;
    private final Optional<FileStore> delegate;
    private final ReadonlyFlag readonlyFlag;
    private final Set<AttributeViewType> supportedFileAttributeViewTypes;

    @Inject
    public CryptoFileStore(Optional<FileStore> delegate, ReadonlyFlag readonlyFlag) {
        this.delegate = delegate;
        this.readonlyFlag = readonlyFlag;
        this.supportedFileAttributeViewTypes = this.determineSupportedFileAttributeViewTypes();
    }

    private Set<AttributeViewType> determineSupportedFileAttributeViewTypes() {
        return Arrays.stream(AttributeViewType.values()).filter(t -> this.supportsFileAttributeView(t.getType())).collect(Collectors.toSet());
    }

    Set<AttributeViewType> supportedFileAttributeViewTypes() {
        return this.supportedFileAttributeViewTypes;
    }

    @Override
    public String name() {
        return this.type();
    }

    @Override
    public String type() {
        return this.getClass().getSimpleName();
    }

    @Override
    public boolean isReadOnly() {
        return this.readonlyFlag.isSet() || this.delegate.map(FileStore::isReadOnly).orElse(false) != false;
    }

    @Override
    public long getTotalSpace() throws IOException {
        return this.delegate.isPresent() ? this.delegate.get().getTotalSpace() : 10000000000L;
    }

    @Override
    public long getUsableSpace() throws IOException {
        return this.delegate.isPresent() ? this.delegate.get().getUsableSpace() : 10000000000L;
    }

    @Override
    public long getUnallocatedSpace() throws IOException {
        return this.delegate.isPresent() ? this.delegate.get().getUnallocatedSpace() : 10000000000L;
    }

    @Override
    public boolean supportsFileAttributeView(Class<? extends FileAttributeView> type) {
        if (this.delegate.isPresent()) {
            return this.delegate.get().supportsFileAttributeView(type) && AttributeViewType.getByType(type).isPresent();
        }
        return AttributeViewType.BASIC.getType().equals(type);
    }

    @Override
    public boolean supportsFileAttributeView(String name) {
        if (this.delegate.isPresent()) {
            return this.delegate.get().supportsFileAttributeView(name) && AttributeViewType.getByName(name).isPresent();
        }
        return AttributeViewType.BASIC.getViewName().equals(name);
    }

    @Override
    public <V extends FileStoreAttributeView> V getFileStoreAttributeView(Class<V> type) {
        return null;
    }

    @Override
    public Object getAttribute(String attribute) {
        throw new UnsupportedOperationException();
    }
}

