/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.linux.autostart;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import org.cryptomator.integrations.autostart.AutoStartProvider;
import org.cryptomator.integrations.autostart.ToggleAutoStartFailedException;
import org.cryptomator.integrations.common.CheckAvailability;
import org.cryptomator.integrations.common.OperatingSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CheckAvailability
@OperatingSystem(value=OperatingSystem.Value.LINUX)
public class FreedesktopAutoStartService
implements AutoStartProvider {
    private static final Logger LOG = LoggerFactory.getLogger(FreedesktopAutoStartService.class);
    private static final String CMD_PROPERTY = "cryptomator.integrationsLinux.autoStartCmd";
    private static final String AUTOSTART_FILENAME = "Cryptomator.desktop";
    private static final String CONTENT_TEMPLATE = "[Desktop Entry]\nType=Application\nExec=%s\nHidden=false\nNoDisplay=false\nX-GNOME-Autostart-enabled=true\nName=Cryptomator\nComment=Created with %s\n";
    private final Path autostartFile;
    private final String content;
    private final boolean hasExecValue;

    public FreedesktopAutoStartService() {
        String xdgConfigDirString = (String)((Object)Objects.requireNonNullElse(System.getenv("XDG_CONFIG_HOME"), System.getProperty("user.home") + "/.config"));
        this.autostartFile = Path.of(xdgConfigDirString, "autostart", AUTOSTART_FILENAME);
        String execValue = System.getProperty(CMD_PROPERTY, "");
        this.hasExecValue = !execValue.isBlank();
        this.content = CONTENT_TEMPLATE.formatted(execValue, this.getClass().getName());
    }

    public synchronized void enable() throws ToggleAutoStartFailedException {
        try {
            Files.writeString(this.autostartFile, (CharSequence)this.content, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new ToggleAutoStartFailedException("Failed to activate Cryptomator autostart for GNOME desktop environment.", (Throwable)e);
        }
    }

    public synchronized void disable() throws ToggleAutoStartFailedException {
        try {
            Files.deleteIfExists(this.autostartFile);
        }
        catch (IOException e) {
            throw new ToggleAutoStartFailedException("Failed to deactivate Cryptomator autostart for GNOME desktop environment.", (Throwable)e);
        }
    }

    public synchronized boolean isEnabled() {
        return Files.exists(this.autostartFile, new LinkOption[0]);
    }

    @CheckAvailability
    public boolean isSupported() {
        return this.hasExecValue && Files.exists(this.autostartFile.getParent(), new LinkOption[0]);
    }
}

