/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.webdav.core.servlet;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.lock.LockInfo;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.Type;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.PropEntry;
import org.cryptomator.webdav.core.servlet.DavFolder;
import org.cryptomator.webdav.core.servlet.DavLocatorImpl;
import org.cryptomator.webdav.core.servlet.DavResourceFactoryImpl;

abstract class DavNode
implements DavResource {
    private static final String DAV_COMPLIANCE_CLASSES = "1, 2";
    private static final String[] DAV_CREATIONDATE_PROPNAMES = new String[]{"creationdate", "Win32CreationTime"};
    private static final String[] DAV_MODIFIEDDATE_PROPNAMES = new String[]{"getlastmodified", "Win32LastModifiedTime"};
    protected final DavResourceFactoryImpl factory;
    protected final LockManager lockManager;
    protected final DavLocatorImpl locator;
    protected final Path path;
    protected final Optional<BasicFileAttributes> attr;
    protected final DavSession session;
    protected final DavPropertySet properties;

    public DavNode(DavResourceFactoryImpl factory, LockManager lockManager, DavLocatorImpl locator, Path path, Optional<BasicFileAttributes> attr, DavSession session) {
        this.factory = factory;
        this.lockManager = lockManager;
        this.locator = locator;
        this.path = path;
        this.attr = attr;
        this.session = session;
        this.properties = new DavPropertySet();
    }

    public String getComplianceClass() {
        return DAV_COMPLIANCE_CLASSES;
    }

    public String getSupportedMethods() {
        return "OPTIONS, GET, HEAD, TRACE, PROPFIND, PROPPATCH, MKCOL, COPY, PUT, DELETE, MOVE, LOCK, UNLOCK";
    }

    public boolean exists() {
        return this.attr.isPresent();
    }

    public String getDisplayName() {
        return (String)Iterables.getLast((Iterable)Splitter.on((char)'/').omitEmptyStrings().split((CharSequence)this.getResourcePath()));
    }

    public DavLocatorImpl getLocator() {
        return this.locator;
    }

    public String getResourcePath() {
        return this.locator.getResourcePath();
    }

    public String getHref() {
        return this.locator.getHref(this.isCollection());
    }

    public long getModificationTime() {
        return this.attr.map(BasicFileAttributes::lastModifiedTime).map(FileTime::toInstant).map(Instant::toEpochMilli).orElse(-1L);
    }

    protected void setModificationTime(Instant instant) throws DavException {
        BasicFileAttributeView attrView = Files.getFileAttributeView(this.path, BasicFileAttributeView.class, new LinkOption[0]);
        if (attrView != null) {
            try {
                attrView.setTimes(FileTime.from(instant), null, null);
            }
            catch (IOException e) {
                throw new DavException(500, (Throwable)e);
            }
        }
    }

    protected void setCreationTime(Instant instant) throws DavException {
        BasicFileAttributeView attrView = Files.getFileAttributeView(this.path, BasicFileAttributeView.class, new LinkOption[0]);
        if (attrView != null) {
            try {
                attrView.setTimes(null, null, FileTime.from(instant));
            }
            catch (IOException e) {
                throw new DavException(500, (Throwable)e);
            }
        }
    }

    public DavPropertyName[] getPropertyNames() {
        return this.getProperties().getPropertyNames();
    }

    public DavProperty<?> getProperty(DavPropertyName name) {
        String namespacelessPropertyName = name.getName();
        if (Arrays.asList(DAV_CREATIONDATE_PROPNAMES).contains(namespacelessPropertyName)) {
            return this.creationDateProperty(name).orElse(null);
        }
        if (Arrays.asList(DAV_MODIFIEDDATE_PROPNAMES).contains(namespacelessPropertyName)) {
            return this.lastModifiedDateProperty(name).orElse(null);
        }
        return this.properties.get(name);
    }

    public DavPropertySet getProperties() {
        this.creationDateProperty(DavPropertyName.CREATIONDATE).ifPresent(arg_0 -> ((DavPropertySet)this.properties).add(arg_0));
        this.lastModifiedDateProperty(DavPropertyName.GETLASTMODIFIED).ifPresent(arg_0 -> ((DavPropertySet)this.properties).add(arg_0));
        return this.properties;
    }

    private Optional<DavProperty<?>> lastModifiedDateProperty(DavPropertyName name) {
        return this.attr.map(BasicFileAttributes::lastModifiedTime).map(FileTime::toInstant).map(creationTime -> OffsetDateTime.ofInstant(creationTime, ZoneOffset.UTC)).map(creationDate -> new DefaultDavProperty(name, (Object)DateTimeFormatter.RFC_1123_DATE_TIME.format((TemporalAccessor)creationDate)));
    }

    private Optional<DavProperty<?>> creationDateProperty(DavPropertyName name) {
        return this.attr.map(BasicFileAttributes::creationTime).map(FileTime::toInstant).map(creationTime -> OffsetDateTime.ofInstant(creationTime, ZoneOffset.UTC)).map(creationDate -> new DefaultDavProperty(name, (Object)DateTimeFormatter.RFC_1123_DATE_TIME.format((TemporalAccessor)creationDate)));
    }

    public void setProperty(DavProperty<?> property) throws DavException {
        String namespacelessPropertyName = property.getName().getName();
        if (Arrays.asList(DAV_CREATIONDATE_PROPNAMES).contains(namespacelessPropertyName) && property.getValue() instanceof String) {
            String createDateStr = (String)property.getValue();
            OffsetDateTime creationDate = OffsetDateTime.from(DateTimeFormatter.RFC_1123_DATE_TIME.parse(createDateStr));
            this.setCreationTime(creationDate.toInstant());
        } else if (Arrays.asList(DAV_MODIFIEDDATE_PROPNAMES).contains(namespacelessPropertyName) && property.getValue() instanceof String) {
            String lastModifiedDateStr = (String)property.getValue();
            OffsetDateTime lastModifiedDate = OffsetDateTime.from(DateTimeFormatter.RFC_1123_DATE_TIME.parse(lastModifiedDateStr));
            this.setModificationTime(lastModifiedDate.toInstant());
        }
        this.properties.add(property);
    }

    public void removeProperty(DavPropertyName propertyName) {
        this.getProperties().remove(propertyName);
    }

    public MultiStatusResponse alterProperties(List<? extends PropEntry> changeList) throws DavException {
        DavPropertyNameSet names = new DavPropertyNameSet();
        for (PropEntry propEntry : changeList) {
            if (propEntry instanceof DavProperty) {
                DavProperty prop = (DavProperty)propEntry;
                this.setProperty(prop);
                names.add(prop.getName());
                continue;
            }
            if (!(propEntry instanceof DavPropertyName)) continue;
            DavPropertyName name = (DavPropertyName)propEntry;
            this.removeProperty(name);
            names.add(name);
        }
        return new MultiStatusResponse((DavResource)this, names);
    }

    public DavFolder getCollection() {
        BasicFileAttributes parentAttr;
        DavLocatorImpl parentLocator = this.locator.resolveParent();
        if (parentLocator == null) {
            return null;
        }
        Path parentPath = this.path.getParent();
        try {
            parentAttr = Files.readAttributes(parentPath, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (NoSuchFileException e) {
            parentAttr = null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this.factory.createFolder(parentLocator, parentPath, Optional.ofNullable(parentAttr), this.session);
    }

    public boolean isLockable(Type type, Scope scope) {
        return Type.WRITE.equals((Object)type) && Scope.EXCLUSIVE.equals((Object)scope) || Scope.SHARED.equals((Object)scope);
    }

    public boolean hasLock(Type type, Scope scope) {
        return this.getLock(type, scope) != null;
    }

    public ActiveLock getLock(Type type, Scope scope) {
        return this.lockManager.getLock(type, scope, (DavResource)this);
    }

    public ActiveLock[] getLocks() {
        ActiveLock exclusiveWriteLock = this.getLock(Type.WRITE, Scope.EXCLUSIVE);
        ActiveLock sharedWriteLock = this.getLock(Type.WRITE, Scope.SHARED);
        return (ActiveLock[])Stream.of(exclusiveWriteLock, sharedWriteLock).filter(Objects::nonNull).toArray(ActiveLock[]::new);
    }

    public ActiveLock lock(LockInfo reqLockInfo) throws DavException {
        return this.lockManager.createLock(reqLockInfo, (DavResource)this);
    }

    public ActiveLock refreshLock(LockInfo reqLockInfo, String lockToken) throws DavException {
        return this.lockManager.refreshLock(reqLockInfo, lockToken, (DavResource)this);
    }

    public void unlock(String lockToken) throws DavException {
        this.lockManager.releaseLock(lockToken, (DavResource)this);
    }

    public void addLockManager(LockManager lockmgr) {
        throw new UnsupportedOperationException("Locks are managed");
    }

    public DavResourceFactoryImpl getFactory() {
        return this.factory;
    }

    public DavSession getSession() {
        return this.session;
    }
}

