/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.jfuse.api;

import java.nio.ByteBuffer;
import java.util.Set;
import org.cryptomator.jfuse.api.DirFiller;
import org.cryptomator.jfuse.api.Errno;
import org.cryptomator.jfuse.api.FileInfo;
import org.cryptomator.jfuse.api.FuseConfig;
import org.cryptomator.jfuse.api.FuseConnInfo;
import org.cryptomator.jfuse.api.Stat;
import org.cryptomator.jfuse.api.Statvfs;
import org.cryptomator.jfuse.api.TimeSpec;
import org.jetbrains.annotations.Nullable;

public interface FuseOperations {
    public static final int FUSE_READDIR_PLUS = 1;

    public Errno errno();

    public Set<Operation> supportedOperations();

    default public int getattr(String path, Stat stat, @Nullable FileInfo fi) {
        return -this.errno().enosys();
    }

    default public int readlink(String path, ByteBuffer buf, long len) {
        return -this.errno().enosys();
    }

    default public int mknod(String path, short mode, int rdev) {
        return -this.errno().enosys();
    }

    default public int mkdir(String path, int mode) {
        return -this.errno().enosys();
    }

    default public int unlink(String path) {
        return -this.errno().enosys();
    }

    default public int rmdir(String path) {
        return -this.errno().enosys();
    }

    default public int symlink(String linkname, String target) {
        return -this.errno().enosys();
    }

    default public int rename(String oldpath, String newpath, int flags) {
        return -this.errno().enosys();
    }

    default public int link(String linkname, String target) {
        return -this.errno().enosys();
    }

    default public int chmod(String path, int mode, @Nullable FileInfo fi) {
        return -this.errno().enosys();
    }

    default public int chown(String path, int uid, int gid, @Nullable FileInfo fi) {
        return -this.errno().enosys();
    }

    default public int truncate(String path, long size, @Nullable FileInfo fi) {
        return -this.errno().enosys();
    }

    default public int open(String path, FileInfo fi) {
        return -this.errno().enosys();
    }

    default public int read(String path, ByteBuffer buf, long count, long offset, FileInfo fi) {
        return -this.errno().enosys();
    }

    default public int write(String path, ByteBuffer buf, long count, long offset, FileInfo fi) {
        return -this.errno().enosys();
    }

    default public int statfs(String path, Statvfs statvfs) {
        return -this.errno().enosys();
    }

    default public int flush(String path, FileInfo fi) {
        return -this.errno().enosys();
    }

    default public int release(String path, FileInfo fi) {
        return 0;
    }

    default public int fsync(String path, int datasync, FileInfo fi) {
        return -this.errno().enosys();
    }

    default public int setxattr(String path, String name, ByteBuffer value, int flags) {
        return -this.errno().enosys();
    }

    default public int getxattr(String path, String name, ByteBuffer value) {
        return -this.errno().enosys();
    }

    default public int listxattr(String path, ByteBuffer list) {
        return -this.errno().enosys();
    }

    default public int removexattr(String path, String name) {
        return -this.errno().enosys();
    }

    default public int opendir(String path, FileInfo fi) {
        return -this.errno().enosys();
    }

    default public int readdir(String path, DirFiller filler, long offset, FileInfo fi, int flags) {
        return -this.errno().enosys();
    }

    default public int releasedir(@Nullable String path, FileInfo fi) {
        return 0;
    }

    default public int fsyncdir(@Nullable String path, int datasync, FileInfo fi) {
        return -this.errno().enosys();
    }

    default public void init(FuseConnInfo conn, @Nullable FuseConfig cfg) {
    }

    default public void destroy() {
    }

    default public int access(String path, int mask) {
        return -this.errno().enosys();
    }

    default public int create(String path, int mode, FileInfo fi) {
        return -this.errno().enosys();
    }

    default public int utimens(String path, TimeSpec atime, TimeSpec mtime, @Nullable FileInfo fi) {
        return -this.errno().enosys();
    }

    default public int ioctl(String path, int cmd, ByteBuffer arg, FileInfo fi, int flags, @Nullable ByteBuffer data) {
        return -this.errno().enosys();
    }

    default public int flock(String path, FileInfo fi, int op) {
        return -this.errno().enosys();
    }

    default public int fallocate(String path, int mode, long offset, long length, FileInfo fi) {
        return -this.errno().enosys();
    }

    public static enum Operation {
        ACCESS,
        CHMOD,
        CHOWN,
        CREATE,
        DESTROY,
        FLUSH,
        FSYNC,
        FSYNCDIR,
        GET_ATTR,
        GET_XATTR,
        INIT,
        LIST_XATTR,
        MKDIR,
        OPEN,
        OPEN_DIR,
        READ,
        READLINK,
        READ_DIR,
        RELEASE,
        RELEASE_DIR,
        REMOVE_XATTR,
        RENAME,
        RMDIR,
        SET_XATTR,
        STATFS,
        SYMLINK,
        TRUNCATE,
        UNLINK,
        UTIMENS,
        WRITE;

    }
}

