/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.v2;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.SecureRandom;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import org.cryptomator.cryptolib.api.AuthenticationFailedException;
import org.cryptomator.cryptolib.api.FileContentCryptor;
import org.cryptomator.cryptolib.api.FileHeader;
import org.cryptomator.cryptolib.common.CipherSupplier;
import org.cryptomator.cryptolib.common.DestroyableSecretKey;
import org.cryptomator.cryptolib.common.ObjectPool;
import org.cryptomator.cryptolib.v2.FileHeaderImpl;

class FileContentCryptorImpl
implements FileContentCryptor {
    private final SecureRandom random;

    FileContentCryptorImpl(SecureRandom random) {
        this.random = random;
    }

    @Override
    public boolean canSkipAuthentication() {
        return false;
    }

    @Override
    public int cleartextChunkSize() {
        return 32768;
    }

    @Override
    public int ciphertextChunkSize() {
        return 32796;
    }

    @Override
    public ByteBuffer encryptChunk(ByteBuffer cleartextChunk, long chunkNumber, FileHeader header) {
        ByteBuffer ciphertextChunk = ByteBuffer.allocate(32796);
        this.encryptChunk(cleartextChunk, ciphertextChunk, chunkNumber, header);
        ciphertextChunk.flip();
        return ciphertextChunk;
    }

    @Override
    public void encryptChunk(ByteBuffer cleartextChunk, ByteBuffer ciphertextChunk, long chunkNumber, FileHeader header) {
        if (cleartextChunk.remaining() < 0 || cleartextChunk.remaining() > 32768) {
            throw new IllegalArgumentException("Invalid cleartext chunk size: " + cleartextChunk.remaining() + ", expected range [1, " + 32768 + "]");
        }
        if (ciphertextChunk.remaining() < 32796) {
            throw new IllegalArgumentException("Invalid cipehrtext chunk size: " + ciphertextChunk.remaining() + ", must fit up to " + 32796 + " bytes.");
        }
        FileHeaderImpl headerImpl = FileHeaderImpl.cast(header);
        this.encryptChunk(cleartextChunk, ciphertextChunk, chunkNumber, headerImpl.getNonce(), headerImpl.getPayload().getContentKey());
    }

    @Override
    public ByteBuffer decryptChunk(ByteBuffer ciphertextChunk, long chunkNumber, FileHeader header, boolean authenticate) throws AuthenticationFailedException {
        ByteBuffer cleartextChunk = ByteBuffer.allocate(32784);
        this.decryptChunk(ciphertextChunk, cleartextChunk, chunkNumber, header, authenticate);
        cleartextChunk.flip();
        return cleartextChunk;
    }

    @Override
    public void decryptChunk(ByteBuffer ciphertextChunk, ByteBuffer cleartextChunk, long chunkNumber, FileHeader header, boolean authenticate) throws AuthenticationFailedException {
        if (ciphertextChunk.remaining() < 28 || ciphertextChunk.remaining() > 32796) {
            throw new IllegalArgumentException("Invalid ciphertext chunk size: " + ciphertextChunk.remaining() + ", expected range [" + 28 + ", " + 32796 + "]");
        }
        if (cleartextChunk.remaining() < 32768) {
            throw new IllegalArgumentException("Invalid cleartext chunk size: " + cleartextChunk.remaining() + ", must fit up to " + 32768 + " bytes.");
        }
        if (!authenticate) {
            throw new UnsupportedOperationException("authenticate can not be false");
        }
        FileHeaderImpl headerImpl = FileHeaderImpl.cast(header);
        this.decryptChunk(ciphertextChunk, cleartextChunk, chunkNumber, headerImpl.getNonce(), headerImpl.getPayload().getContentKey());
    }

    void encryptChunk(ByteBuffer cleartextChunk, ByteBuffer ciphertextChunk, long chunkNumber, byte[] headerNonce, DestroyableSecretKey fileKey) {
        try (DestroyableSecretKey fk = fileKey.copy();){
            byte[] nonce = new byte[12];
            this.random.nextBytes(nonce);
            try (ObjectPool.Lease<Cipher> cipher = CipherSupplier.AES_GCM.encryptionCipher(fk, new GCMParameterSpec(128, nonce));){
                byte[] chunkNumberBigEndian = this.longToBigEndianByteArray(chunkNumber);
                cipher.get().updateAAD(chunkNumberBigEndian);
                cipher.get().updateAAD(headerNonce);
                ciphertextChunk.put(nonce);
                assert (ciphertextChunk.remaining() >= cipher.get().getOutputSize(cleartextChunk.remaining()));
                cipher.get().doFinal(cleartextChunk, ciphertextChunk);
            }
        }
        catch (ShortBufferException e) {
            throw new IllegalStateException("Buffer allocated for reported output size apparently not big enough.", e);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IllegalStateException("Unexpected exception during GCM encryption.", e);
        }
    }

    void decryptChunk(ByteBuffer ciphertextChunk, ByteBuffer cleartextChunk, long chunkNumber, byte[] headerNonce, DestroyableSecretKey fileKey) throws AuthenticationFailedException {
        assert (ciphertextChunk.remaining() >= 28);
        try (DestroyableSecretKey fk = fileKey.copy();){
            byte[] nonce = new byte[12];
            ciphertextChunk.get(nonce, 0, 12);
            ByteBuffer payloadBuf = ciphertextChunk.duplicate();
            assert (payloadBuf.remaining() >= 16);
            try (ObjectPool.Lease<Cipher> cipher = CipherSupplier.AES_GCM.decryptionCipher(fk, new GCMParameterSpec(128, nonce));){
                byte[] chunkNumberBigEndian = this.longToBigEndianByteArray(chunkNumber);
                cipher.get().updateAAD(chunkNumberBigEndian);
                cipher.get().updateAAD(headerNonce);
                assert (cleartextChunk.remaining() >= cipher.get().getOutputSize(payloadBuf.remaining()));
                cipher.get().doFinal(payloadBuf, cleartextChunk);
            }
        }
        catch (AEADBadTagException e) {
            throw new AuthenticationFailedException("Content tag mismatch.", e);
        }
        catch (ShortBufferException e) {
            throw new IllegalStateException("Buffer allocated for reported output size apparently not big enough.", e);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IllegalStateException("Unexpected exception during GCM decryption.", e);
        }
    }

    private byte[] longToBigEndianByteArray(long n) {
        return ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN).putLong(n).array();
    }
}

