/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.common;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.Arrays;
import java.util.Objects;
import javax.security.auth.Destroyable;
import org.cryptomator.cryptolib.common.Destroyables;

public class ECKeyPair
implements Destroyable {
    private static final String INVALID_KEY_ERROR = "Invalid EC Key";
    private final KeyPair keyPair;
    private boolean destroyed;

    ECKeyPair(KeyPair keyPair, ECParameterSpec curveParams) {
        Preconditions.checkArgument((boolean)(keyPair.getPrivate() instanceof ECPrivateKey));
        Preconditions.checkArgument((boolean)(keyPair.getPublic() instanceof ECPublicKey));
        this.keyPair = ECKeyPair.verify(keyPair, curveParams);
    }

    public KeyPair keyPair() {
        return this.keyPair;
    }

    public ECPrivateKey getPrivate() {
        Preconditions.checkState((!this.destroyed ? 1 : 0) != 0);
        assert (this.keyPair.getPrivate() instanceof ECPrivateKey);
        return (ECPrivateKey)this.keyPair.getPrivate();
    }

    public ECPublicKey getPublic() {
        Preconditions.checkState((!this.destroyed ? 1 : 0) != 0);
        assert (this.keyPair.getPublic() instanceof ECPublicKey);
        return (ECPublicKey)this.keyPair.getPublic();
    }

    private static KeyPair verify(KeyPair keyPair, ECParameterSpec curveParams) {
        PublicKey pk = keyPair.getPublic();
        Preconditions.checkArgument((boolean)(pk instanceof ECPublicKey), (Object)INVALID_KEY_ERROR);
        Preconditions.checkArgument((curveParams.getCofactor() == 1 ? 1 : 0) != 0, (Object)"Verifying points on curves with cofactor not supported");
        ECPublicKey publicKey = (ECPublicKey)pk;
        EllipticCurve curve = curveParams.getCurve();
        Preconditions.checkArgument((!ECPoint.POINT_INFINITY.equals(publicKey.getW()) ? 1 : 0) != 0, (Object)INVALID_KEY_ERROR);
        BigInteger x = publicKey.getW().getAffineX();
        BigInteger y = publicKey.getW().getAffineY();
        BigInteger p = ((ECFieldFp)curve.getField()).getP();
        Preconditions.checkArgument((x.compareTo(BigInteger.ZERO) >= 0 && x.compareTo(p) < 0 ? 1 : 0) != 0, (Object)INVALID_KEY_ERROR);
        Preconditions.checkArgument((y.compareTo(BigInteger.ZERO) >= 0 && y.compareTo(p) < 0 ? 1 : 0) != 0, (Object)INVALID_KEY_ERROR);
        BigInteger a = curve.getA();
        BigInteger b = curve.getB();
        BigInteger ySquared = y.modPow(BigInteger.valueOf(2L), p);
        BigInteger xCubedPlusAXPlusB = x.modPow(BigInteger.valueOf(3L), p).add(a.multiply(x)).add(b).mod(p);
        Preconditions.checkArgument((boolean)ySquared.equals(xCubedPlusAXPlusB), (Object)INVALID_KEY_ERROR);
        return keyPair;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public void destroy() {
        Destroyables.destroySilently(this.keyPair.getPrivate());
        this.destroyed = true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ECKeyPair that = (ECKeyPair)o;
        return MessageDigest.isEqual(this.getPublic().getEncoded(), that.getPublic().getEncoded());
    }

    public int hashCode() {
        int result = Objects.hash(this.keyPair.getPublic().getAlgorithm());
        result = 31 * result + Arrays.hashCode(this.keyPair.getPublic().getEncoded());
        return result;
    }
}

