/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.recoverykey;

import dagger.Lazy;
import javafx.application.Application;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.stage.Stage;
import javax.inject.Inject;
import javax.inject.Named;
import org.cryptomator.common.recovery.RecoveryActionType;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultState;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.controls.NumericTextField;
import org.cryptomator.ui.recoverykey.RecoveryKeyScoped;
import org.cryptomator.ui.recoverykey.RecoveryKeyWindow;

@RecoveryKeyScoped
public class RecoveryKeyExpertSettingsController
implements FxController {
    public static final int MAX_SHORTENING_THRESHOLD = 220;
    public static final int MIN_SHORTENING_THRESHOLD = 36;
    private static final String DOCS_NAME_SHORTENING_URL = "https://docs.cryptomator.org/security/vault/#name-shortening";
    private final Stage window;
    private final Lazy<Application> application;
    private final Vault vault;
    private final ObjectProperty<RecoveryActionType> recoverType;
    private final IntegerProperty shorteningThreshold;
    private final Lazy<Scene> resetPasswordScene;
    private final Lazy<Scene> createScene;
    private final Lazy<Scene> onBoardingScene;
    private final Lazy<Scene> recoverScene;
    private final BooleanBinding validShorteningThreshold;
    @FXML
    public CheckBox expertSettingsCheckBox;
    @FXML
    public NumericTextField shorteningThresholdTextField;

    @Inject
    public RecoveryKeyExpertSettingsController(@RecoveryKeyWindow Stage window, Lazy<Application> application, @RecoveryKeyWindow Vault vault, @Named(value="recoverType") ObjectProperty<RecoveryActionType> recoverType, @Named(value="shorteningThreshold") IntegerProperty shorteningThreshold, @FxmlScene(value=FxmlFile.RECOVERYKEY_RESET_PASSWORD) Lazy<Scene> resetPasswordScene, @FxmlScene(value=FxmlFile.RECOVERYKEY_CREATE) Lazy<Scene> createScene, @FxmlScene(value=FxmlFile.RECOVERYKEY_ONBOARDING) Lazy<Scene> onBoardingScene, @FxmlScene(value=FxmlFile.RECOVERYKEY_RECOVER) Lazy<Scene> recoverScene) {
        this.window = window;
        this.application = application;
        this.vault = vault;
        this.recoverType = recoverType;
        this.shorteningThreshold = shorteningThreshold;
        this.resetPasswordScene = resetPasswordScene;
        this.createScene = createScene;
        this.onBoardingScene = onBoardingScene;
        this.recoverScene = recoverScene;
        this.validShorteningThreshold = Bindings.createBooleanBinding(this::isValidShorteningThreshold, (Observable[])new Observable[]{shorteningThreshold});
    }

    @FXML
    public void initialize() {
        this.shorteningThresholdTextField.setPromptText("36-220");
        this.shorteningThresholdTextField.setText(Integer.toString(220));
        this.shorteningThresholdTextField.textProperty().addListener((observableValue, string, newValue) -> {
            try {
                int intValue = Integer.parseInt(newValue);
                this.shorteningThreshold.set(intValue);
            }
            catch (NumberFormatException e) {
                this.shorteningThreshold.set(0);
            }
        });
    }

    @FXML
    public void toggleUseExpertSettings() {
        if (!this.expertSettingsCheckBox.isSelected()) {
            this.shorteningThresholdTextField.setText(Integer.toString(220));
        }
    }

    public void openDocs() {
        ((Application)this.application.get()).getHostServices().showDocument(DOCS_NAME_SHORTENING_URL);
    }

    public BooleanBinding validShorteningThresholdProperty() {
        return this.validShorteningThreshold;
    }

    public boolean isValidShorteningThreshold() {
        int value = this.shorteningThreshold.get();
        return value >= 36 && value <= 220;
    }

    @FXML
    public void back() {
        if (this.recoverType.get() == RecoveryActionType.RESTORE_ALL && this.vault.getState() == VaultState.Value.VAULT_CONFIG_MISSING) {
            this.window.setScene((Scene)this.recoverScene.get());
        } else if (this.recoverType.get() == RecoveryActionType.RESTORE_ALL && this.vault.getState() == VaultState.Value.ALL_MISSING) {
            this.window.setScene((Scene)this.recoverScene.get());
        } else if (this.recoverType.get() == RecoveryActionType.RESTORE_VAULT_CONFIG) {
            this.window.setScene((Scene)this.onBoardingScene.get());
        }
    }

    @FXML
    public void next() {
        if (this.recoverType.get() == RecoveryActionType.RESTORE_VAULT_CONFIG) {
            this.window.setScene((Scene)this.createScene.get());
        } else {
            this.window.setScene((Scene)this.resetPasswordScene.get());
        }
    }
}

