/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.recoverykey;

import dagger.BindsInstance;
import dagger.Lazy;
import dagger.Subcomponent;
import javafx.beans.property.ObjectProperty;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javax.inject.Named;
import org.cryptomator.common.recovery.RecoveryActionType;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.recoverykey.RecoveryKeyModule;
import org.cryptomator.ui.recoverykey.RecoveryKeyScoped;
import org.cryptomator.ui.recoverykey.RecoveryKeyWindow;

@RecoveryKeyScoped
@Subcomponent(modules={RecoveryKeyModule.class})
public interface RecoveryKeyComponent {
    @RecoveryKeyWindow
    public Stage window();

    @FxmlScene(value=FxmlFile.RECOVERYKEY_CREATE)
    public Lazy<Scene> creationScene();

    @FxmlScene(value=FxmlFile.RECOVERYKEY_RECOVER)
    public Lazy<Scene> recoverScene();

    @FxmlScene(value=FxmlFile.RECOVERYKEY_ONBOARDING)
    public Lazy<Scene> recoverOnboardingScene();

    default public void showRecoveryKeyCreationWindow() {
        Stage stage = this.window();
        stage.setScene((Scene)this.creationScene().get());
        stage.sizeToScene();
        stage.show();
    }

    default public void showRecoveryKeyRecoverWindow() {
        Stage stage = this.window();
        stage.setScene((Scene)this.recoverScene().get());
        stage.sizeToScene();
        stage.show();
    }

    default public void showOnboardingDialogWindow() {
        Stage stage = this.window();
        stage.setScene((Scene)this.recoverOnboardingScene().get());
        stage.sizeToScene();
        stage.show();
    }

    @Subcomponent.Factory
    public static interface Factory {
        public RecoveryKeyComponent create(@BindsInstance @RecoveryKeyWindow Vault var1, @BindsInstance @Named(value="keyRecoveryOwner") Stage var2, @BindsInstance @Named(value="recoverType") ObjectProperty<RecoveryActionType> var3);
    }
}

