/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.preferences;

import java.util.Locale;
import java.util.ResourceBundle;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.geometry.NodeOrientation;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.cryptomator.common.LicenseHolder;
import org.cryptomator.common.settings.Settings;
import org.cryptomator.common.settings.UiTheme;
import org.cryptomator.launcher.SupportedLanguages;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.preferences.PreferencesScoped;
import org.cryptomator.ui.preferences.SelectedPreferencesTab;
import org.cryptomator.ui.traymenu.TrayMenuComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreferencesScoped
public class InterfacePreferencesController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(InterfacePreferencesController.class);
    private final Settings settings;
    private final boolean trayMenuInitialized;
    private final boolean trayMenuSupported;
    private final ObjectProperty<SelectedPreferencesTab> selectedTabProperty;
    private final LicenseHolder licenseHolder;
    private final ResourceBundle resourceBundle;
    private final SupportedLanguages supportedLanguages;
    public ChoiceBox<UiTheme> themeChoiceBox;
    public CheckBox showTrayIconCheckbox;
    public CheckBox compactModeCheckbox;
    public ChoiceBox<String> preferredLanguageChoiceBox;
    public ToggleGroup nodeOrientation;
    public RadioButton nodeOrientationLtr;
    public RadioButton nodeOrientationRtl;

    @Inject
    InterfacePreferencesController(Settings settings, SupportedLanguages supportedLanguages, TrayMenuComponent trayMenu, ObjectProperty<SelectedPreferencesTab> selectedTabProperty, LicenseHolder licenseHolder, ResourceBundle resourceBundle) {
        this.settings = settings;
        this.trayMenuInitialized = trayMenu.isInitialized();
        this.trayMenuSupported = trayMenu.isSupported();
        this.selectedTabProperty = selectedTabProperty;
        this.licenseHolder = licenseHolder;
        this.resourceBundle = resourceBundle;
        this.supportedLanguages = supportedLanguages;
    }

    @FXML
    public void initialize() {
        this.themeChoiceBox.getItems().addAll((Object[])UiTheme.applicableValues());
        if (!this.themeChoiceBox.getItems().contains(this.settings.theme.get())) {
            this.settings.theme.set((Object)UiTheme.LIGHT);
        }
        this.themeChoiceBox.valueProperty().bindBidirectional(this.settings.theme);
        this.themeChoiceBox.setConverter((StringConverter)new UiThemeConverter(this.resourceBundle));
        this.showTrayIconCheckbox.selectedProperty().bindBidirectional((Property)this.settings.showTrayIcon);
        this.compactModeCheckbox.selectedProperty().bindBidirectional((Property)this.settings.compactMode);
        this.preferredLanguageChoiceBox.getItems().addAll(this.supportedLanguages.getLanguageTags());
        this.preferredLanguageChoiceBox.valueProperty().bindBidirectional((Property)this.settings.language);
        this.preferredLanguageChoiceBox.setConverter((StringConverter)new LanguageTagConverter(this.resourceBundle));
        this.nodeOrientationLtr.setSelected(this.settings.userInterfaceOrientation.get() == NodeOrientation.LEFT_TO_RIGHT);
        this.nodeOrientationRtl.setSelected(this.settings.userInterfaceOrientation.get() == NodeOrientation.RIGHT_TO_LEFT);
        this.nodeOrientation.selectedToggleProperty().addListener(this::toggleNodeOrientation);
    }

    public boolean isTrayMenuInitialized() {
        return this.trayMenuInitialized;
    }

    public boolean isTrayMenuSupported() {
        return this.trayMenuSupported;
    }

    private void toggleNodeOrientation(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
        if (this.nodeOrientationLtr.equals(newValue)) {
            this.settings.userInterfaceOrientation.set((Object)NodeOrientation.LEFT_TO_RIGHT);
        } else if (this.nodeOrientationRtl.equals(newValue)) {
            this.settings.userInterfaceOrientation.set((Object)NodeOrientation.RIGHT_TO_LEFT);
        } else {
            LOG.warn("Unexpected toggle option {}", (Object)newValue);
        }
    }

    public LicenseHolder getLicenseHolder() {
        return this.licenseHolder;
    }

    @FXML
    public void showContributeTab() {
        this.selectedTabProperty.set((Object)SelectedPreferencesTab.CONTRIBUTE);
    }

    private static class UiThemeConverter
    extends StringConverter<UiTheme> {
        private final ResourceBundle resourceBundle;

        UiThemeConverter(ResourceBundle resourceBundle) {
            this.resourceBundle = resourceBundle;
        }

        public String toString(UiTheme impl) {
            return this.resourceBundle.getString(impl.getDisplayName());
        }

        public UiTheme fromString(String string) {
            throw new UnsupportedOperationException();
        }
    }

    private static class LanguageTagConverter
    extends StringConverter<String> {
        private final ResourceBundle resourceBundle;

        LanguageTagConverter(ResourceBundle resourceBundle) {
            this.resourceBundle = resourceBundle;
        }

        public String toString(String tag) {
            if (tag == null) {
                return this.resourceBundle.getString("preferences.interface.language.auto");
            }
            Locale locale = Locale.forLanguageTag(tag);
            return locale.getDisplayName();
        }

        public String fromString(String displayLanguage) {
            throw new UnsupportedOperationException();
        }
    }
}

