/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.mainwindow;

import dagger.Binds;
import dagger.Lazy;
import dagger.Module;
import dagger.Provides;
import dagger.multibindings.IntoMap;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Named;
import javax.inject.Provider;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.ui.addvaultwizard.AddVaultWizardComponent;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxControllerKey;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlLoaderFactory;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.common.StageFactory;
import org.cryptomator.ui.common.StageInitializer;
import org.cryptomator.ui.error.ErrorComponent;
import org.cryptomator.ui.fxapp.FxApplicationTerminator;
import org.cryptomator.ui.fxapp.PrimaryStage;
import org.cryptomator.ui.mainwindow.MainWindow;
import org.cryptomator.ui.mainwindow.MainWindowController;
import org.cryptomator.ui.mainwindow.MainWindowSceneFactory;
import org.cryptomator.ui.mainwindow.MainWindowScoped;
import org.cryptomator.ui.mainwindow.VaultDetailController;
import org.cryptomator.ui.mainwindow.VaultDetailLockedController;
import org.cryptomator.ui.mainwindow.VaultDetailMissingVaultController;
import org.cryptomator.ui.mainwindow.VaultDetailNeedsMigrationController;
import org.cryptomator.ui.mainwindow.VaultDetailUnknownErrorController;
import org.cryptomator.ui.mainwindow.VaultDetailUnlockedController;
import org.cryptomator.ui.mainwindow.VaultListCellController;
import org.cryptomator.ui.mainwindow.VaultListContextMenuController;
import org.cryptomator.ui.mainwindow.VaultListController;
import org.cryptomator.ui.mainwindow.WelcomeController;
import org.cryptomator.ui.migration.MigrationComponent;
import org.cryptomator.ui.recoverykey.RecoveryKeyComponent;
import org.cryptomator.ui.stats.VaultStatisticsComponent;
import org.cryptomator.ui.traymenu.TrayMenuComponent;
import org.cryptomator.ui.wrongfilealert.WrongFileAlertComponent;

@Module(subcomponents={AddVaultWizardComponent.class, MigrationComponent.class, VaultStatisticsComponent.class, WrongFileAlertComponent.class, ErrorComponent.class, RecoveryKeyComponent.class})
abstract class MainWindowModule {
    MainWindowModule() {
    }

    @Provides
    @MainWindow
    @MainWindowScoped
    static Stage provideMainWindow(@PrimaryStage Stage stage, StageInitializer initializer, FxApplicationTerminator terminator, Lazy<TrayMenuComponent> trayMenu) {
        initializer.accept(stage);
        stage.setTitle("Cryptomator");
        stage.setMinWidth(650.0);
        stage.setMinHeight(498.0);
        stage.setOnCloseRequest(e -> {
            if (!((TrayMenuComponent)trayMenu.get()).isInitialized()) {
                terminator.terminate();
                e.consume();
            } else {
                stage.close();
            }
        });
        return stage;
    }

    @Provides
    @MainWindowScoped
    static ObjectProperty<Vault> provideSelectedVault() {
        return new SimpleObjectProperty();
    }

    @Provides
    @MainWindow
    @MainWindowScoped
    static FxmlLoaderFactory provideFxmlLoaderFactory(Map<Class<? extends FxController>, Provider<FxController>> factories, MainWindowSceneFactory sceneFactory, ResourceBundle resourceBundle) {
        return new FxmlLoaderFactory(factories, sceneFactory, resourceBundle);
    }

    @Provides
    @MainWindowScoped
    @Named(value="errorWindow")
    static Stage provideErrorStage(@MainWindow Stage window, StageFactory factory, ResourceBundle resourceBundle) {
        Stage stage = factory.create();
        stage.setTitle(resourceBundle.getString("main.vaultDetail.error.windowTitle"));
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.initOwner((Window)window);
        return stage;
    }

    @Provides
    @FxmlScene(value=FxmlFile.MAIN_WINDOW)
    @MainWindowScoped
    static Scene provideMainScene(@MainWindow FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.MAIN_WINDOW);
    }

    @Binds
    @IntoMap
    @FxControllerKey(value=MainWindowController.class)
    abstract FxController bindMainWindowController(MainWindowController var1);

    @Binds
    @IntoMap
    @FxControllerKey(value=VaultListController.class)
    abstract FxController bindVaultListController(VaultListController var1);

    @Binds
    @IntoMap
    @FxControllerKey(value=VaultListContextMenuController.class)
    abstract FxController bindVaultListContextMenuController(VaultListContextMenuController var1);

    @Binds
    @IntoMap
    @FxControllerKey(value=VaultDetailController.class)
    abstract FxController bindVaultDetailController(VaultDetailController var1);

    @Binds
    @IntoMap
    @FxControllerKey(value=WelcomeController.class)
    abstract FxController bindWelcomeController(WelcomeController var1);

    @Binds
    @IntoMap
    @FxControllerKey(value=VaultDetailLockedController.class)
    abstract FxController bindVaultDetailLockedController(VaultDetailLockedController var1);

    @Binds
    @IntoMap
    @FxControllerKey(value=VaultDetailUnlockedController.class)
    abstract FxController bindVaultDetailUnlockedController(VaultDetailUnlockedController var1);

    @Binds
    @IntoMap
    @FxControllerKey(value=VaultDetailMissingVaultController.class)
    abstract FxController bindVaultDetailMissingVaultController(VaultDetailMissingVaultController var1);

    @Binds
    @IntoMap
    @FxControllerKey(value=VaultDetailNeedsMigrationController.class)
    abstract FxController bindVaultDetailNeedsMigrationController(VaultDetailNeedsMigrationController var1);

    @Binds
    @IntoMap
    @FxControllerKey(value=VaultDetailUnknownErrorController.class)
    abstract FxController bindVaultDetailUnknownErrorController(VaultDetailUnknownErrorController var1);

    @Binds
    @IntoMap
    @FxControllerKey(value=VaultListCellController.class)
    abstract FxController bindVaultListCellController(VaultListCellController var1);
}

