/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.keyloading.masterkeyfile;

import java.io.File;
import java.nio.file.Path;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javax.inject.Inject;
import org.cryptomator.common.recovery.RecoveryActionType;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.keyloading.KeyLoading;
import org.cryptomator.ui.keyloading.masterkeyfile.ChooseMasterkeyFileScoped;
import org.cryptomator.ui.recoverykey.RecoveryKeyComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChooseMasterkeyFileScoped
public class ChooseMasterkeyFileController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(ChooseMasterkeyFileController.class);
    private final Stage window;
    private final Vault vault;
    private final CompletableFuture<Path> result;
    private final RecoveryKeyComponent.Factory recoveryKeyWindow;
    private final ResourceBundle resourceBundle;
    @FXML
    private CheckBox restoreInsteadCheckBox;
    @FXML
    private Button forwardButton;

    @Inject
    public ChooseMasterkeyFileController(@KeyLoading Stage window, @KeyLoading Vault vault, CompletableFuture<Path> result, RecoveryKeyComponent.Factory recoveryKeyWindow, ResourceBundle resourceBundle) {
        this.window = window;
        this.vault = vault;
        this.result = result;
        this.recoveryKeyWindow = recoveryKeyWindow;
        this.resourceBundle = resourceBundle;
        this.window.setOnHiding(this::windowClosed);
    }

    @FXML
    private void initialize() {
        this.restoreInsteadCheckBox.selectedProperty().addListener((observableValue, bl, newVal) -> {
            if (newVal.booleanValue()) {
                this.forwardButton.setText(this.resourceBundle.getString("addvaultwizard.existing.restore"));
                this.forwardButton.setOnAction(actionEvent -> this.restoreMasterkey());
            } else {
                this.forwardButton.setText(this.resourceBundle.getString("generic.button.choose"));
                this.forwardButton.setOnAction(actionEvent -> this.proceed());
            }
        });
    }

    @FXML
    public void cancel() {
        this.window.close();
    }

    private void windowClosed(WindowEvent windowEvent) {
        this.result.cancel(true);
    }

    @FXML
    void restoreMasterkey() {
        Stage ownerStage = (Stage)this.window.getOwner();
        this.window.close();
        this.recoveryKeyWindow.create(this.vault, ownerStage, (ObjectProperty<RecoveryActionType>)new SimpleObjectProperty((Object)RecoveryActionType.RESTORE_MASTERKEY)).showOnboardingDialogWindow();
    }

    @FXML
    public void proceed() {
        LOG.trace("proceed()");
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(this.resourceBundle.getString("unlock.chooseMasterkey.filePickerTitle"));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(this.resourceBundle.getString("unlock.chooseMasterkey.filePickerMimeDesc"), new String[]{"*.cryptomator"}));
        File masterkeyFile = fileChooser.showOpenDialog((Window)this.window);
        if (masterkeyFile != null) {
            LOG.debug("Chose masterkey file: {}", (Object)masterkeyFile);
            this.result.complete(masterkeyFile.toPath());
        }
    }

    public String getDisplayName() {
        return this.vault.getDisplayName();
    }
}

