/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.health;

import com.tobiasdiez.easybind.EasyBind;
import com.tobiasdiez.easybind.Subscription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javafx.animation.Animation;
import javafx.animation.SequentialTransition;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.util.Duration;
import javax.inject.Inject;
import org.cryptomator.cryptofs.health.api.DiagnosticResult;
import org.cryptomator.ui.common.Animations;
import org.cryptomator.ui.common.AutoAnimator;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.controls.FontAwesome5Icon;
import org.cryptomator.ui.controls.FontAwesome5IconView;
import org.cryptomator.ui.health.Result;
import org.cryptomator.ui.health.ResultFixApplier;

public class ResultListCellController
implements FxController {
    private static final FontAwesome5Icon INFO_ICON = FontAwesome5Icon.INFO_CIRCLE;
    private static final FontAwesome5Icon GOOD_ICON = FontAwesome5Icon.CHECK;
    private static final FontAwesome5Icon WARN_ICON = FontAwesome5Icon.EXCLAMATION_TRIANGLE;
    private static final FontAwesome5Icon CRIT_ICON = FontAwesome5Icon.TIMES;
    private final ObjectProperty<Result> result;
    private final ObservableValue<DiagnosticResult.Severity> severity;
    private final ObservableValue<String> description;
    private final ResultFixApplier fixApplier;
    private final ObservableValue<Result.FixState> fixState;
    private final ObjectBinding<FontAwesome5Icon> severityGlyph;
    private final BooleanBinding fixable;
    private final BooleanBinding fixing;
    private final BooleanBinding fixed;
    private final BooleanBinding fixFailed;
    private final BooleanBinding fixRunningOrDone;
    private final ObservableValue<FontAwesome5Icon> fixGlyph;
    private final List<Subscription> subscriptions;
    private final Tooltip fixStateTip;
    private final Tooltip severityTip;
    private AutoAnimator fixRunningRotator;
    private final ResourceBundle resourceBundle;
    public FontAwesome5IconView severityView;
    public FontAwesome5IconView fixView;

    @Inject
    public ResultListCellController(ResultFixApplier fixApplier, ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
        this.result = new SimpleObjectProperty(null);
        this.severity = this.result.map(Result::diagnosis).map(DiagnosticResult::getSeverity);
        this.description = this.result.map(Result::getDescription).orElse((Object)"");
        this.fixApplier = fixApplier;
        this.fixState = this.result.flatMap(Result::fixState);
        this.severityGlyph = Bindings.createObjectBinding(this::getSeverityGlyph, (Observable[])new Observable[]{this.result});
        this.fixable = Bindings.createBooleanBinding(this::isFixable, (Observable[])new Observable[]{this.fixState});
        this.fixing = Bindings.createBooleanBinding(this::isFixing, (Observable[])new Observable[]{this.fixState});
        this.fixed = Bindings.createBooleanBinding(this::isFixed, (Observable[])new Observable[]{this.fixState});
        this.fixFailed = Bindings.createBooleanBinding(this::isFixFailed, (Observable[])new Observable[]{this.fixState});
        this.fixRunningOrDone = this.fixing.or((ObservableBooleanValue)this.fixed).or((ObservableBooleanValue)this.fixFailed);
        this.fixGlyph = this.fixState.map(this::getFixGlyph);
        this.subscriptions = new ArrayList<Subscription>();
        this.fixStateTip = new Tooltip();
        this.fixStateTip.textProperty().bind(this.fixState.map(this::getFixStateDescription));
        this.fixStateTip.setShowDelay(Duration.millis((double)100.0));
        this.severityTip = new Tooltip();
        this.severityTip.textProperty().bind(this.severity.map(this::getSeverityDescription));
        this.severityTip.setShowDelay(Duration.millis((double)150.0));
    }

    public FontAwesome5Icon getFixGlyph(Result.FixState state) {
        return switch (state) {
            case Result.FixState.FIXING -> FontAwesome5Icon.SPINNER;
            case Result.FixState.FIXED -> FontAwesome5Icon.CHECK;
            case Result.FixState.FIX_FAILED -> FontAwesome5Icon.TIMES;
            default -> null;
        };
    }

    private String getFixStateDescription(Result.FixState fixState) {
        return switch (fixState) {
            case Result.FixState.FIXED -> this.resourceBundle.getString("health.fix.successTip");
            case Result.FixState.FIX_FAILED -> this.resourceBundle.getString("health.fix.failTip");
            default -> "";
        };
    }

    private String getSeverityDescription(DiagnosticResult.Severity severity) {
        return this.resourceBundle.getString(switch (severity) {
            default -> throw new MatchException(null, null);
            case DiagnosticResult.Severity.GOOD -> "health.result.severityTip.good";
            case DiagnosticResult.Severity.INFO -> "health.result.severityTip.info";
            case DiagnosticResult.Severity.WARN -> "health.result.severityTip.warn";
            case DiagnosticResult.Severity.CRITICAL -> "health.result.severityTip.crit";
        });
    }

    @FXML
    public void initialize() {
        this.subscriptions.addAll(List.of(EasyBind.includeWhen((Collection)this.severityView.getStyleClass(), (Object)"glyph-icon-muted", (ObservableValue)this.severity.map(arg_0 -> DiagnosticResult.Severity.INFO.equals(arg_0)).orElse((Object)false)), EasyBind.includeWhen((Collection)this.severityView.getStyleClass(), (Object)"glyph-icon-primary", (ObservableValue)this.severity.map(arg_0 -> DiagnosticResult.Severity.GOOD.equals(arg_0)).orElse((Object)false)), EasyBind.includeWhen((Collection)this.severityView.getStyleClass(), (Object)"glyph-icon-orange", (ObservableValue)this.severity.map(arg_0 -> DiagnosticResult.Severity.WARN.equals(arg_0)).orElse((Object)false)), EasyBind.includeWhen((Collection)this.severityView.getStyleClass(), (Object)"glyph-icon-red", (ObservableValue)this.severity.map(arg_0 -> DiagnosticResult.Severity.CRITICAL.equals(arg_0)).orElse((Object)false))));
        SequentialTransition animation = Animations.createDiscrete360Rotation((Node)this.fixView);
        this.fixRunningRotator = AutoAnimator.animate((Animation)animation).onCondition((ObservableValue<Boolean>)this.fixing).afterStop(() -> this.fixView.setRotate(0.0)).build();
        this.fixState.addListener((observable, oldValue, newValue) -> {
            if (newValue == Result.FixState.FIXED || newValue == Result.FixState.FIX_FAILED) {
                Tooltip.install((Node)this.fixView, (Tooltip)this.fixStateTip);
            }
        });
        Tooltip.install((Node)this.severityView, (Tooltip)this.severityTip);
    }

    @FXML
    public void fix() {
        Result r = (Result)this.result.get();
        if (r != null) {
            this.fixApplier.fix(r);
        }
    }

    public Result getResult() {
        return (Result)this.result.get();
    }

    public void setResult(Result result) {
        this.result.set((Object)result);
    }

    public ObjectProperty<Result> resultProperty() {
        return this.result;
    }

    public ObservableValue<String> descriptionProperty() {
        return this.description;
    }

    public String getDescription() {
        return (String)this.description.getValue();
    }

    public ObjectBinding<FontAwesome5Icon> severityGlyphProperty() {
        return this.severityGlyph;
    }

    public FontAwesome5Icon getSeverityGlyph() {
        Result r = (Result)this.result.get();
        if (r == null) {
            return null;
        }
        return switch (r.diagnosis().getSeverity()) {
            default -> throw new MatchException(null, null);
            case DiagnosticResult.Severity.INFO -> INFO_ICON;
            case DiagnosticResult.Severity.GOOD -> GOOD_ICON;
            case DiagnosticResult.Severity.WARN -> WARN_ICON;
            case DiagnosticResult.Severity.CRITICAL -> CRIT_ICON;
        };
    }

    public ObservableValue<FontAwesome5Icon> fixGlyphProperty() {
        return this.fixGlyph;
    }

    public FontAwesome5Icon getFixGlyph() {
        return (FontAwesome5Icon)((Object)this.fixGlyph.getValue());
    }

    public BooleanBinding fixableProperty() {
        return this.fixable;
    }

    public boolean isFixable() {
        return Result.FixState.FIXABLE.equals(this.fixState.getValue());
    }

    public BooleanBinding fixingProperty() {
        return this.fixing;
    }

    public boolean isFixing() {
        return Result.FixState.FIXING.equals(this.fixState.getValue());
    }

    public BooleanBinding fixedProperty() {
        return this.fixed;
    }

    public boolean isFixed() {
        return Result.FixState.FIXED.equals(this.fixState.getValue());
    }

    public BooleanBinding fixFailedProperty() {
        return this.fixFailed;
    }

    public Boolean isFixFailed() {
        return Result.FixState.FIX_FAILED.equals(this.fixState.getValue());
    }

    public BooleanBinding fixRunningOrDoneProperty() {
        return this.fixRunningOrDone;
    }

    public boolean isFixRunningOrDone() {
        return this.fixRunningOrDone.get();
    }
}

