/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.fxapp;

import com.google.common.base.Preconditions;
import dagger.Lazy;
import java.awt.Desktop;
import java.awt.desktop.QuitResponse;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import javafx.application.Platform;
import javafx.collections.ListChangeListener;
import javafx.collections.transformation.FilteredList;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Inject;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultState;
import org.cryptomator.integrations.tray.TrayIntegrationProvider;
import org.cryptomator.ui.dialogs.Dialogs;
import org.cryptomator.ui.dialogs.SimpleDialog;
import org.cryptomator.ui.error.ErrorComponent;
import org.cryptomator.ui.eventview.EventViewComponent;
import org.cryptomator.ui.fxapp.FxApplicationScoped;
import org.cryptomator.ui.fxapp.PrimaryStage;
import org.cryptomator.ui.lock.LockComponent;
import org.cryptomator.ui.mainwindow.MainWindowComponent;
import org.cryptomator.ui.preferences.PreferencesComponent;
import org.cryptomator.ui.preferences.SelectedPreferencesTab;
import org.cryptomator.ui.quit.QuitComponent;
import org.cryptomator.ui.sharevault.ShareVaultComponent;
import org.cryptomator.ui.unlock.UnlockComponent;
import org.cryptomator.ui.updatereminder.UpdateReminderComponent;
import org.cryptomator.ui.vaultoptions.SelectedVaultOptionsTab;
import org.cryptomator.ui.vaultoptions.VaultOptionsComponent;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FxApplicationScoped
public class FxApplicationWindows {
    private static final Logger LOG = LoggerFactory.getLogger(FxApplicationWindows.class);
    private final Stage primaryStage;
    private final Optional<TrayIntegrationProvider> trayIntegration;
    private final Lazy<MainWindowComponent> mainWindow;
    private final Lazy<PreferencesComponent> preferencesWindow;
    private final QuitComponent.Builder quitWindowBuilder;
    private final UnlockComponent.Factory unlockWorkflowFactory;
    private final UpdateReminderComponent.Factory updateReminderWindowFactory;
    private final LockComponent.Factory lockWorkflowFactory;
    private final ErrorComponent.Factory errorWindowFactory;
    private final Lazy<EventViewComponent> eventViewWindow;
    private final ExecutorService executor;
    private final VaultOptionsComponent.Factory vaultOptionsWindow;
    private final ShareVaultComponent.Factory shareVaultWindow;
    private final FilteredList<Window> visibleWindows;
    private final Dialogs dialogs;

    @Inject
    public FxApplicationWindows(@PrimaryStage Stage primaryStage, Optional<TrayIntegrationProvider> trayIntegration, Lazy<MainWindowComponent> mainWindow, Lazy<PreferencesComponent> preferencesWindow, QuitComponent.Builder quitWindowBuilder, UnlockComponent.Factory unlockWorkflowFactory, UpdateReminderComponent.Factory updateReminderWindowFactory, LockComponent.Factory lockWorkflowFactory, ErrorComponent.Factory errorWindowFactory, VaultOptionsComponent.Factory vaultOptionsWindow, ShareVaultComponent.Factory shareVaultWindow, Lazy<EventViewComponent> eventViewWindow, ExecutorService executor, Dialogs dialogs) {
        this.primaryStage = primaryStage;
        this.trayIntegration = trayIntegration;
        this.mainWindow = mainWindow;
        this.preferencesWindow = preferencesWindow;
        this.quitWindowBuilder = quitWindowBuilder;
        this.unlockWorkflowFactory = unlockWorkflowFactory;
        this.updateReminderWindowFactory = updateReminderWindowFactory;
        this.lockWorkflowFactory = lockWorkflowFactory;
        this.errorWindowFactory = errorWindowFactory;
        this.eventViewWindow = eventViewWindow;
        this.executor = executor;
        this.vaultOptionsWindow = vaultOptionsWindow;
        this.shareVaultWindow = shareVaultWindow;
        this.visibleWindows = Window.getWindows().filtered(Window::isShowing);
        this.dialogs = dialogs;
    }

    public void initialize() {
        Preconditions.checkState((boolean)Desktop.isDesktopSupported(), (Object)"java.awt.Desktop not supported");
        Desktop desktop = Desktop.getDesktop();
        if (desktop.isSupported(Desktop.Action.APP_PREFERENCES)) {
            desktop.setPreferencesHandler(preferencesEvent -> this.showPreferencesWindow(SelectedPreferencesTab.ANY));
        }
        if (desktop.isSupported(Desktop.Action.APP_ABOUT)) {
            desktop.setAboutHandler(aboutEvent -> this.showPreferencesWindow(SelectedPreferencesTab.ABOUT));
        }
        if (desktop.isSupported(Desktop.Action.APP_EVENT_REOPENED)) {
            desktop.addAppEventListener(appReopenedEvent -> this.showMainWindow());
        }
        if (this.trayIntegration.isPresent()) {
            this.visibleWindows.addListener(this::visibleWindowsChanged);
        }
    }

    private void visibleWindowsChanged(ListChangeListener.Change<? extends Window> change) {
        int visibleWindows = change.getList().size();
        LOG.debug("visible windows: {}", (Object)visibleWindows);
        if (visibleWindows > 0) {
            this.trayIntegration.ifPresent(TrayIntegrationProvider::restoredFromTray);
        } else {
            this.trayIntegration.ifPresent(TrayIntegrationProvider::minimizedToTray);
        }
    }

    public CompletionStage<Stage> showMainWindow() {
        return CompletableFuture.supplyAsync(((MainWindowComponent)this.mainWindow.get())::showMainWindow, Platform::runLater).whenComplete(this::reportErrors);
    }

    public CompletionStage<Stage> showPreferencesWindow(SelectedPreferencesTab selectedTab) {
        return CompletableFuture.supplyAsync(() -> ((PreferencesComponent)this.preferencesWindow.get()).showPreferencesWindow(selectedTab), Platform::runLater).whenComplete(this::reportErrors);
    }

    public void showShareVaultWindow(Vault vault) {
        CompletableFuture.runAsync(() -> this.shareVaultWindow.create(vault).showShareVaultWindow(), Platform::runLater);
    }

    public CompletionStage<Stage> showVaultOptionsWindow(Vault vault, SelectedVaultOptionsTab tab) {
        return this.showMainWindow().thenApplyAsync(stage -> this.vaultOptionsWindow.create(vault).showVaultOptionsWindow(tab), Platform::runLater).whenComplete(this::reportErrors);
    }

    public void showQuitWindow(QuitResponse response, boolean forced) {
        CompletableFuture.runAsync(() -> this.quitWindowBuilder.build().showQuitWindow(response, forced), Platform::runLater);
    }

    public void showUpdateReminderWindow() {
        CompletableFuture.runAsync(() -> this.updateReminderWindowFactory.create().showUpdateReminderWindow(), Platform::runLater);
    }

    public void showDokanySupportEndWindow() {
        CompletableFuture.runAsync(() -> this.createDokanySupportEndDialog().showAndWait(), Platform::runLater);
    }

    private SimpleDialog createDokanySupportEndDialog() {
        return this.dialogs.prepareDokanySupportEndDialog(((MainWindowComponent)this.mainWindow.get()).window(), stage -> {
            this.showPreferencesWindow(SelectedPreferencesTab.VOLUME);
            stage.close();
        }).build();
    }

    public CompletionStage<Void> startUnlockWorkflow(Vault vault, @Nullable Stage owner) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            Preconditions.checkState((boolean)vault.stateProperty().transition(VaultState.Value.LOCKED, VaultState.Value.PROCESSING), (Object)"Vault not locked.");
            LOG.debug("Start unlock workflow for {}", (Object)vault.getDisplayName());
            return this.unlockWorkflowFactory.create(vault, owner).unlockWorkflow();
        }, Platform::runLater).thenAcceptAsync(FutureTask::run, (Executor)this.executor)).exceptionally(e -> {
            this.showErrorWindow((Throwable)e, owner == null ? this.primaryStage : owner, null);
            return null;
        });
    }

    public CompletionStage<Void> startLockWorkflow(Vault vault, @Nullable Stage owner) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            Preconditions.checkState((boolean)vault.stateProperty().transition(VaultState.Value.UNLOCKED, VaultState.Value.PROCESSING), (Object)"Vault not unlocked.");
            LOG.debug("Start lock workflow for {}", (Object)vault.getDisplayName());
            return this.lockWorkflowFactory.create(vault, owner).lockWorkflow();
        }, Platform::runLater).thenCompose(lockWorkflow -> CompletableFuture.runAsync((Runnable)((Object)lockWorkflow), this.executor))).exceptionally(e -> {
            this.showErrorWindow((Throwable)e, owner == null ? this.primaryStage : owner, null);
            return null;
        });
    }

    public CompletionStage<Stage> showEventViewer() {
        return CompletableFuture.supplyAsync(() -> ((EventViewComponent)this.eventViewWindow.get()).showEventViewerWindow(), Platform::runLater).whenComplete(this::reportErrors);
    }

    public CompletionStage<Stage> showErrorWindow(Throwable cause, Stage window, @Nullable Scene previousScene) {
        return CompletableFuture.supplyAsync(() -> this.errorWindowFactory.create(cause, window, previousScene).show(), Platform::runLater).whenComplete(this::reportErrors);
    }

    private void reportErrors(@Nullable Stage stage, @Nullable Throwable error) {
        if (error != null) {
            LOG.error("Failed to display stage", error);
        }
    }
}

