/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.fxapp;

import dagger.Lazy;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javax.inject.Inject;
import javax.inject.Named;
import org.cryptomator.common.Environment;
import org.cryptomator.common.settings.Settings;
import org.cryptomator.common.settings.VaultSettings;
import org.cryptomator.ui.fxapp.AppLaunchEventHandler;
import org.cryptomator.ui.fxapp.AutoUnlocker;
import org.cryptomator.ui.fxapp.FxApplicationScoped;
import org.cryptomator.ui.fxapp.FxApplicationStyle;
import org.cryptomator.ui.fxapp.FxApplicationTerminator;
import org.cryptomator.ui.fxapp.FxApplicationWindows;
import org.cryptomator.ui.fxapp.FxFSEventList;
import org.cryptomator.ui.traymenu.TrayMenuComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FxApplicationScoped
public class FxApplication {
    private static final Logger LOG = LoggerFactory.getLogger(FxApplication.class);
    private final long startupTime;
    private final Environment environment;
    private final Settings settings;
    private final AppLaunchEventHandler launchEventHandler;
    private final Lazy<TrayMenuComponent> trayMenu;
    private final FxApplicationWindows appWindows;
    private final FxApplicationStyle applicationStyle;
    private final FxApplicationTerminator applicationTerminator;
    private final AutoUnlocker autoUnlocker;
    private final FxFSEventList fxFSEventList;

    @Inject
    FxApplication(@Named(value="startupTime") long startupTime, Environment environment, Settings settings, AppLaunchEventHandler launchEventHandler, Lazy<TrayMenuComponent> trayMenu, FxApplicationWindows appWindows, FxApplicationStyle applicationStyle, FxApplicationTerminator applicationTerminator, AutoUnlocker autoUnlocker, FxFSEventList fxFSEventList) {
        this.startupTime = startupTime;
        this.environment = environment;
        this.settings = settings;
        this.launchEventHandler = launchEventHandler;
        this.trayMenu = trayMenu;
        this.appWindows = appWindows;
        this.applicationStyle = applicationStyle;
        this.applicationTerminator = applicationTerminator;
        this.autoUnlocker = autoUnlocker;
        this.fxFSEventList = fxFSEventList;
    }

    public void start() {
        boolean hasTrayIcon;
        LOG.trace("FxApplication.start()");
        this.applicationStyle.initialize();
        this.appWindows.initialize();
        this.applicationTerminator.initialize();
        if (this.settings.showTrayIcon.get() && ((TrayMenuComponent)this.trayMenu.get()).isSupported()) {
            ((TrayMenuComponent)this.trayMenu.get()).initializeTrayIcon();
            Platform.setImplicitExit((boolean)false);
            hasTrayIcon = true;
        } else {
            hasTrayIcon = false;
        }
        this.appWindows.showMainWindow().thenAccept(stage -> {
            if (this.settings.startHidden.get()) {
                if (hasTrayIcon) {
                    stage.hide();
                } else {
                    stage.setIconified(true);
                }
            }
            LOG.debug("Main window initialized after {}ms", (Object)(System.currentTimeMillis() - this.startupTime));
        }).exceptionally(error -> {
            LOG.error("Failed to show main window", error);
            return null;
        });
        Instant time14DaysAgo = Instant.now().minus(Duration.ofDays(14L));
        if (!this.environment.disableUpdateCheck() && !this.settings.checkForUpdates.getValue().booleanValue() && ((Instant)this.settings.lastSuccessfulUpdateCheck.get()).isBefore(time14DaysAgo) && ((Instant)this.settings.lastUpdateCheckReminder.get()).isBefore(time14DaysAgo)) {
            this.appWindows.showUpdateReminderWindow();
        }
        this.migrateAndInformDokanyRemoval();
        this.launchEventHandler.startHandlingLaunchEvents();
        this.fxFSEventList.schedulePollForUpdates();
        this.autoUnlocker.tryUnlockForTimespan(2, TimeUnit.MINUTES);
    }

    private void migrateAndInformDokanyRemoval() {
        String dokanyProviderId = "org.cryptomator.frontend.dokany.mount.DokanyMountProvider";
        boolean dokanyFound = false;
        if (this.settings.mountService.getValueSafe().equals(dokanyProviderId)) {
            dokanyFound = true;
            this.settings.mountService.set(null);
        }
        for (VaultSettings vaultSettings : this.settings.directories) {
            if (!vaultSettings.mountService.getValueSafe().equals(dokanyProviderId)) continue;
            dokanyFound = true;
            vaultSettings.mountService.set(null);
        }
        if (dokanyFound) {
            this.appWindows.showDokanySupportEndWindow();
        }
    }
}

