/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.fxapp;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javax.inject.Inject;
import javax.inject.Named;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultListManager;
import org.cryptomator.launcher.AppLaunchEvent;
import org.cryptomator.ui.common.VaultService;
import org.cryptomator.ui.fxapp.FxApplicationScoped;
import org.cryptomator.ui.fxapp.FxApplicationWindows;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FxApplicationScoped
class AppLaunchEventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AppLaunchEventHandler.class);
    private final BlockingQueue<AppLaunchEvent> launchEventQueue;
    private final ExecutorService executorService;
    private final FxApplicationWindows appWindows;
    private final VaultListManager vaultListManager;
    private final VaultService vaultService;

    @Inject
    public AppLaunchEventHandler(@Named(value="launchEventQueue") BlockingQueue<AppLaunchEvent> launchEventQueue, ExecutorService executorService, FxApplicationWindows appWindows, VaultListManager vaultListManager, VaultService vaultService) {
        this.launchEventQueue = launchEventQueue;
        this.executorService = executorService;
        this.appWindows = appWindows;
        this.vaultListManager = vaultListManager;
        this.vaultService = vaultService;
    }

    public void startHandlingLaunchEvents() {
        this.executorService.submit(this::handleLaunchEvents);
    }

    private void handleLaunchEvents() {
        try {
            while (!Thread.interrupted()) {
                AppLaunchEvent event = this.launchEventQueue.take();
                this.handleLaunchEvent(event);
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted launch event handler.");
            Thread.currentThread().interrupt();
        }
    }

    private void handleLaunchEvent(AppLaunchEvent event) {
        switch (event.type()) {
            case REVEAL_APP: {
                this.appWindows.showMainWindow();
                break;
            }
            case OPEN_FILE: {
                Platform.runLater(() -> event.pathsToOpen().forEach(this::openPotentialVault));
                break;
            }
            default: {
                LOG.warn("Unsupported event type: {}", (Object)event.type());
            }
        }
    }

    private void openPotentialVault(Path path) {
        assert (Platform.isFxApplicationThread());
        try {
            Path potentialVaultPath = path.getFileName().toString().endsWith(".cryptomator") ? path.getParent() : path;
            Optional<Vault> v = this.vaultListManager.get(potentialVaultPath);
            if (v.isPresent()) {
                if (v.get().isUnlocked()) {
                    this.vaultService.reveal(v.get());
                } else if (v.get().isLocked()) {
                    this.appWindows.startUnlockWorkflow(v.get(), null);
                }
            } else {
                this.vaultListManager.add(potentialVaultPath);
                LOG.debug("Added vault {}", (Object)potentialVaultPath);
            }
        }
        catch (IOException e) {
            LOG.error("Failed to add vault " + String.valueOf(path), (Throwable)e);
        }
    }
}

