/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.eventview;

import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import dagger.multibindings.IntoMap;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javax.inject.Provider;
import org.cryptomator.ui.common.DefaultSceneFactory;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxControllerKey;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlLoaderFactory;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.common.StageFactory;
import org.cryptomator.ui.eventview.EventListCellController;
import org.cryptomator.ui.eventview.EventViewController;
import org.cryptomator.ui.eventview.EventViewScoped;
import org.cryptomator.ui.eventview.EventViewWindow;
import org.cryptomator.ui.fxapp.FxFSEventList;

@Module
abstract class EventViewModule {
    EventViewModule() {
    }

    @Provides
    @EventViewScoped
    @EventViewWindow
    static Stage provideStage(StageFactory factory, ResourceBundle resourceBundle, FxFSEventList fxFSEventList) {
        Stage stage = factory.create();
        stage.setHeight(498.0);
        stage.setTitle(resourceBundle.getString("eventView.title"));
        stage.setResizable(true);
        stage.initModality(Modality.NONE);
        stage.focusedProperty().addListener((observableValue, bl, isFocused) -> {
            if (isFocused.booleanValue()) {
                fxFSEventList.unreadEventsProperty().setValue(Boolean.valueOf(false));
            }
        });
        return stage;
    }

    @Provides
    @EventViewScoped
    @EventViewWindow
    static FxmlLoaderFactory provideFxmlLoaderFactory(Map<Class<? extends FxController>, Provider<FxController>> factories, DefaultSceneFactory sceneFactory, ResourceBundle resourceBundle) {
        return new FxmlLoaderFactory(factories, sceneFactory, resourceBundle);
    }

    @Provides
    @FxmlScene(value=FxmlFile.EVENT_VIEW)
    @EventViewScoped
    static Scene provideEventViewerScene(@EventViewWindow FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.EVENT_VIEW);
    }

    @Binds
    @IntoMap
    @FxControllerKey(value=EventViewController.class)
    abstract FxController bindEventViewController(EventViewController var1);

    @Binds
    @IntoMap
    @FxControllerKey(value=EventListCellController.class)
    abstract FxController bindEventListCellController(EventListCellController var1);
}

