/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.eventview;

import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.nio.file.Path;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Function;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.HBox;
import javafx.util.Duration;
import javax.inject.Inject;
import org.cryptomator.common.Nullable;
import org.cryptomator.common.ObservableUtil;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.cryptofs.CryptoPath;
import org.cryptomator.cryptofs.event.BrokenDirFileEvent;
import org.cryptomator.cryptofs.event.BrokenFileNodeEvent;
import org.cryptomator.cryptofs.event.ConflictResolutionFailedEvent;
import org.cryptomator.cryptofs.event.ConflictResolvedEvent;
import org.cryptomator.cryptofs.event.DecryptionFailedEvent;
import org.cryptomator.cryptofs.event.FilesystemEvent;
import org.cryptomator.event.FSEventBucket;
import org.cryptomator.event.FSEventBucketContent;
import org.cryptomator.event.FileSystemEventAggregator;
import org.cryptomator.integrations.revealpath.RevealFailedException;
import org.cryptomator.integrations.revealpath.RevealPathService;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.controls.FontAwesome5Icon;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventListCellController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(EventListCellController.class);
    private static final DateTimeFormatter LOCAL_DATE_FORMATTER = DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT).withZone(ZoneId.systemDefault());
    private static final DateTimeFormatter LOCAL_TIME_FORMATTER = DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT).withZone(ZoneId.systemDefault());
    private final FileSystemEventAggregator fileSystemEventAggregator;
    @Nullable
    private final RevealPathService revealService;
    private final ResourceBundle resourceBundle;
    private final ObjectProperty<Map.Entry<FSEventBucket, FSEventBucketContent>> eventEntry;
    private final StringProperty eventMessage;
    private final StringProperty eventDescription;
    private final ObjectProperty<FontAwesome5Icon> eventIcon;
    private final ObservableValue<String> eventCount;
    private final ObservableValue<Boolean> vaultUnlocked;
    private final ObservableValue<String> readableTime;
    private final ObservableValue<String> readableDate;
    private final ObservableValue<String> message;
    private final ObservableValue<String> description;
    private final ObservableValue<FontAwesome5Icon> icon;
    private final BooleanProperty actionsButtonVisible;
    private final Tooltip eventTooltip;
    @FXML
    HBox root;
    @FXML
    ContextMenu eventActionsMenu;
    @FXML
    Button eventActionsButton;

    @Inject
    public EventListCellController(FileSystemEventAggregator fileSystemEventAggregator, Optional<RevealPathService> revealService, ResourceBundle resourceBundle) {
        this.fileSystemEventAggregator = fileSystemEventAggregator;
        this.revealService = revealService.orElseGet(() -> null);
        this.resourceBundle = resourceBundle;
        this.eventEntry = new SimpleObjectProperty(null);
        this.eventMessage = new SimpleStringProperty();
        this.eventDescription = new SimpleStringProperty();
        this.eventIcon = new SimpleObjectProperty();
        this.eventCount = ObservableUtil.mapWithDefault(this.eventEntry, e -> ((FSEventBucketContent)e.getValue()).count() == 1 ? "" : "(" + ((FSEventBucketContent)e.getValue()).count() + ")", "");
        this.vaultUnlocked = ObservableUtil.mapWithDefault(this.eventEntry.flatMap(e -> ((FSEventBucket)e.getKey()).vault().unlockedProperty()), Function.identity(), false);
        this.readableTime = ObservableUtil.mapWithDefault(this.eventEntry, e -> LOCAL_TIME_FORMATTER.format(((FSEventBucketContent)e.getValue()).mostRecentEvent().getTimestamp()), "");
        this.readableDate = ObservableUtil.mapWithDefault(this.eventEntry, e -> LOCAL_DATE_FORMATTER.format(((FSEventBucketContent)e.getValue()).mostRecentEvent().getTimestamp()), "");
        this.message = Bindings.createStringBinding(this::selectMessage, (Observable[])new Observable[]{this.vaultUnlocked, this.eventMessage});
        this.description = Bindings.createStringBinding(this::selectDescription, (Observable[])new Observable[]{this.vaultUnlocked, this.eventDescription});
        this.icon = Bindings.createObjectBinding(this::selectIcon, (Observable[])new Observable[]{this.vaultUnlocked, this.eventIcon});
        this.actionsButtonVisible = new SimpleBooleanProperty();
        this.eventTooltip = new Tooltip();
        this.eventTooltip.setShowDelay(Duration.millis((double)500.0));
    }

    @FXML
    public void initialize() {
        this.actionsButtonVisible.bind((ObservableValue)Bindings.createBooleanBinding(this::determineActionsButtonVisibility, (Observable[])new Observable[]{this.root.hoverProperty(), this.eventActionsMenu.showingProperty(), this.vaultUnlocked}));
        this.vaultUnlocked.addListener((observableValue, bl, newValue) -> this.eventActionsMenu.hide());
        Tooltip.install((Node)this.root, (Tooltip)this.eventTooltip);
    }

    private boolean determineActionsButtonVisibility() {
        return (Boolean)this.vaultUnlocked.getValue() != false && (this.eventActionsMenu.isShowing() || this.root.isHover());
    }

    public void setEventEntry(@NotNull Map.Entry<FSEventBucket, FSEventBucketContent> item) {
        this.eventEntry.set(item);
        this.eventActionsMenu.hide();
        this.eventActionsMenu.getItems().clear();
        this.eventTooltip.setText(item.getKey().vault().getDisplayName());
        this.addAction("generic.action.dismiss", () -> this.fileSystemEventAggregator.remove((FSEventBucket)item.getKey()));
        FilesystemEvent filesystemEvent = item.getValue().mostRecentEvent();
        Objects.requireNonNull(filesystemEvent);
        FilesystemEvent filesystemEvent2 = filesystemEvent;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConflictResolvedEvent.class, ConflictResolutionFailedEvent.class, DecryptionFailedEvent.class, BrokenDirFileEvent.class, BrokenFileNodeEvent.class}, (FilesystemEvent)filesystemEvent2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                ConflictResolvedEvent fse = (ConflictResolvedEvent)filesystemEvent2;
                this.adjustToConflictResolvedEvent(fse);
                break;
            }
            case 1: {
                ConflictResolutionFailedEvent fse = (ConflictResolutionFailedEvent)filesystemEvent2;
                this.adjustToConflictEvent(fse);
                break;
            }
            case 2: {
                DecryptionFailedEvent fse = (DecryptionFailedEvent)filesystemEvent2;
                this.adjustToDecryptionFailedEvent(fse);
                break;
            }
            case 3: {
                BrokenDirFileEvent fse = (BrokenDirFileEvent)filesystemEvent2;
                this.adjustToBrokenDirFileEvent(fse);
                break;
            }
            case 4: {
                BrokenFileNodeEvent fse = (BrokenFileNodeEvent)filesystemEvent2;
                this.adjustToBrokenFileNodeEvent(fse);
            }
        }
    }

    private void adjustToBrokenFileNodeEvent(BrokenFileNodeEvent bfe) {
        this.eventIcon.setValue((Object)FontAwesome5Icon.TIMES);
        this.eventMessage.setValue(this.resourceBundle.getString("eventView.entry.brokenFileNode.message"));
        this.eventDescription.setValue(bfe.ciphertextPath().getFileName().toString());
        if (this.revealService != null) {
            this.addAction("eventView.entry.brokenFileNode.showEncrypted", () -> this.reveal(this.revealService, bfe.ciphertextPath()));
        } else {
            this.addAction("eventView.entry.brokenFileNode.copyEncrypted", () -> this.copyToClipboard(bfe.ciphertextPath().toString()));
        }
        this.addAction("eventView.entry.brokenFileNode.copyDecrypted", () -> this.copyToClipboard(this.convertVaultPathToSystemPath(bfe.cleartextPath()).toString()));
    }

    private void adjustToConflictResolvedEvent(ConflictResolvedEvent cre) {
        this.eventIcon.setValue((Object)FontAwesome5Icon.CHECK);
        this.eventMessage.setValue(this.resourceBundle.getString("eventView.entry.conflictResolved.message"));
        this.eventDescription.setValue(cre.resolvedCiphertextPath().getFileName().toString());
        if (this.revealService != null) {
            this.addAction("eventView.entry.conflictResolved.showDecrypted", () -> this.reveal(this.revealService, this.convertVaultPathToSystemPath(cre.resolvedCleartextPath())));
        } else {
            this.addAction("eventView.entry.conflictResolved.copyDecrypted", () -> this.copyToClipboard(this.convertVaultPathToSystemPath(cre.resolvedCleartextPath()).toString()));
        }
    }

    private void adjustToConflictEvent(ConflictResolutionFailedEvent cfe) {
        this.eventIcon.setValue((Object)FontAwesome5Icon.COMPRESS_ALT);
        this.eventMessage.setValue(this.resourceBundle.getString("eventView.entry.conflict.message"));
        this.eventDescription.setValue(cfe.conflictingCiphertextPath().getFileName().toString());
        if (this.revealService != null) {
            this.addAction("eventView.entry.conflict.showDecrypted", () -> this.reveal(this.revealService, this.convertVaultPathToSystemPath(cfe.canonicalCleartextPath())));
            this.addAction("eventView.entry.conflict.showEncrypted", () -> this.reveal(this.revealService, cfe.conflictingCiphertextPath()));
        } else {
            this.addAction("eventView.entry.conflict.copyDecrypted", () -> this.copyToClipboard(this.convertVaultPathToSystemPath(cfe.canonicalCleartextPath()).toString()));
            this.addAction("eventView.entry.conflict.copyEncrypted", () -> this.copyToClipboard(cfe.conflictingCiphertextPath().toString()));
        }
    }

    private void adjustToDecryptionFailedEvent(DecryptionFailedEvent dfe) {
        this.eventIcon.setValue((Object)FontAwesome5Icon.BAN);
        this.eventMessage.setValue(this.resourceBundle.getString("eventView.entry.decryptionFailed.message"));
        this.eventDescription.setValue(dfe.ciphertextPath().getFileName().toString());
        if (this.revealService != null) {
            this.addAction("eventView.entry.decryptionFailed.showEncrypted", () -> this.reveal(this.revealService, dfe.ciphertextPath()));
        } else {
            this.addAction("eventView.entry.decryptionFailed.copyEncrypted", () -> this.copyToClipboard(dfe.ciphertextPath().toString()));
        }
    }

    private void adjustToBrokenDirFileEvent(BrokenDirFileEvent bde) {
        this.eventIcon.setValue((Object)FontAwesome5Icon.TIMES);
        this.eventMessage.setValue(this.resourceBundle.getString("eventView.entry.brokenDirFile.message"));
        this.eventDescription.setValue(bde.ciphertextPath().getParent().getFileName().toString());
        if (this.revealService != null) {
            this.addAction("eventView.entry.brokenDirFile.showEncrypted", () -> this.reveal(this.revealService, bde.ciphertextPath()));
        } else {
            this.addAction("eventView.entry.brokenDirFile.copyEncrypted", () -> this.copyToClipboard(bde.ciphertextPath().toString()));
        }
    }

    private void addAction(String localizationKey, Runnable action) {
        MenuItem entry = new MenuItem(this.resourceBundle.getString(localizationKey));
        entry.getStyleClass().addLast((Object)"dropdown-button-context-menu-item");
        entry.setOnAction(actionEvent -> action.run());
        this.eventActionsMenu.getItems().addLast((Object)entry);
    }

    private FontAwesome5Icon selectIcon() {
        if (((Boolean)this.vaultUnlocked.getValue()).booleanValue()) {
            return (FontAwesome5Icon)((Object)this.eventIcon.getValue());
        }
        return FontAwesome5Icon.LOCK;
    }

    private String selectMessage() {
        if (((Boolean)this.vaultUnlocked.getValue()).booleanValue()) {
            return this.eventMessage.getValue();
        }
        return "***********";
    }

    private String selectDescription() {
        if (((Boolean)this.vaultUnlocked.getValue()).booleanValue()) {
            return this.eventDescription.getValue();
        }
        if (this.eventEntry.getValue() != null) {
            FSEventBucket e = (FSEventBucket)((Map.Entry)this.eventEntry.getValue()).getKey();
            return this.resourceBundle.getString("eventView.entry.vaultLocked.description").formatted(e != null ? e.vault().getDisplayName() : "");
        }
        return "";
    }

    @FXML
    public void toggleEventActionsMenu() {
        Map.Entry e = (Map.Entry)this.eventEntry.get();
        if (e != null) {
            if (this.eventActionsMenu.isShowing()) {
                this.eventActionsMenu.hide();
            } else {
                this.eventActionsMenu.show((Node)this.eventActionsButton, Side.BOTTOM, 0.0, 0.0);
            }
        }
    }

    private Path convertVaultPathToSystemPath(Path p) {
        if (!(p instanceof CryptoPath)) {
            throw new IllegalArgumentException("Path " + String.valueOf(p) + " is not a vault path");
        }
        Vault v = ((FSEventBucket)((Map.Entry)this.eventEntry.getValue()).getKey()).vault();
        if (!v.isUnlocked()) {
            return Path.of(System.getProperty("user.home"), new String[0]);
        }
        URI mountUri = v.getMountPoint().uri();
        String internalPath = p.toString().substring(1);
        return Path.of(mountUri.getPath().concat(internalPath).substring(1), new String[0]);
    }

    private void reveal(RevealPathService s, Path p) {
        try {
            s.reveal(p);
        }
        catch (RevealFailedException e) {
            LOG.warn("Failed to show path  {}", (Object)p, (Object)e);
        }
    }

    private void copyToClipboard(String s) {
        ClipboardContent content = new ClipboardContent();
        content.putString(s);
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    public ObservableValue<String> messageProperty() {
        return this.message;
    }

    public String getMessage() {
        return (String)this.message.getValue();
    }

    public ObservableValue<String> countProperty() {
        return this.eventCount;
    }

    public String getCount() {
        return (String)this.eventCount.getValue();
    }

    public ObservableValue<String> descriptionProperty() {
        return this.description;
    }

    public String getDescription() {
        return (String)this.description.getValue();
    }

    public ObservableValue<FontAwesome5Icon> iconProperty() {
        return this.icon;
    }

    public FontAwesome5Icon getIcon() {
        return (FontAwesome5Icon)((Object)this.icon.getValue());
    }

    public ObservableValue<Boolean> actionsButtonVisibleProperty() {
        return this.actionsButtonVisible;
    }

    public boolean isActionsButtonVisible() {
        return this.actionsButtonVisible.getValue();
    }

    public ObservableValue<String> eventLocalTimeProperty() {
        return this.readableTime;
    }

    public String getEventLocalTime() {
        return (String)this.readableTime.getValue();
    }

    public ObservableValue<String> eventLocalDateProperty() {
        return this.readableDate;
    }

    public String getEventLocalDate() {
        return (String)this.readableDate.getValue();
    }

    public ObservableValue<Boolean> vaultUnlockedProperty() {
        return this.vaultUnlocked;
    }

    public boolean isVaultUnlocked() {
        return (Boolean)this.vaultUnlocked.getValue();
    }
}

