/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.dialogs;

import java.util.ResourceBundle;
import java.util.function.Consumer;
import javafx.collections.ObservableList;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.cryptomator.common.settings.Settings;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.ui.common.DefaultSceneFactory;
import org.cryptomator.ui.common.StageFactory;
import org.cryptomator.ui.controls.FontAwesome5Icon;
import org.cryptomator.ui.dialogs.SimpleDialog;
import org.cryptomator.ui.fxapp.FxApplicationScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FxApplicationScoped
public class Dialogs {
    private final ResourceBundle resourceBundle;
    private final StageFactory stageFactory;
    private final DefaultSceneFactory sceneFactory;
    private static final String BUTTON_KEY_CLOSE = "generic.button.close";
    private static final Logger LOG = LoggerFactory.getLogger(Dialogs.class);

    @Inject
    public Dialogs(ResourceBundle resourceBundle, StageFactory stageFactory, DefaultSceneFactory sceneFactory) {
        this.resourceBundle = resourceBundle;
        this.stageFactory = stageFactory;
        this.sceneFactory = sceneFactory;
    }

    private SimpleDialog.Builder createDialogBuilder() {
        return new SimpleDialog.Builder(this.resourceBundle, this.stageFactory, this.sceneFactory);
    }

    public SimpleDialog.Builder prepareRemoveVaultDialog(Stage window, Vault vault, ObservableList<Vault> vaults) {
        return this.createDialogBuilder().setOwner(window).setTitleKey("removeVault.title", vault.getDisplayName()).setMessageKey("removeVault.message").setDescriptionKey("removeVault.description", new String[0]).setIcon(FontAwesome5Icon.QUESTION).setOkButtonKey("generic.button.remove").setCancelButtonKey("generic.button.cancel").setOkAction(stage -> {
            LOG.debug("Removing vault {}.", (Object)vault.getDisplayName());
            vaults.remove((Object)vault);
            stage.close();
        });
    }

    public SimpleDialog.Builder prepareContactHubVaultOwner(Stage window) {
        return this.createDialogBuilder().setOwner(window).setTitleKey("contactHubVaultOwner.title", new String[0]).setMessageKey("contactHubVaultOwner.message").setDescriptionKey("contactHubVaultOwner.description", new String[0]).setIcon(FontAwesome5Icon.EXCLAMATION).setOkButtonKey(BUTTON_KEY_CLOSE);
    }

    public SimpleDialog.Builder prepareRecoveryVaultAdded(Stage window, String displayName) {
        return this.createDialogBuilder().setOwner(window).setTitleKey("recover.existing.title", new String[0]).setMessageKey("recover.existing.message").setDescriptionKey("recover.existing.description", displayName).setIcon(FontAwesome5Icon.CHECK).setOkButtonKey(BUTTON_KEY_CLOSE);
    }

    public SimpleDialog.Builder prepareRecoveryVaultAlreadyExists(Stage window, String displayName) {
        return this.createDialogBuilder().setOwner(window).setTitleKey("recover.alreadyExists.title", new String[0]).setMessageKey("recover.alreadyExists.message").setDescriptionKey("recover.alreadyExists.description", displayName).setIcon(FontAwesome5Icon.EXCLAMATION).setOkButtonKey(BUTTON_KEY_CLOSE);
    }

    public SimpleDialog.Builder prepareRecoverPasswordSuccess(Stage window) {
        return this.createDialogBuilder().setOwner(window).setTitleKey("recoveryKey.recover.title", new String[0]).setMessageKey("recoveryKey.recover.resetSuccess.message").setDescriptionKey("recoveryKey.recover.resetSuccess.description", new String[0]).setIcon(FontAwesome5Icon.CHECK).setOkAction(Stage::close).setOkButtonKey(BUTTON_KEY_CLOSE);
    }

    public SimpleDialog.Builder prepareRemoveCertDialog(Stage window, Settings settings) {
        return this.createDialogBuilder().setOwner(window).setTitleKey("removeCert.title", new String[0]).setMessageKey("removeCert.message").setDescriptionKey("removeCert.description", new String[0]).setIcon(FontAwesome5Icon.QUESTION).setOkButtonKey("generic.button.remove").setCancelButtonKey("generic.button.cancel").setOkAction(stage -> {
            settings.licenseKey.set(null);
            stage.close();
        });
    }

    public SimpleDialog.Builder prepareDokanySupportEndDialog(Stage window, Consumer<Stage> cancelAction) {
        return this.createDialogBuilder().setOwner(window).setTitleKey("dokanySupportEnd.title", new String[0]).setMessageKey("dokanySupportEnd.message").setDescriptionKey("dokanySupportEnd.description", new String[0]).setIcon(FontAwesome5Icon.EXCLAMATION).setOkButtonKey(BUTTON_KEY_CLOSE).setCancelButtonKey("dokanySupportEnd.preferencesBtn").setOkAction(Stage::close).setCancelAction(cancelAction);
    }

    public SimpleDialog.Builder prepareRetryIfReadonlyDialog(Stage window, Consumer<Stage> okAction) {
        return this.createDialogBuilder().setOwner(window).setTitleKey("retryIfReadonly.title", new String[0]).setMessageKey("retryIfReadonly.message").setDescriptionKey("retryIfReadonly.description", new String[0]).setIcon(FontAwesome5Icon.EXCLAMATION).setOkButtonKey("retryIfReadonly.retry").setCancelButtonKey(BUTTON_KEY_CLOSE).setOkAction(okAction).setCancelAction(Stage::close);
    }

    public SimpleDialog.Builder prepareNoDDirectorySelectedDialog(Stage window) {
        return this.createDialogBuilder().setOwner(window).setTitleKey("recover.invalidSelection.title", new String[0]).setMessageKey("recover.invalidSelection.message").setDescriptionKey("recover.invalidSelection.description", new String[0]).setIcon(FontAwesome5Icon.EXCLAMATION).setOkButtonKey("generic.button.change").setOkAction(Stage::close);
    }
}

