/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.decryptname;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.TransferMode;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import javax.inject.Inject;
import org.apache.commons.lang3.SystemUtils;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.controls.FontAwesome5Icon;
import org.cryptomator.ui.decryptname.CipherAndCleartext;
import org.cryptomator.ui.decryptname.DecryptNameScoped;
import org.cryptomator.ui.decryptname.DecryptNameWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DecryptNameScoped
public class DecryptFileNamesViewController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(DecryptFileNamesViewController.class);
    private static final KeyCodeCombination COPY_TO_CLIPBOARD_SHORTCUT = new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN});
    private static final String COPY_TO_CLIPBOARD_SHORTCUT_STRING_WIN = "CTRL+C";
    private static final String COPY_TO_CLIPBOARD_SHORTCUT_STRING_MAC = "\u2318C";
    private static final String COPY_TO_CLIPBOARD_SHORTCUT_STRING_LINUX = "CTRL+C";
    private final ListProperty<CipherAndCleartext> mapping;
    private final StringProperty dropZoneText = new SimpleStringProperty();
    private final ObjectProperty<FontAwesome5Icon> dropZoneIcon = new SimpleObjectProperty();
    private final BooleanProperty wrongFilesSelected = new SimpleBooleanProperty(false);
    private final Stage window;
    private final Vault vault;
    private final ResourceBundle resourceBundle;
    private final List<Path> initialList;
    @FXML
    public TableColumn<CipherAndCleartext, String> ciphertextColumn;
    @FXML
    public TableColumn<CipherAndCleartext, String> cleartextColumn;
    @FXML
    public TableView<CipherAndCleartext> cipherToCleartextTable;

    @Inject
    public DecryptFileNamesViewController(@DecryptNameWindow Stage window, @DecryptNameWindow Vault vault, @DecryptNameWindow List<Path> pathsToDecrypt, ResourceBundle resourceBundle) {
        this.window = window;
        this.vault = vault;
        this.resourceBundle = resourceBundle;
        this.mapping = new SimpleListProperty(FXCollections.observableArrayList());
        this.initialList = pathsToDecrypt;
    }

    @FXML
    public void initialize() {
        this.cipherToCleartextTable.setItems(this.mapping);
        this.cipherToCleartextTable.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY_ALL_COLUMNS);
        this.cipherToCleartextTable.setOnDragEntered(event -> {
            if (event.getGestureSource() == null && event.getDragboard().hasFiles()) {
                this.cipherToCleartextTable.setItems(FXCollections.emptyObservableList());
            }
        });
        this.cipherToCleartextTable.setOnDragOver(event -> {
            if (event.getGestureSource() == null && event.getDragboard().hasFiles()) {
                if (SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_MAC) {
                    event.acceptTransferModes(new TransferMode[]{TransferMode.LINK});
                } else {
                    event.acceptTransferModes(TransferMode.ANY);
                }
            }
        });
        this.cipherToCleartextTable.setOnDragDropped(event -> {
            if (event.getGestureSource() == null && event.getDragboard().hasFiles()) {
                this.checkAndDecrypt(event.getDragboard().getFiles().stream().map(File::toPath).toList());
                this.cipherToCleartextTable.setItems(this.mapping);
            }
        });
        this.cipherToCleartextTable.setOnDragExited(dragEvent -> this.cipherToCleartextTable.setItems(this.mapping));
        this.cipherToCleartextTable.getSelectionModel().setCellSelectionEnabled(true);
        this.cipherToCleartextTable.setOnKeyPressed(keyEvent -> {
            if (COPY_TO_CLIPBOARD_SHORTCUT.match(keyEvent)) {
                this.copySingleCelltoClipboard();
            }
        });
        this.ciphertextColumn.setCellValueFactory((Callback)new PropertyValueFactory("ciphertextFilename"));
        this.cleartextColumn.setCellValueFactory((Callback)new PropertyValueFactory("cleartextName"));
        this.dropZoneText.setValue(this.resourceBundle.getString("decryptNames.dropZone.message"));
        this.dropZoneIcon.setValue((Object)FontAwesome5Icon.FILE_IMPORT);
        this.wrongFilesSelected.addListener((observableValue, bl, areWrongFiles) -> {
            if (areWrongFiles.booleanValue()) {
                CompletableFuture.delayedExecutor(5L, TimeUnit.SECONDS, Platform::runLater).execute(() -> {
                    this.dropZoneText.setValue(this.resourceBundle.getString("decryptNames.dropZone.message"));
                    this.dropZoneIcon.setValue((Object)FontAwesome5Icon.FILE_IMPORT);
                    this.wrongFilesSelected.setValue(Boolean.valueOf(false));
                });
            }
        });
        if (!this.initialList.isEmpty()) {
            this.checkAndDecrypt(this.initialList);
        }
    }

    private void copySingleCelltoClipboard() {
        this.cipherToCleartextTable.getSelectionModel().getSelectedCells().stream().findFirst().ifPresent(tablePosition -> {
            CipherAndCleartext selectedItem = (CipherAndCleartext)this.cipherToCleartextTable.getSelectionModel().getSelectedItem();
            if (tablePosition.getTableColumn().equals(this.ciphertextColumn)) {
                Clipboard.getSystemClipboard().setContent(Map.of(DataFormat.PLAIN_TEXT, selectedItem.ciphertext().toString()));
            } else {
                Clipboard.getSystemClipboard().setContent(Map.of(DataFormat.PLAIN_TEXT, selectedItem.cleartextName()));
            }
        });
    }

    @FXML
    public void selectFiles() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(this.resourceBundle.getString("decryptNames.filePicker.title"));
        fileChooser.setSelectedExtensionFilter(new FileChooser.ExtensionFilter(this.resourceBundle.getString("decryptNames.filePicker.extensionDescription"), List.of("*.c9r")));
        fileChooser.setInitialDirectory(this.vault.getPath().toFile());
        List ciphertextNodes = fileChooser.showOpenMultipleDialog((Window)this.window);
        if (ciphertextNodes != null) {
            this.checkAndDecrypt(ciphertextNodes.stream().map(File::toPath).toList());
        }
    }

    private void checkAndDecrypt(List<Path> pathsToDecrypt) {
        this.mapping.clear();
        Path testPath = pathsToDecrypt.getFirst();
        if (!testPath.startsWith(this.vault.getPath())) {
            this.setDropZoneError(this.resourceBundle.getString("decryptNames.dropZone.error.foreignFiles").formatted(this.vault.getDisplayName()));
            return;
        }
        if (pathsToDecrypt.size() == 1 && testPath.endsWith("dirid.c9r")) {
            this.setDropZoneError(this.resourceBundle.getString("decryptNames.dropZone.error.vaultInternalFiles"));
            return;
        }
        try {
            List<CipherAndCleartext> newMapping = pathsToDecrypt.stream().filter(p -> !p.endsWith("dirid.c9r")).map(this::getCleartextName).toList();
            this.mapping.addAll(newMapping);
        }
        catch (UncheckedIOException e) {
            this.setDropZoneError(this.resourceBundle.getString("decryptNames.dropZone.error.generic"));
            LOG.info("Failed to decrypt filenames for directory {}", (Object)testPath.getParent(), (Object)e);
        }
        catch (IllegalArgumentException e) {
            this.setDropZoneError(this.resourceBundle.getString("decryptNames.dropZone.error.vaultInternalFiles"));
        }
        catch (UnsupportedOperationException e) {
            this.setDropZoneError(this.resourceBundle.getString("decryptNames.dropZone.error.noDirIdBackup"));
        }
    }

    private void setDropZoneError(String text) {
        this.dropZoneIcon.setValue((Object)FontAwesome5Icon.TIMES);
        this.dropZoneText.setValue(text);
        this.wrongFilesSelected.setValue(Boolean.valueOf(true));
    }

    private CipherAndCleartext getCleartextName(Path ciphertextNode) {
        try {
            String cleartextName = this.vault.getCleartextName(ciphertextNode);
            return new CipherAndCleartext(ciphertextNode, cleartextName);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public ObservableValue<String> dropZoneTextProperty() {
        return this.dropZoneText;
    }

    public String getDropZoneText() {
        return (String)this.dropZoneText.get();
    }

    public ObservableValue<FontAwesome5Icon> dropZoneIconProperty() {
        return this.dropZoneIcon;
    }

    public FontAwesome5Icon getDropZoneIcon() {
        return (FontAwesome5Icon)((Object)this.dropZoneIcon.get());
    }

    public void clearTable() {
        this.mapping.clear();
    }

    public void copyTableToClipboard() {
        String csv = this.mapping.stream().map(cipherAndClear -> "\"" + String.valueOf(cipherAndClear.ciphertext()) + "\", \"" + cipherAndClear.cleartextName() + "\"").collect(Collectors.joining("\n"));
        Clipboard.getSystemClipboard().setContent(Map.of(DataFormat.PLAIN_TEXT, csv));
    }

    public String getCopyToClipboardShortcutString() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return "CTRL+C";
        }
        if (SystemUtils.IS_OS_MAC) {
            return COPY_TO_CLIPBOARD_SHORTCUT_STRING_MAC;
        }
        return "CTRL+C";
    }
}

