/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.convertvault;

import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import dagger.multibindings.IntoMap;
import java.io.IOException;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Named;
import javax.inject.Provider;
import org.cryptomator.common.recovery.RecoveryActionType;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.cryptofs.VaultConfig;
import org.cryptomator.cryptolib.api.CryptorProvider;
import org.cryptomator.cryptolib.common.MasterkeyFileAccess;
import org.cryptomator.ui.changepassword.NewPasswordController;
import org.cryptomator.ui.changepassword.PasswordStrengthUtil;
import org.cryptomator.ui.common.DefaultSceneFactory;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxControllerKey;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlLoaderFactory;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.common.StageFactory;
import org.cryptomator.ui.convertvault.ConvertVaultScoped;
import org.cryptomator.ui.convertvault.ConvertVaultWindow;
import org.cryptomator.ui.convertvault.HubToPasswordConvertController;
import org.cryptomator.ui.convertvault.HubToPasswordStartController;
import org.cryptomator.ui.convertvault.HubToPasswordSuccessController;
import org.cryptomator.ui.recoverykey.RecoveryKeyFactory;
import org.cryptomator.ui.recoverykey.RecoveryKeyValidateController;

@Module
abstract class ConvertVaultModule {
    ConvertVaultModule() {
    }

    @Provides
    @ConvertVaultWindow
    @ConvertVaultScoped
    static VaultConfig.UnverifiedVaultConfig vaultConfig(@ConvertVaultWindow Vault vault) {
        try {
            return vault.getVaultConfigCache().get();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Provides
    @ConvertVaultWindow
    @ConvertVaultScoped
    static StringProperty provideRecoveryKeyProperty() {
        return new SimpleStringProperty();
    }

    @Provides
    @ConvertVaultWindow
    @ConvertVaultScoped
    static FxmlLoaderFactory provideFxmlLoaderFactory(Map<Class<? extends FxController>, Provider<FxController>> factories, DefaultSceneFactory sceneFactory, ResourceBundle resourceBundle) {
        return new FxmlLoaderFactory(factories, sceneFactory, resourceBundle);
    }

    @Provides
    @ConvertVaultWindow
    @ConvertVaultScoped
    static Stage provideStage(StageFactory factory, @Named(value="convertVaultOwner") Stage owner, ResourceBundle resourceBundle) {
        Stage stage = factory.create();
        stage.setResizable(false);
        stage.initModality(Modality.WINDOW_MODAL);
        stage.initOwner((Window)owner);
        stage.setTitle(resourceBundle.getString("convertVault.title"));
        return stage;
    }

    @Provides
    @FxmlScene(value=FxmlFile.CONVERTVAULT_HUBTOPASSWORD_START)
    @ConvertVaultScoped
    static Scene provideHubToPasswordStartScene(@ConvertVaultWindow FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.CONVERTVAULT_HUBTOPASSWORD_START);
    }

    @Provides
    @FxmlScene(value=FxmlFile.CONVERTVAULT_HUBTOPASSWORD_CONVERT)
    @ConvertVaultScoped
    static Scene provideHubToPasswordConvertScene(@ConvertVaultWindow FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.CONVERTVAULT_HUBTOPASSWORD_CONVERT);
    }

    @Provides
    @FxmlScene(value=FxmlFile.CONVERTVAULT_HUBTOPASSWORD_SUCCESS)
    @ConvertVaultScoped
    static Scene provideHubToPasswordSuccessScene(@ConvertVaultWindow FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.CONVERTVAULT_HUBTOPASSWORD_SUCCESS);
    }

    @Binds
    @IntoMap
    @FxControllerKey(value=HubToPasswordStartController.class)
    abstract FxController bindHubToPasswordStartController(HubToPasswordStartController var1);

    @Binds
    @IntoMap
    @FxControllerKey(value=HubToPasswordConvertController.class)
    abstract FxController bindHubToPasswordConvertController(HubToPasswordConvertController var1);

    @Binds
    @IntoMap
    @FxControllerKey(value=HubToPasswordSuccessController.class)
    abstract FxController bindHubToPasswordSuccessController(HubToPasswordSuccessController var1);

    @Provides
    @IntoMap
    @FxControllerKey(value=NewPasswordController.class)
    static FxController provideNewPasswordController(ResourceBundle resourceBundle, PasswordStrengthUtil strengthRater) {
        return new NewPasswordController(resourceBundle, strengthRater);
    }

    @Provides
    @IntoMap
    @FxControllerKey(value=RecoveryKeyValidateController.class)
    static FxController provideRecoveryKeyValidateController(@ConvertVaultWindow Vault vault, @ConvertVaultWindow VaultConfig.UnverifiedVaultConfig vaultConfig, @ConvertVaultWindow StringProperty recoveryKey, RecoveryKeyFactory recoveryKeyFactory, MasterkeyFileAccess masterkeyFileAccess) {
        return new RecoveryKeyValidateController(vault, vaultConfig, recoveryKey, recoveryKeyFactory, masterkeyFileAccess, (ObjectProperty<RecoveryActionType>)new SimpleObjectProperty((Object)RecoveryActionType.CONVERT_VAULT), (ObjectProperty<CryptorProvider.Scheme>)new SimpleObjectProperty(null));
    }
}

