/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.changepassword;

import com.nulabinc.zxcvbn.Zxcvbn;
import java.util.List;
import java.util.ResourceBundle;
import javax.inject.Inject;
import org.cryptomator.common.Environment;
import org.cryptomator.ui.fxapp.FxApplicationScoped;

@FxApplicationScoped
public class PasswordStrengthUtil {
    private static final int PW_TRUNC_LEN = 100;
    private static final List<String> SANITIZED_INPUTS = List.of("cryptomator");
    private final ResourceBundle resourceBundle;
    private final int minPwLength;
    private final Zxcvbn zxcvbn;

    @Inject
    public PasswordStrengthUtil(ResourceBundle resourceBundle, Environment environment) {
        this.resourceBundle = resourceBundle;
        this.minPwLength = environment.getMinPwLength();
        this.zxcvbn = new Zxcvbn();
    }

    public boolean fulfillsMinimumRequirements(CharSequence password) {
        return password.length() >= this.minPwLength;
    }

    public int computeRate(CharSequence password) {
        if (password == null || password.length() < this.minPwLength) {
            return -1;
        }
        int numCharsToRate = Math.min(100, password.length());
        return this.zxcvbn.measure(password.subSequence(0, numCharsToRate), SANITIZED_INPUTS).getScore();
    }

    public String getStrengthDescription(Number score) {
        return switch (score.intValue()) {
            case -1 -> String.format(this.resourceBundle.getString("passwordStrength.messageLabel.tooShort"), this.minPwLength);
            case 0 -> this.resourceBundle.getString("passwordStrength.messageLabel.0");
            case 1 -> this.resourceBundle.getString("passwordStrength.messageLabel.1");
            case 2 -> this.resourceBundle.getString("passwordStrength.messageLabel.2");
            case 3 -> this.resourceBundle.getString("passwordStrength.messageLabel.3");
            case 4 -> this.resourceBundle.getString("passwordStrength.messageLabel.4");
            default -> "";
        };
    }
}

