/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.networking;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.cryptomator.networking.SSLContextProvider;

abstract class SSLContextDifferentTrustStoreBase
implements SSLContextProvider {
    SSLContextDifferentTrustStoreBase() {
    }

    abstract KeyStore getTruststore() throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException;

    @Override
    public SSLContext getContext(SecureRandom csprng) throws SSLContextProvider.SSLContextBuildException {
        try {
            KeyStore truststore = this.getTruststore();
            truststore.load(null, null);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(truststore);
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, tmf.getTrustManagers(), csprng);
            return context;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new SSLContextProvider.SSLContextBuildException(e);
        }
    }
}

