/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.launcher;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import dagger.Lazy;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.application.Application;
import javafx.stage.Stage;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.SystemUtils;
import org.cryptomator.common.Environment;
import org.cryptomator.common.ShutdownHook;
import org.cryptomator.common.SubstitutingProperties;
import org.cryptomator.ipc.IpcCommunicator;
import org.cryptomator.launcher.CryptomatorComponent;
import org.cryptomator.launcher.DaggerCryptomatorComponent;
import org.cryptomator.launcher.IpcMessageHandler;
import org.cryptomator.launcher.SupportedLanguages;
import org.cryptomator.logging.DebugMode;
import org.cryptomator.networking.SSLContextProvider;
import org.cryptomator.ui.fxapp.FxApplicationComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Cryptomator {
    private static final long STARTUP_TIME = System.currentTimeMillis();
    private static final CryptomatorComponent CRYPTOMATOR_COMPONENT;
    private static final Logger LOG;
    private final DebugMode debugMode;
    private final SupportedLanguages supportedLanguages;
    private final Environment env;
    private final Lazy<IpcMessageHandler> ipcMessageHandler;
    private final ShutdownHook shutdownHook;
    private final SecureRandom csprng;

    @Inject
    Cryptomator(DebugMode debugMode, SupportedLanguages supportedLanguages, Environment env, Lazy<IpcMessageHandler> ipcMessageHandler, ShutdownHook shutdownHook, SecureRandom csprng) {
        this.debugMode = debugMode;
        this.supportedLanguages = supportedLanguages;
        this.env = env;
        this.ipcMessageHandler = ipcMessageHandler;
        this.shutdownHook = shutdownHook;
        this.csprng = csprng;
    }

    public static void main(String[] args) {
        boolean printVersion = Optional.ofNullable(args).stream().flatMap(Arrays::stream).anyMatch(arg -> "-v".equals(arg) || "--version".equals(arg));
        if (printVersion) {
            String appVer = System.getProperty("cryptomator.appVersion", "SNAPSHOT");
            String buildNumber = System.getProperty("cryptomator.buildNumber", "SNAPSHOT");
            System.out.printf("Cryptomator version %s (build %s)%n", appVer, buildNumber);
            return;
        }
        int exitCode = CRYPTOMATOR_COMPONENT.application().run(args);
        LOG.info("Exit {}", (Object)exitCode);
        System.exit(exitCode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int run(String[] args) {
        this.env.log();
        LOG.debug("Dagger graph initialized after {}ms", (Object)(System.currentTimeMillis() - STARTUP_TIME));
        LOG.info("Starting Cryptomator {} on {} {} ({})", new Object[]{this.env.getAppVersion(), SystemUtils.OS_NAME, SystemUtils.OS_VERSION, SystemUtils.OS_ARCH});
        this.debugMode.initialize();
        this.supportedLanguages.applyPreferred();
        this.changeDefaultSSLContext();
        try (IpcCommunicator communicator = IpcCommunicator.create(this.env.getIpcSocketPath().toList());){
            if (communicator.isClient()) {
                communicator.sendHandleLaunchargs(List.of(args));
                communicator.sendRevealRunningApp();
                LOG.info("Found running application instance. Shutting down...");
                int n2 = 0;
                return n2;
            }
            this.shutdownHook.runOnShutdown(communicator::closeUnchecked);
            ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("IPC-%d").build());
            IpcMessageHandler msgHandler = (IpcMessageHandler)this.ipcMessageHandler.get();
            msgHandler.handleLaunchArgs(List.of(args));
            communicator.listen(msgHandler, executor);
            LOG.debug("Did not find running application instance. Launching GUI...");
            int n = this.runGuiApplication();
            return n;
        }
        catch (Throwable e) {
            LOG.error("Running application failed", e);
            return 1;
        }
    }

    private void changeDefaultSSLContext() {
        SSLContextProvider.loadAll().findFirst().ifPresent(p -> {
            try {
                SSLContext context = p.getContext(this.csprng);
                SSLContext.setDefault(context);
            }
            catch (SSLContextProvider.SSLContextBuildException e) {
                LOG.warn("Failed to change default SSL context with provider {}", (Object)p.getClass().getName(), (Object)e);
            }
        });
    }

    private int runGuiApplication() {
        try {
            Application.launch(MainApp.class, (String[])new String[0]);
            LOG.info("UI shut down");
            return 0;
        }
        catch (Exception e) {
            LOG.error("Terminating due to error", (Throwable)e);
            return 1;
        }
    }

    static {
        SubstitutingProperties lazyProcessedProps = new SubstitutingProperties(System.getProperties(), System.getenv());
        System.setProperties(lazyProcessedProps);
        CRYPTOMATOR_COMPONENT = DaggerCryptomatorComponent.factory().create(STARTUP_TIME);
        LOG = LoggerFactory.getLogger(Cryptomator.class);
    }

    public static class MainApp
    extends Application {
        public void start(Stage primaryStage) {
            LOG.info("JavaFX runtime started after {}ms", (Object)(System.currentTimeMillis() - STARTUP_TIME));
            FxApplicationComponent component = CRYPTOMATOR_COMPONENT.fxAppComponentBuilder().fxApplication(this).primaryStage(primaryStage).build();
            component.application().start();
        }

        public void stop() {
            LOG.info("JavaFX application stopped.");
        }
    }
}

