/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.event;

import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.cryptofs.event.BrokenDirFileEvent;
import org.cryptomator.cryptofs.event.BrokenFileNodeEvent;
import org.cryptomator.cryptofs.event.ConflictResolutionFailedEvent;
import org.cryptomator.cryptofs.event.ConflictResolvedEvent;
import org.cryptomator.cryptofs.event.DecryptionFailedEvent;
import org.cryptomator.cryptofs.event.FilesystemEvent;
import org.cryptomator.event.FSEventBucket;
import org.cryptomator.event.FSEventBucketContent;

@Singleton
public class FileSystemEventAggregator {
    private final ConcurrentHashMap<FSEventBucket, FSEventBucketContent> map = new ConcurrentHashMap();
    private final AtomicBoolean hasUpdates = new AtomicBoolean(false);

    @Inject
    public FileSystemEventAggregator() {
    }

    public void put(Vault v, FilesystemEvent e) {
        FSEventBucket key = FileSystemEventAggregator.computeKey(v, e);
        this.map.compute(key, (k, val) -> {
            if (val == null) {
                return new FSEventBucketContent(e, 1);
            }
            return new FSEventBucketContent(e, val.count() + 1);
        });
        this.hasUpdates.set(true);
    }

    public FSEventBucketContent remove(FSEventBucket key) {
        FSEventBucketContent content = this.map.remove(key);
        this.hasUpdates.set(true);
        return content;
    }

    public void clear() {
        this.map.clear();
        this.hasUpdates.set(true);
    }

    public boolean hasMaybeUpdates() {
        return this.hasUpdates.get();
    }

    public void cloneTo(Collection<Map.Entry<FSEventBucket, FSEventBucketContent>> target) {
        this.hasUpdates.set(false);
        target.clear();
        target.addAll(this.map.entrySet());
    }

    /*
     * Loose catch block
     */
    private static FSEventBucket computeKey(Vault v, FilesystemEvent event) {
        FilesystemEvent filesystemEvent = event;
        Objects.requireNonNull(filesystemEvent);
        FilesystemEvent filesystemEvent2 = filesystemEvent;
        int n = 0;
        Object p = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DecryptionFailedEvent.class, ConflictResolvedEvent.class, ConflictResolutionFailedEvent.class, BrokenDirFileEvent.class, BrokenFileNodeEvent.class}, (FilesystemEvent)filesystemEvent2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                DecryptionFailedEvent var5_5 = (DecryptionFailedEvent)filesystemEvent2;
                Object var7_6 = var5_5.timestamp();
                Object ciphertextPath = var7_6 = var5_5.ciphertextPath();
                var7_6 = var5_5.e();
                yield ciphertextPath;
            }
            case 1 -> {
                Object var7_6 = (ConflictResolvedEvent)filesystemEvent2;
                Object var9_8 = var7_6.timestamp();
                var9_8 = var7_6.canonicalCleartextPath();
                var9_8 = var7_6.conflictingCiphertextPath();
                var9_8 = var7_6.resolvedCleartextPath();
                Object resolvedCiphertext = var9_8 = var7_6.resolvedCiphertextPath();
                yield resolvedCiphertext;
            }
            case 2 -> {
                Object var9_8 = (ConflictResolutionFailedEvent)filesystemEvent2;
                Object var11_10 = var9_8.timestamp();
                var11_10 = var9_8.canonicalCleartextPath();
                Object conflictingCiphertext = var11_10 = var9_8.conflictingCiphertextPath();
                var11_10 = var9_8.reason();
                yield conflictingCiphertext;
            }
            case 3 -> {
                Object ciphertext;
                Object var11_10 = (BrokenDirFileEvent)filesystemEvent2;
                Object var13_12 = var11_10.timestamp();
                yield ciphertext = (var13_12 = var11_10.ciphertextPath());
            }
            case 4 -> {
                Object var13_12 = (BrokenFileNodeEvent)filesystemEvent2;
                Comparable<Instant> var15_14 = var13_12.timestamp();
                var15_14 = var13_12.cleartextPath();
                Comparable<Instant> ciphertext = var15_14 = var13_12.ciphertextPath();
                yield ciphertext;
            }
        };
        return new FSEventBucket(v, (Path)p, event.getClass());
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }
}

