/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.vaults;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReference;
import org.cryptomator.common.settings.VaultSettings;
import org.cryptomator.cryptofs.VaultConfig;

public class VaultConfigCache {
    private final VaultSettings settings;
    private final AtomicReference<VaultConfig.UnverifiedVaultConfig> config;

    public VaultConfigCache(VaultSettings settings) {
        this.settings = settings;
        this.config = new AtomicReference<Object>(null);
    }

    void reloadConfig() throws IOException {
        try {
            this.config.set(VaultConfigCache.readConfigFromStorage((Path)this.settings.path.get()));
        }
        catch (IOException e) {
            this.config.set(null);
            throw e;
        }
    }

    public VaultConfig.UnverifiedVaultConfig get() throws IOException {
        if (this.config.get() == null) {
            this.reloadConfig();
        }
        return this.config.get();
    }

    public VaultConfig.UnverifiedVaultConfig getUnchecked() {
        try {
            return this.get();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static VaultConfig.UnverifiedVaultConfig readConfigFromStorage(Path vaultPath) throws IOException {
        Path configPath = vaultPath.resolve("vault.cryptomator");
        String token = Files.readString(configPath, StandardCharsets.US_ASCII);
        return VaultConfig.decode((String)token);
    }
}

