/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.vaults;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ReadOnlyFileSystemException;
import java.util.EnumSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.SystemUtils;
import org.cryptomator.common.mount.Mounter;
import org.cryptomator.common.settings.Settings;
import org.cryptomator.common.settings.VaultSettings;
import org.cryptomator.common.vaults.PerVault;
import org.cryptomator.common.vaults.VaultConfigCache;
import org.cryptomator.common.vaults.VaultState;
import org.cryptomator.common.vaults.VaultStats;
import org.cryptomator.cryptofs.CryptoFileSystem;
import org.cryptomator.cryptofs.CryptoFileSystemProperties;
import org.cryptomator.cryptofs.CryptoFileSystemProvider;
import org.cryptomator.cryptofs.common.FileSystemCapabilityChecker;
import org.cryptomator.cryptofs.event.FilesystemEvent;
import org.cryptomator.cryptolib.api.CryptoException;
import org.cryptomator.cryptolib.api.MasterkeyLoader;
import org.cryptomator.cryptolib.api.MasterkeyLoadingFailedException;
import org.cryptomator.event.FileSystemEventAggregator;
import org.cryptomator.integrations.mount.MountFailedException;
import org.cryptomator.integrations.mount.Mountpoint;
import org.cryptomator.integrations.mount.UnmountFailedException;
import org.cryptomator.integrations.quickaccess.QuickAccessService;
import org.cryptomator.integrations.quickaccess.QuickAccessServiceException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PerVault
public class Vault {
    private static final Logger LOG = LoggerFactory.getLogger(Vault.class);
    private static final Path HOME_DIR = Paths.get(SystemUtils.USER_HOME, new String[0]);
    private static final int UNLIMITED_FILENAME_LENGTH = Integer.MAX_VALUE;
    private final VaultSettings vaultSettings;
    private final AtomicReference<CryptoFileSystem> cryptoFileSystem;
    private final AtomicReference<QuickAccessService.QuickAccessEntry> quickAccessEntry;
    private final VaultState state;
    private final ObjectProperty<Exception> lastKnownException;
    private final VaultConfigCache configCache;
    private final VaultStats stats;
    private final StringBinding displayablePath;
    private final BooleanBinding locked;
    private final BooleanBinding processing;
    private final BooleanBinding unlocked;
    private final BooleanBinding missing;
    private final BooleanBinding needsMigration;
    private final BooleanBinding unknownError;
    private final BooleanBinding missingVaultConfig;
    private final ObjectBinding<Mountpoint> mountPoint;
    private final Mounter mounter;
    private final Settings settings;
    private final FileSystemEventAggregator fileSystemEventAggregator;
    private final BooleanProperty showingStats;
    private final AtomicReference<Mounter.MountHandle> mountHandle = new AtomicReference<Object>(null);

    @Inject
    Vault(VaultSettings vaultSettings, VaultConfigCache configCache, AtomicReference<CryptoFileSystem> cryptoFileSystem, VaultState state, @Named(value="lastKnownException") ObjectProperty<Exception> lastKnownException, VaultStats stats, Mounter mounter, Settings settings, FileSystemEventAggregator fileSystemEventAggregator) {
        this.vaultSettings = vaultSettings;
        this.configCache = configCache;
        this.cryptoFileSystem = cryptoFileSystem;
        this.state = state;
        this.lastKnownException = lastKnownException;
        this.stats = stats;
        this.displayablePath = Bindings.createStringBinding(this::getDisplayablePath, (Observable[])new Observable[]{vaultSettings.path});
        this.locked = Bindings.createBooleanBinding(this::isLocked, (Observable[])new Observable[]{state});
        this.processing = Bindings.createBooleanBinding(this::isProcessing, (Observable[])new Observable[]{state});
        this.unlocked = Bindings.createBooleanBinding(this::isUnlocked, (Observable[])new Observable[]{state});
        this.missing = Bindings.createBooleanBinding(this::isMissing, (Observable[])new Observable[]{state});
        this.missingVaultConfig = Bindings.createBooleanBinding(this::isMissingVaultConfig, (Observable[])new Observable[]{state});
        this.needsMigration = Bindings.createBooleanBinding(this::isNeedsMigration, (Observable[])new Observable[]{state});
        this.unknownError = Bindings.createBooleanBinding(this::isUnknownError, (Observable[])new Observable[]{state});
        this.mountPoint = Bindings.createObjectBinding(this::getMountPoint, (Observable[])new Observable[]{state});
        this.mounter = mounter;
        this.settings = settings;
        this.fileSystemEventAggregator = fileSystemEventAggregator;
        this.showingStats = new SimpleBooleanProperty(false);
        this.quickAccessEntry = new AtomicReference<Object>(null);
    }

    private CryptoFileSystem createCryptoFileSystem(MasterkeyLoader keyLoader) throws IOException, MasterkeyLoadingFailedException {
        boolean createReadOnly;
        EnumSet<CryptoFileSystemProperties.FileSystemFlags> flags;
        block8: {
            flags = EnumSet.noneOf(CryptoFileSystemProperties.FileSystemFlags.class);
            createReadOnly = this.vaultSettings.usesReadOnlyMode.get();
            try {
                FileSystemCapabilityChecker.assertWriteAccess((Path)this.getPath());
            }
            catch (FileSystemCapabilityChecker.MissingCapabilityException e) {
                if (createReadOnly) break block8;
                throw new ReadOnlyFileSystemException();
            }
        }
        if (createReadOnly) {
            flags.add(CryptoFileSystemProperties.FileSystemFlags.READONLY);
        } else if (this.vaultSettings.maxCleartextFilenameLength.get() == -1) {
            LOG.debug("Determining cleartext filename length limitations...");
            int shorteningThreshold = this.configCache.get().allegedShorteningThreshold();
            int ciphertextLimit = FileSystemCapabilityChecker.determineSupportedCiphertextFileNameLength((Path)this.getPath());
            if (ciphertextLimit < shorteningThreshold) {
                int cleartextLimit = FileSystemCapabilityChecker.determineSupportedCleartextFileNameLength((Path)this.getPath());
                this.vaultSettings.maxCleartextFilenameLength.set(cleartextLimit);
            } else {
                this.vaultSettings.maxCleartextFilenameLength.setValue((Number)Integer.MAX_VALUE);
            }
        }
        if (this.vaultSettings.maxCleartextFilenameLength.get() < Integer.MAX_VALUE) {
            LOG.warn("Limiting cleartext filename length on this device to {}.", (Object)this.vaultSettings.maxCleartextFilenameLength.get());
        }
        CryptoFileSystemProperties fsProps = CryptoFileSystemProperties.cryptoFileSystemProperties().withKeyLoader(keyLoader).withFlags(flags).withMaxCleartextNameLength(this.vaultSettings.maxCleartextFilenameLength.get()).withVaultConfigFilename("vault.cryptomator").withFilesystemEventConsumer(this::consumeVaultEvent).build();
        return CryptoFileSystemProvider.newFileSystem((Path)this.getPath(), (CryptoFileSystemProperties)fsProps);
    }

    private void destroyCryptoFileSystem() {
        LOG.trace("Trying to close associated CryptoFS...");
        CryptoFileSystem fs = this.cryptoFileSystem.getAndSet(null);
        if (fs != null) {
            try {
                fs.close();
            }
            catch (IOException e) {
                LOG.error("Error closing file system.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unlock(MasterkeyLoader keyLoader) throws CryptoException, IOException, MountFailedException {
        if (this.cryptoFileSystem.get() != null) {
            throw new IllegalStateException("Already unlocked.");
        }
        CryptoFileSystem fs = this.createCryptoFileSystem(keyLoader);
        boolean success = false;
        try {
            this.cryptoFileSystem.set(fs);
            Path rootPath = (Path)fs.getRootDirectories().iterator().next();
            Mounter.MountHandle mountHandle = this.mounter.mount(this.vaultSettings, rootPath);
            success = this.mountHandle.compareAndSet(null, mountHandle);
            if (this.settings.useQuickAccess.getValue().booleanValue()) {
                this.addToQuickAccess();
            }
        }
        finally {
            if (!success) {
                this.destroyCryptoFileSystem();
            }
        }
    }

    public synchronized void lock(boolean forced) throws UnmountFailedException, IOException {
        Mounter.MountHandle mountHandle = this.mountHandle.get();
        if (mountHandle == null) {
            return;
        }
        if (forced && mountHandle.supportsUnmountForced()) {
            mountHandle.mountObj().unmountForced();
        } else {
            mountHandle.mountObj().unmount();
        }
        try {
            mountHandle.mountObj().close();
            mountHandle.specialCleanup().run();
        }
        finally {
            this.removeFromQuickAccess();
            this.destroyCryptoFileSystem();
        }
        this.mountHandle.set(null);
        LOG.info("Locked vault '{}'", (Object)this.getDisplayName());
    }

    private synchronized void addToQuickAccess() {
        if (this.quickAccessEntry.get() != null) {
            LOG.warn("Vault already added to quick access area. Will be removed on next lock operation.");
            return;
        }
        QuickAccessService.get().filter(s -> s.getClass().getName().equals(this.settings.quickAccessService.getValue())).findFirst().ifPresentOrElse(this::addToQuickAccessInternal, () -> LOG.warn("Unable to add Vault to quick access area: Desired implementation not available."));
    }

    private void addToQuickAccessInternal(@NotNull QuickAccessService s) {
        Mountpoint mountpoint = this.getMountPoint();
        if (mountpoint instanceof Mountpoint.WithPath) {
            Mountpoint.WithPath mp = (Mountpoint.WithPath)mountpoint;
            try {
                QuickAccessService.QuickAccessEntry entry = s.add(mp.path(), this.getDisplayName());
                this.quickAccessEntry.set(entry);
            }
            catch (QuickAccessServiceException e) {
                LOG.error("Adding vault to quick access area failed", (Throwable)e);
            }
        } else {
            LOG.warn("Unable to add vault to quick access area: Vault is not mounted to local system path.");
        }
    }

    private synchronized void removeFromQuickAccess() {
        if (this.quickAccessEntry.get() == null) {
            LOG.debug("Removing vault from quick access area: Entry not found, nothing to do.");
            return;
        }
        this.removeFromQuickAccessInternal();
    }

    private void removeFromQuickAccessInternal() {
        try {
            this.quickAccessEntry.get().remove();
            this.quickAccessEntry.set(null);
        }
        catch (QuickAccessServiceException e) {
            LOG.error("Removing vault from quick access area failed", (Throwable)e);
        }
    }

    private void consumeVaultEvent(FilesystemEvent e) {
        this.fileSystemEventAggregator.put(this, e);
    }

    public VaultState stateProperty() {
        return this.state;
    }

    public VaultState.Value getState() {
        return this.state.getValue();
    }

    public ObjectProperty<Exception> lastKnownExceptionProperty() {
        return this.lastKnownException;
    }

    public Exception getLastKnownException() {
        return (Exception)this.lastKnownException.get();
    }

    public void setLastKnownException(Exception e) {
        this.lastKnownException.setValue((Object)e);
    }

    public BooleanBinding lockedProperty() {
        return this.locked;
    }

    public boolean isLocked() {
        return this.state.get() == VaultState.Value.LOCKED;
    }

    public BooleanBinding processingProperty() {
        return this.processing;
    }

    public boolean isProcessing() {
        return this.state.get() == VaultState.Value.PROCESSING;
    }

    public BooleanBinding unlockedProperty() {
        return this.unlocked;
    }

    public boolean isUnlocked() {
        return this.state.get() == VaultState.Value.UNLOCKED;
    }

    public BooleanBinding missingProperty() {
        return this.missing;
    }

    public boolean isMissing() {
        return this.state.get() == VaultState.Value.MISSING;
    }

    public BooleanBinding needsMigrationProperty() {
        return this.needsMigration;
    }

    public boolean isNeedsMigration() {
        return this.state.get() == VaultState.Value.NEEDS_MIGRATION;
    }

    public BooleanBinding unknownErrorProperty() {
        return this.unknownError;
    }

    public boolean isUnknownError() {
        return this.state.get() == VaultState.Value.ERROR;
    }

    public BooleanBinding missingVaultConfigProperty() {
        return this.missingVaultConfig;
    }

    public boolean isMissingVaultConfig() {
        return this.state.get() == VaultState.Value.VAULT_CONFIG_MISSING || this.state.get() == VaultState.Value.ALL_MISSING;
    }

    public ReadOnlyStringProperty displayNameProperty() {
        return this.vaultSettings.displayName;
    }

    public String getDisplayName() {
        return (String)this.vaultSettings.displayName.get();
    }

    public ObjectBinding<Mountpoint> mountPointProperty() {
        return this.mountPoint;
    }

    public Mountpoint getMountPoint() {
        Mounter.MountHandle handle = this.mountHandle.get();
        return handle == null ? null : handle.mountObj().getMountpoint();
    }

    public StringBinding displayablePathProperty() {
        return this.displayablePath;
    }

    public String getDisplayablePath() {
        Path p = (Path)this.vaultSettings.path.get();
        if (p.startsWith(HOME_DIR)) {
            Path relativePath = HOME_DIR.relativize(p);
            String homePrefix = SystemUtils.IS_OS_WINDOWS ? "~\\" : "~/";
            return homePrefix + relativePath.toString();
        }
        return p.toString();
    }

    public BooleanProperty showingStatsProperty() {
        return this.showingStats;
    }

    public boolean isShowingStats() {
        return this.mountHandle.get() != null;
    }

    public VaultStats getStats() {
        return this.stats;
    }

    public Observable[] observables() {
        return new Observable[]{this.state};
    }

    public VaultSettings getVaultSettings() {
        return this.vaultSettings;
    }

    public Path getPath() {
        return (Path)this.vaultSettings.path.get();
    }

    public Path getCiphertextPath(Path cleartextPath) throws IOException {
        if (!this.state.getValue().equals((Object)VaultState.Value.UNLOCKED)) {
            throw new IllegalStateException("Vault is not unlocked");
        }
        CryptoFileSystem fs = this.cryptoFileSystem.get();
        String osPathSeparator = cleartextPath.getFileSystem().getSeparator();
        String cryptoFsPathSeparator = fs.getSeparator();
        Mountpoint mountpoint = this.getMountPoint();
        if (mountpoint instanceof Mountpoint.WithPath) {
            Mountpoint.WithPath mp = (Mountpoint.WithPath)mountpoint;
            Object absoluteCryptoFsPath = cryptoFsPathSeparator + mp.path().relativize(cleartextPath).toString();
            if (!cryptoFsPathSeparator.equals(osPathSeparator)) {
                absoluteCryptoFsPath = ((String)absoluteCryptoFsPath).replace(osPathSeparator, cryptoFsPathSeparator);
            }
            Path cryptoPath = fs.getPath((String)absoluteCryptoFsPath, new String[0]);
            return fs.getCiphertextPath(cryptoPath);
        }
        throw new UnsupportedOperationException("URI mount points not supported.");
    }

    public String getCleartextName(Path ciphertextPath) throws IOException {
        if (!this.state.getValue().equals((Object)VaultState.Value.UNLOCKED)) {
            throw new IllegalStateException("Vault is not unlocked");
        }
        CryptoFileSystem fs = this.cryptoFileSystem.get();
        return fs.getCleartextName(ciphertextPath);
    }

    public VaultConfigCache getVaultConfigCache() {
        return this.configCache;
    }

    public String getId() {
        return this.vaultSettings.id;
    }

    public int hashCode() {
        return Objects.hash(this.vaultSettings);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Vault) {
            Vault other = (Vault)obj;
            if (obj.getClass().equals(this.getClass())) {
                return Objects.equals(this.vaultSettings, other.vaultSettings);
            }
        }
        return false;
    }

    public boolean supportsForcedUnmount() {
        Mounter.MountHandle mh = this.mountHandle.get();
        if (mh == null) {
            throw new IllegalStateException("Vault is not mounted");
        }
        return this.mountHandle.get().supportsUnmountForced();
    }
}

