/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.settings;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import com.google.common.io.BaseEncoding;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Random;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import org.cryptomator.common.settings.VaultSettingsJson;
import org.cryptomator.common.settings.WhenUnlocked;
import org.jetbrains.annotations.VisibleForTesting;

public class VaultSettings {
    static final boolean DEFAULT_UNLOCK_AFTER_STARTUP = false;
    static final boolean DEFAULT_REVEAL_AFTER_MOUNT = true;
    static final boolean DEFAULT_USES_READONLY_MODE = false;
    static final String DEFAULT_MOUNT_FLAGS = "";
    static final int DEFAULT_MAX_CLEARTEXT_FILENAME_LENGTH = -1;
    static final WhenUnlocked DEFAULT_ACTION_AFTER_UNLOCK = WhenUnlocked.ASK;
    static final boolean DEFAULT_AUTOLOCK_WHEN_IDLE = false;
    static final int DEFAULT_AUTOLOCK_IDLE_SECONDS = 1800;
    static final int DEFAULT_PORT = 42427;
    private static final Random RNG = new Random();
    public final String id;
    public final ObjectProperty<Path> path;
    public final StringProperty displayName;
    public final BooleanProperty unlockAfterStartup;
    public final BooleanProperty revealAfterMount;
    public final BooleanProperty usesReadOnlyMode;
    public final StringProperty mountFlags;
    public final IntegerProperty maxCleartextFilenameLength;
    public final ObjectProperty<WhenUnlocked> actionAfterUnlock;
    public final BooleanProperty autoLockWhenIdle;
    public final IntegerProperty autoLockIdleSeconds;
    public final ObjectProperty<Path> mountPoint;
    public final StringExpression mountName;
    public final StringProperty mountService;
    public final IntegerProperty port;
    public final StringProperty lastKnownKeyLoader;

    VaultSettings(VaultSettingsJson json) {
        this.id = json.id;
        this.path = new SimpleObjectProperty((Object)this, "path", json.path == null ? null : Paths.get(json.path, new String[0]));
        this.displayName = new SimpleStringProperty((Object)this, "displayName", json.displayName);
        this.unlockAfterStartup = new SimpleBooleanProperty((Object)this, "unlockAfterStartup", json.unlockAfterStartup);
        this.revealAfterMount = new SimpleBooleanProperty((Object)this, "revealAfterMount", json.revealAfterMount);
        this.usesReadOnlyMode = new SimpleBooleanProperty((Object)this, "usesReadOnlyMode", json.usesReadOnlyMode);
        this.mountFlags = new SimpleStringProperty((Object)this, "mountFlags", json.mountFlags);
        this.maxCleartextFilenameLength = new SimpleIntegerProperty((Object)this, "maxCleartextFilenameLength", json.maxCleartextFilenameLength);
        this.actionAfterUnlock = new SimpleObjectProperty((Object)this, "actionAfterUnlock", (Object)json.actionAfterUnlock);
        this.autoLockWhenIdle = new SimpleBooleanProperty((Object)this, "autoLockWhenIdle", json.autoLockWhenIdle);
        this.autoLockIdleSeconds = new SimpleIntegerProperty((Object)this, "autoLockIdleSeconds", json.autoLockIdleSeconds);
        this.mountPoint = new SimpleObjectProperty((Object)this, "mountPoint", json.mountPoint == null ? null : Path.of(json.mountPoint, new String[0]));
        this.mountService = new SimpleStringProperty((Object)this, "mountService", json.mountService);
        this.port = new SimpleIntegerProperty((Object)this, "port", json.port);
        this.lastKnownKeyLoader = new SimpleStringProperty((Object)this, "lastKnownKeyLoader", json.lastKnownKeyLoader);
        this.mountName = StringExpression.stringExpression((ObservableValue)Bindings.createStringBinding(() -> {
            String name = this.displayName.isEmpty().get() ? ((Path)this.path.get()).getFileName().toString() : (String)this.displayName.get();
            return VaultSettings.normalizeDisplayName(name);
        }, (Observable[])new Observable[]{this.displayName, this.path}));
        this.migrateLegacySettings(json);
    }

    private void migrateLegacySettings(VaultSettingsJson json) {
        if (json.useCustomMountPath && !Strings.isNullOrEmpty((String)json.customMountPath)) {
            this.mountPoint.set((Object)Path.of(json.customMountPath, new String[0]));
        } else if (!Strings.isNullOrEmpty((String)json.winDriveLetter)) {
            this.mountPoint.set((Object)Path.of(json.winDriveLetter + ":\\", new String[0]));
        }
    }

    Observable[] observables() {
        return new Observable[]{this.actionAfterUnlock, this.autoLockIdleSeconds, this.autoLockWhenIdle, this.displayName, this.maxCleartextFilenameLength, this.mountFlags, this.mountPoint, this.path, this.revealAfterMount, this.unlockAfterStartup, this.usesReadOnlyMode, this.port, this.mountService, this.lastKnownKeyLoader};
    }

    public static VaultSettings withRandomId() {
        VaultSettingsJson defaults = new VaultSettingsJson();
        defaults.id = VaultSettings.generateId();
        return new VaultSettings(defaults);
    }

    private static String generateId() {
        byte[] randomBytes = new byte[9];
        RNG.nextBytes(randomBytes);
        return BaseEncoding.base64Url().encode(randomBytes);
    }

    VaultSettingsJson serialized() {
        VaultSettingsJson json = new VaultSettingsJson();
        json.id = this.id;
        json.path = (String)this.path.map(Path::toString).getValue();
        json.displayName = (String)this.displayName.get();
        json.unlockAfterStartup = this.unlockAfterStartup.get();
        json.revealAfterMount = this.revealAfterMount.get();
        json.usesReadOnlyMode = this.usesReadOnlyMode.get();
        json.mountFlags = (String)this.mountFlags.get();
        json.maxCleartextFilenameLength = this.maxCleartextFilenameLength.get();
        json.actionAfterUnlock = (WhenUnlocked)((Object)this.actionAfterUnlock.get());
        json.autoLockWhenIdle = this.autoLockWhenIdle.get();
        json.autoLockIdleSeconds = this.autoLockIdleSeconds.get();
        json.mountPoint = (String)this.mountPoint.map(Path::toString).getValue();
        json.mountService = (String)this.mountService.get();
        json.port = this.port.get();
        json.lastKnownKeyLoader = (String)this.lastKnownKeyLoader.get();
        return json;
    }

    @VisibleForTesting
    static String normalizeDisplayName(String original) {
        if (original.isBlank() || ".".equals(original) || "..".equals(original)) {
            return "_";
        }
        String withoutFancyWhitespaces = CharMatcher.whitespace().collapseFrom((CharSequence)original, ' ');
        return CharMatcher.anyOf((CharSequence)"<>:\"/\\|?*").or(CharMatcher.javaIsoControl()).collapseFrom((CharSequence)withoutFancyWhitespaces, '_');
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (obj instanceof VaultSettings) {
            VaultSettings other = (VaultSettings)obj;
            if (obj.getClass().equals(this.getClass())) {
                return Objects.equals(this.id, other.id);
            }
        }
        return false;
    }
}

